/**
 * Description: 回访录音记录数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-29 下午 16:40:18
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

/**
 * 回访录音记录数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-29
 * @see
 * @since 1.0
 */
public class ReceiveCallRecordEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 短号
     */
    @Length(max = 11, message = "长度需要大于0且小于11")
    private String caller;

    /**
     * 业务
     */

    private Integer pid;

    /**
     * 通话开始时间
     */

    private java.util.Date startTime;

    /**
     * 通话结束时间
     */

    private java.util.Date endTime;

    /**
     * 通话时长（秒）
     */

    private Integer duration;

    /**
     * 录音文件名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String record;

    /**
     * 接通状态 1接通 0未接通
     */

    private Integer status;

    //columns END
    /*
	public ReciveCallRecord(){
	}

	public ReciveCallRecord(
		Integer id
	){
		this.id = id;
	}

    */

    public String getCaller() {
        return caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    /**
     * 获取业务
     * @return 业务
     */
    public Integer getPid() {
        return this.pid;
    }

    /**
     * 设置业务
     * @param pid 业务
     */
    public void setPid(Integer pid) {
        this.pid = pid;
    }

    /**
     * 设置通话开始时间字符串格式
     * @param startTime 通话开始时间
     */
    public void setStartTimeStr(String startTime) {
        if (!com.house365.web.util.StringUtils.isBlank(startTime)) {
            try {
                this.startTime = java.text.DateFormat.getDateTimeInstance().parse(startTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取通话开始时间
     * @return 通话开始时间
     */
    public java.util.Date getStartTime() {
        return this.startTime;
    }

    /**
     * 设置通话开始时间
     * @param startTime 通话开始时间
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 设置通话结束时间字符串格式
     * @param endTime 通话结束时间
     */
    public void setEndTimeStr(String endTime) {
        if (!com.house365.web.util.StringUtils.isBlank(endTime)) {
            try {
                this.endTime = java.text.DateFormat.getDateTimeInstance().parse(endTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取通话结束时间
     * @return 通话结束时间
     */
    public java.util.Date getEndTime() {
        return this.endTime;
    }

    /**
     * 设置通话结束时间
     * @param endTime 通话结束时间
     */
    public void setEndTime(java.util.Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 获取通话时长（秒）
     * @return 通话时长（秒）
     */
    public Integer getDuration() {
        return this.duration;
    }

    /**
     * 设置通话时长（秒）
     * @param duration 通话时长（秒）
     */
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    /**
     * 获取录音文件名
     * @return 录音文件名
     */
    public String getRecord() {
        return this.record;
    }

    /**
     * 设置录音文件名
     * @param record 录音文件名
     */
    public void setRecord(String record) {
        this.record = record;
    }

    /**
     * 获取接通状态 1接通 0未接通
     * @return 接通状态 1接通 0未接通
     */
    public Integer getStatus() {
        return this.status;
    }

    /**
     * 设置接通状态 1接通 0未接通
     * @param status 接通状态 1接通 0未接通
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 实体的toString方法
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("Call", getCaller())
                .append("Pid", getPid())
                .append("StartTime", getStartTime())
                .append("EndTime", getEndTime())
                .append("Duration", getDuration())
                .append("Record", getRecord())
                .append("Status", getStatus())
                .toString();
    }

    /**
     * 获取hash码
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof ReceiveCallRecordEntity == false) return false;
        if (this == obj) return true;
        ReceiveCallRecordEntity other = (ReceiveCallRecordEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

