/**
 * Description: 公告数据库实体/领域对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:17
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import javax.validation.constraints.*;

import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.*;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * 公告数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public class NoticeEntity extends DomainObject {
    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 标题
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    @NotNull
    private String title;

    /**
     * 内容
     */
    @NotNull
    private String content;

    /**
     * 1 置顶 0 不置顶
     */
    @NotNull
    private java.lang.Boolean top;

    /**
     * 1 标红 0 不标红
     */
    @NotNull
    private java.lang.Boolean red;

    /**
     * 创建人用户ID
     */
    private Integer createUserid;

    /**
     * 创建人用户名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String createUsername;

    /**
     * 创建时间
     */
    private java.util.Date createTime;

    /**
     * 创建人电脑IP
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    private String createIp;

    /**
     * 最后一次修改人用户ID
     */

    private Integer updateUserid;

    /**
     * 最后一次修改人用户名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String updateUsername;

    /**
     * 最后一次修改时间
     */

    private java.util.Date updateTime;

    /**
     * 最后一次修改人电脑IP
     */
    @Length(max = 30, message = "长度需要大于0且小于30")
    private String updateIp;

    private String city;

    private String cityName;

    private String createTimeStr;

    private String updateTimeStr;

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 设置标题
     *
     * @param title 标题
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * 获取标题
     *
     * @return 标题
     */
    public String getTitle() {
        return this.title;
    }

    /**
     * 设置内容
     *
     * @param content 内容
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 获取内容
     *
     * @return 内容
     */
    public String getContent() {
        return this.content;
    }

    /**
     * 设置1 置顶 0 不置顶
     *
     * @param top 1 置顶 0 不置顶
     */
    public void setTop(java.lang.Boolean top) {
        this.top = top;
    }

    /**
     * 获取1 置顶 0 不置顶
     *
     * @return 1 置顶 0 不置顶
     */
    public java.lang.Boolean getTop() {
        return this.top;
    }

    /**
     * 设置1 标红 0 不标红
     *
     * @param red 1 标红 0 不标红
     */
    public void setRed(java.lang.Boolean red) {
        this.red = red;
    }

    /**
     * 获取1 标红 0 不标红
     *
     * @return 1 标红 0 不标红
     */
    public java.lang.Boolean getRed() {
        return this.red;
    }

    /**
     * 设置创建人用户ID
     *
     * @param createUserid 创建人用户ID
     */
    public void setCreateUserid(Integer createUserid) {
        this.createUserid = createUserid;
    }

    /**
     * 获取创建人用户ID
     *
     * @return 创建人用户ID
     */
    public Integer getCreateUserid() {
        return this.createUserid;
    }

    /**
     * 设置创建人用户名
     *
     * @param createUsername 创建人用户名
     */
    public void setCreateUsername(String createUsername) {
        this.createUsername = createUsername;
    }

    /**
     * 获取创建人用户名
     *
     * @return 创建人用户名
     */
    public String getCreateUsername() {
        return this.createUsername;
    }


    /**
     * 设置创建时间
     *
     * @param createTime 创建时间
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public String getUpdateTimeStr() {
        return updateTimeStr;
    }

    /**
     * 设置创建时间字符串格式
     *
     * @param createTime 创建时间
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
//                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
                this.createTimeStr = createTime;
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取创建时间
     *
     * @return 创建时间
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置创建人电脑IP
     *
     * @param createIp 创建人电脑IP
     */
    public void setCreateIp(String createIp) {
        this.createIp = createIp;
    }

    /**
     * 获取创建人电脑IP
     *
     * @return 创建人电脑IP
     */
    public String getCreateIp() {
        return this.createIp;
    }

    /**
     * 设置最后一次修改人用户ID
     *
     * @param updateUserid 最后一次修改人用户ID
     */
    public void setUpdateUserid(Integer updateUserid) {
        this.updateUserid = updateUserid;
    }

    /**
     * 获取最后一次修改人用户ID
     *
     * @return 最后一次修改人用户ID
     */
    public Integer getUpdateUserid() {
        return this.updateUserid;
    }

    /**
     * 设置最后一次修改人用户名
     *
     * @param updateUsername 最后一次修改人用户名
     */
    public void setUpdateUsername(String updateUsername) {
        this.updateUsername = updateUsername;
    }

    /**
     * 获取最后一次修改人用户名
     *
     * @return 最后一次修改人用户名
     */
    public String getUpdateUsername() {
        return this.updateUsername;
    }

    /**
     * 设置最后一次修改时间
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 设置最后一次修改时间字符串格式
     *
     * @param updateTime 最后一次修改时间
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
//                this.updateTime = java.text.DateFormat.getDateTimeInstance().parse(updateTime);
                this.updateTimeStr = updateTime;
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取最后一次修改时间
     *
     * @return 最后一次修改时间
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置最后一次修改人电脑IP
     *
     * @param updateIp 最后一次修改人电脑IP
     */
    public void setUpdateIp(String updateIp) {
        this.updateIp = updateIp;
    }

    /**
     * 获取最后一次修改人电脑IP
     *
     * @return 最后一次修改人电脑IP
     */
    public String getUpdateIp() {
        return this.updateIp;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("Title",
                                                                                                      getTitle()).append(
            "Content", getContent()).append("Top", getTop()).append("Red", getRed()).append("CreateUserid",
                                                                                            getCreateUserid()).append(
            "CreateUsername", getCreateUsername()).append("CreateTime", getCreateTime()).append("CreateIp",
                                                                                                getCreateIp()).append(
            "UpdateUserid", getUpdateUserid()).append("UpdateUsername", getUpdateUsername()).append("UpdateTime",
                                                                                                    getUpdateTime()).append(
            "UpdateIp", getUpdateIp()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    public boolean equals(Object obj) {
        if (obj instanceof NoticeEntity == false)
            return false;
        if (this == obj)
            return true;
        NoticeEntity other = (NoticeEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }
}

