/**
 * Description: 营销活动数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:20:59
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import com.house365.web.util.DateTimeUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import java.util.Date;

/**
 * 营销活动数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public class MarketingActivityEntity extends DomainObject {

    /**
     *
     */
    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 活动名称
     */
    @Length(max = 256, message = "长度需要大于0且小于256")
    private String name;

    private String activityName;

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    /**
     * 活动类型
     */
    private Integer type;

    private Integer activityId;

    public Integer getActivityId() {
        return activityId;
    }

    public void setActivityId(Integer activityId) {
        this.activityId = activityId;
    }

    /**
     * 周期（天）
     */
    private Integer cycle;

    private String buildingId;

    private String buildingName;

    private String browseProjectId;
    private String browseProject;

    public String getBrowseProjectId() {
        return browseProjectId;
    }

    public void setBrowseProjectId(String browseProjectId) {
        this.browseProjectId = browseProjectId;
    }

    public String getBrowseProject() {
        return browseProject;
    }

    public void setBrowseProject(String browseProject) {
        this.browseProject = browseProject;
    }

    public String getBuildingId() {
        return buildingId;
    }

    public void setBuildingId(String buildingId) {
        this.buildingId = buildingId;
    }

    public String getBuildingName() {
        return buildingName;
    }

    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    /**
     * 希望提取数
     */
    private Integer expectExtractCount;

    /**
     * 项目名称
     */
    @Length(max = 400, message = "长度需要大于0且小于400")
    private String projectName;

    /**
     * 电话类型 来源crm字典表
     */
    private Integer mobileType;

    //1 正常 2 删除 3 步骤一草稿(选择不导入)
    private Integer status;

    /**
     * 报名开始时间
     */
    private Date applyStartTime;

    /**
     * 报名截止时间
     */
    private Date applyEndTime;

    /**
     * 报名来源ID
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String applySource;

    /**
     * 活动报名类型
     */
    private Integer activeType;

    /**
     * 总价范围下限（万元）
     */
    private Integer totalPriceLower;

    /**
     * 总价范围上限（万元）
     */
    private Integer totalPriceHigher;

    /**
     * 面积范围下限（平方米）
     */
    private Integer areaLower;

    /**
     * 面积范围上限（平方米）
     */
    private Integer areaHigher;

    /**
     * 回访开始时间
     */
    private Date returnVisitTimeStart;

    /**
     * 回访结束时间
     */
    private Date returnVisitTimeEnd;

    /**
     * 回访状态
     */
    private Integer returnVisitStatus;

    /**
     * 回访结果
     */
    private String returnVisitResult;

    private String reVisitResult;

    public String getReVisitResult() {
        return reVisitResult;
    }

    public void setReVisitResult(String reVisitResult) {
        this.reVisitResult = reVisitResult;
    }

    /**
     * createBy
     */
    private Integer createBy;

    /**
     * createTime
     */
    private Date createTime;

    //createtime + cycle
    private Date finishTime;

    /**
     * updateBy
     */
    private Integer updateBy;

    /**
     * updateTime
     */
    private java.util.Date updateTime;

    /**
     * 获取量
     */
    private Integer gainCount;

    private Integer protectCount;

    /**
     * 超时量
     */
    private Integer overTimeCount;

    /**
     * 回访量
     */
    private Integer visitBackCount;

    /**
     * 待访量
     */
    private Integer waitVisitCount;

    //show not assign
    private Integer notAssign;

    /**
     * 认购量
     */
    private Integer boughtCount;

    /**
     * 报名来源名称
     */
    @Length(max = 600, message = "长度需要大于0且小于600")
    private String applySourceName;

    /**
     * 活动类型名称
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String activeTypeName;

    /**
     * 回访状态名称
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String returnVisitStatusName;

    private String city;

    private String createName;

    private String desc;

    @Length(max = 45, message = "长度需要大于0且小于100")
    //板块
    private String block;

    @Length(max = 150, message = "长度需要大于0且小于100")
    private String blockName;

    @Length(max = 45, message = "长度需要大于0且小于100")
    //区属
    private String district;

    @Length(max = 150, message = "长度需要大于0且小于100")
    private String districtName;

    @Length(max = 45, message = "长度需要大于0且小于100")
    //物业类型
    private String channel;

    @Length(max = 150, message = "长度需要大于0且小于100")
    private String channelName;

    @Length(max = 400, message = "长度需要大于0且小于100")
    //活动名称
    private String actName;

    @Length(max = 40, message = "长度需要大于0且小于100")
    //会员电话
    private String mobile;

    @Length(max = 10, message = "长度需要大于0且小于10")
    //回访次数
    private String callNum;
    //放弃数,列表展示用
    private int abandon;
    //回访并放弃
    private int callAbandon;
    //已派
    private Integer assign;

    private Date seeStartTime;
    private Date seeEndTime;
    private String seeProjectName;
    private int seeCount;
    private int queryCondStatus;

    public int getQueryCondStatus() {
        return queryCondStatus;
    }

    public void setQueryCondStatus(int queryCondStatus) {
        this.queryCondStatus = queryCondStatus;
    }

    private String descSub;

    public String getCallNum() {
        return callNum;
    }

    public void setCallNum(String callNum) {
        this.callNum = callNum;
    }

    public String getActName() {
        return actName;
    }

    public void setActName(String actName) {
        this.actName = actName;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getBlock() {
        return block;
    }

    public void setBlock(String block) {
        this.block = block;
    }

    public String getBlockName() {
        return blockName;
    }

    public void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    public String getDistrict() {
        return district;
    }

    public void setDistrict(String district) {
        this.district = district;
    }

    public String getDistrictName() {
        return districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getChannel() {
        return channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getNotAssign() {
        return notAssign;
    }

    public void setNotAssign(Integer notAssign) {
        this.notAssign = notAssign;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public Integer getProtectCount() {
        return protectCount;
    }

    public void setProtectCount(Integer protectCount) {
        this.protectCount = protectCount;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public void setFinishTimeStr(String finishTime) {
        if (!com.house365.web.util.StringUtils.isBlank(finishTime)) {
            this.finishTime = DateTimeUtils.parseDate(finishTime, DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_FULL);
        }
    }


    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 设置活动名称
     *
     * @param name 活动名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 获取活动名称
     *
     * @return 活动名称
     */
    public String getName() {
        return this.name;
    }

    /**
     * 设置活动类型
     * 1电商活动，2分销活动，3其他
     *
     * @param type 活动类型
     */
    public void setType(Integer type) {
        this.type = type;
    }

    /**
     * 获取活动类型
     *
     * @return 活动类型
     */
    public Integer getType() {
        return this.type;
    }

    /**
     * 设置周期（天）
     *
     * @param cycle 周期（天）
     */
    public void setCycle(Integer cycle) {
        this.cycle = cycle;
    }

    /**
     * 获取周期（天）
     *
     * @return 周期（天）
     */
    public Integer getCycle() {
        return this.cycle;
    }

    /**
     * 设置希望提取数
     *
     * @param expectExtractCount 希望提取数
     */
    public void setExpectExtractCount(Integer expectExtractCount) {
        this.expectExtractCount = expectExtractCount;
    }

    /**
     * 获取希望提取数
     *
     * @return 希望提取数
     */
    public Integer getExpectExtractCount() {
        return this.expectExtractCount;
    }

    /**
     * 设置项目名称
     *
     * @param projectName 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 获取项目名称
     *
     * @return 项目名称
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * 设置电话类型 1：手机；2：固话；
     *
     * @param mobileType 电话类型 1：手机；2：固话；
     */
    public void setMobileType(Integer mobileType) {
        this.mobileType = mobileType;
    }

    /**
     * 获取电话类型 1：手机；2：固话；
     *
     * @return 电话类型 1：手机；2：固话；
     */
    public Integer getMobileType() {
        return this.mobileType;
    }

    /**
     * 设置报名开始时间
     *
     * @param applyStartTime 报名开始时间
     */
    public void setApplyStartTime(java.util.Date applyStartTime) {
        this.applyStartTime = applyStartTime;
    }

    /**
     * 设置报名开始时间字符串格式
     *
     * @param applyStartTime 报名开始时间
     */
    public void setApplyStartTimeStr(String applyStartTime) {
        if (!com.house365.web.util.StringUtils.isBlank(applyStartTime)) {
            this.applyStartTime = DateTimeUtils.parseDate(applyStartTime,
                    DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_SHORT);
        }
    }

    /**
     * 获取报名开始时间
     *
     * @return 报名开始时间
     */
    public java.util.Date getApplyStartTime() {
        return this.applyStartTime;
    }

    /**
     * 设置报名截止时间
     *
     * @param applyEndTime 报名截止时间
     */
    public void setApplyEndTime(java.util.Date applyEndTime) {
        this.applyEndTime = applyEndTime;
    }

    /**
     * 设置报名截止时间字符串格式
     *
     * @param applyEndTime 报名截止时间
     */
    public void setApplyEndTimeStr(String applyEndTime) {
        if (!com.house365.web.util.StringUtils.isBlank(applyEndTime)) {
            this.applyEndTime = DateTimeUtils.parseDate(applyEndTime, DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_SHORT);
        }
    }

    /**
     * 获取报名截止时间
     *
     * @return 报名截止时间
     */
    public java.util.Date getApplyEndTime() {
        return this.applyEndTime;
    }

    /**
     * 设置报名来源ID
     *
     * @param applySource 报名来源ID
     */
    public void setApplySource(String applySource) {
        this.applySource = applySource;
    }

    /**
     * 获取报名来源ID
     *
     * @return 报名来源ID
     */
    public String getApplySource() {
        return this.applySource;
    }

    /**
     * 设置活动类型
     *
     * @param activeType 活动类型
     */
    public void setActiveType(Integer activeType) {
        this.activeType = activeType;
    }

    /**
     * 获取活动类型
     *
     * @return 活动类型
     */
    public Integer getActiveType() {
        return this.activeType;
    }

    /**
     * 设置总价范围下限（万元）
     *
     * @param totalPriceLower 总价范围下限（万元）
     */
    public void setTotalPriceLower(Integer totalPriceLower) {
        this.totalPriceLower = totalPriceLower;
    }

    /**
     * 获取总价范围下限（万元）
     *
     * @return 总价范围下限（万元）
     */
    public Integer getTotalPriceLower() {
        return this.totalPriceLower;
    }

    /**
     * 设置总价范围上限（万元）
     *
     * @param totalPriceHigher 总价范围上限（万元）
     */
    public void setTotalPriceHigher(Integer totalPriceHigher) {
        this.totalPriceHigher = totalPriceHigher;
    }

    /**
     * 获取总价范围上限（万元）
     *
     * @return 总价范围上限（万元）
     */
    public Integer getTotalPriceHigher() {
        return this.totalPriceHigher;
    }

    /**
     * 设置面积范围下限（平方米）
     *
     * @param areaLower 面积范围下限（平方米）
     */
    public void setAreaLower(Integer areaLower) {
        this.areaLower = areaLower;
    }

    /**
     * 获取面积范围下限（平方米）
     *
     * @return 面积范围下限（平方米）
     */
    public Integer getAreaLower() {
        return this.areaLower;
    }

    /**
     * 设置面积范围上限（平方米）
     *
     * @param areaHigher 面积范围上限（平方米）
     */
    public void setAreaHigher(Integer areaHigher) {
        this.areaHigher = areaHigher;
    }

    /**
     * 获取面积范围上限（平方米）
     *
     * @return 面积范围上限（平方米）
     */
    public Integer getAreaHigher() {
        return this.areaHigher;
    }

    /**
     * 设置回访开始时间
     *
     * @param returnVisitTimeStart 回访开始时间
     */
    public void setReturnVisitTimeStart(java.util.Date returnVisitTimeStart) {
        this.returnVisitTimeStart = returnVisitTimeStart;
    }

    /**
     * 设置回访开始时间字符串格式
     *
     * @param returnVisitTimeStart 回访开始时间
     */
    public void setReturnVisitTimeStartStr(String returnVisitTimeStart) {
        if (!com.house365.web.util.StringUtils.isBlank(returnVisitTimeStart)) {
            try {
                this.returnVisitTimeStart = java.text.DateFormat.getDateTimeInstance().parse(returnVisitTimeStart);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取回访开始时间
     *
     * @return 回访开始时间
     */
    public java.util.Date getReturnVisitTimeStart() {
        return this.returnVisitTimeStart;
    }

    /**
     * 设置回访结束时间
     *
     * @param returnVisitTimeEnd 回访结束时间
     */
    public void setReturnVisitTimeEnd(java.util.Date returnVisitTimeEnd) {
        this.returnVisitTimeEnd = returnVisitTimeEnd;
    }

    /**
     * 设置回访结束时间字符串格式
     *
     * @param returnVisitTimeEnd 回访结束时间
     */
    public void setReturnVisitTimeEndStr(String returnVisitTimeEnd) {
        if (!com.house365.web.util.StringUtils.isBlank(returnVisitTimeEnd)) {
            try {
                this.returnVisitTimeEnd = java.text.DateFormat.getDateTimeInstance().parse(returnVisitTimeEnd);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取回访结束时间
     *
     * @return 回访结束时间
     */
    public java.util.Date getReturnVisitTimeEnd() {
        return this.returnVisitTimeEnd;
    }

    /**
     * 设置回访状态
     *
     * @param returnVisitStatus 回访状态
     */
    public void setReturnVisitStatus(Integer returnVisitStatus) {
        this.returnVisitStatus = returnVisitStatus;
    }

    /**
     * 获取回访状态
     *
     * @return 回访状态
     */
    public Integer getReturnVisitStatus() {
        return this.returnVisitStatus;
    }

    /**
     * 设置回访结果
     *
     * @param returnVisitResult 回访结果
     */
    public void setReturnVisitResult(String returnVisitResult) {
        this.returnVisitResult = returnVisitResult;
    }

    /**
     * 获取回访结果
     *
     * @return 回访结果
     */
    public String getReturnVisitResult() {
        return this.returnVisitResult;
    }

    /**
     * 设置createBy
     *
     * @param createBy createBy
     */
    public void setCreateBy(Integer createBy) {
        this.createBy = createBy;
    }

    /**
     * 获取createBy
     *
     * @return createBy
     */
    public Integer getCreateBy() {
        return this.createBy;
    }

    /**
     * 设置createTime
     *
     * @param createTime createTime
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 设置createTime字符串格式
     *
     * @param createTime createTime
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = DateTimeUtils.parseDate(createTime, DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_FULL);
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取createTime
     *
     * @return createTime
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置updateBy
     *
     * @param updateBy updateBy
     */
    public void setUpdateBy(Integer updateBy) {
        this.updateBy = updateBy;
    }

    /**
     * 获取updateBy
     *
     * @return updateBy
     */
    public Integer getUpdateBy() {
        return this.updateBy;
    }

    /**
     * 设置updateTime
     *
     * @param updateTime updateTime
     */
    public void setUpdateTime(java.util.Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 设置updateTime字符串格式
     *
     * @param updateTime updateTime
     */
    public void setUpdateTimeStr(String updateTime) {
        if (!com.house365.web.util.StringUtils.isBlank(updateTime)) {
            try {
                this.updateTime = DateTimeUtils.parseDate(updateTime, DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_FULL);
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取updateTime
     *
     * @return updateTime
     */
    public java.util.Date getUpdateTime() {
        return this.updateTime;
    }

    /**
     * 设置获取量
     *
     * @param gainCount 获取量
     */
    public void setGainCount(Integer gainCount) {
        this.gainCount = gainCount;
    }

    /**
     * 获取获取量
     *
     * @return 获取量
     */
    public Integer getGainCount() {
        return this.gainCount;
    }

    /**
     * 设置超时量
     *
     * @param overTimeCount 超时量
     */
    public void setOverTimeCount(Integer overTimeCount) {
        this.overTimeCount = overTimeCount;
    }

    /**
     * 获取超时量
     *
     * @return 超时量
     */
    public Integer getOverTimeCount() {
        return this.overTimeCount;
    }

    /**
     * 设置回访量
     *
     * @param visitBackCount 回访量
     */
    public void setVisitBackCount(Integer visitBackCount) {
        this.visitBackCount = visitBackCount;
    }

    /**
     * 获取回访量
     *
     * @return 回访量
     */
    public Integer getVisitBackCount() {
        return this.visitBackCount;
    }

    /**
     * 设置待访量
     *
     * @param waitVisitCount 待访量
     */
    public void setWaitVisitCount(Integer waitVisitCount) {
        this.waitVisitCount = waitVisitCount;
    }

    /**
     * 获取待访量
     *
     * @return 待访量
     */
    public Integer getWaitVisitCount() {
        return this.waitVisitCount;
    }

    /**
     * 设置认购量
     *
     * @param boughtCount 认购量
     */
    public void setBoughtCount(Integer boughtCount) {
        this.boughtCount = boughtCount;
    }

    /**
     * 获取认购量
     *
     * @return 认购量
     */
    public Integer getBoughtCount() {
        return this.boughtCount;
    }

    /**
     * 设置报名来源名称
     *
     * @param applySourceName 报名来源名称
     */
    public void setApplySourceName(String applySourceName) {
        this.applySourceName = applySourceName;
    }

    /**
     * 获取报名来源名称
     *
     * @return 报名来源名称
     */
    public String getApplySourceName() {
        return this.applySourceName;
    }

    /**
     * 设置活动类型名称
     *
     * @param activeTypeName 活动类型名称
     */
    public void setActiveTypeName(String activeTypeName) {
        this.activeTypeName = activeTypeName;
    }

    /**
     * 获取活动类型名称
     *
     * @return 活动类型名称
     */
    public String getActiveTypeName() {
        return this.activeTypeName;
    }

    /**
     * 设置回访状态名称
     *
     * @param returnVisitStatusName 回访状态名称
     */
    public void setReturnVisitStatusName(String returnVisitStatusName) {
        this.returnVisitStatusName = returnVisitStatusName;
    }

    /**
     * 获取回访状态名称
     *
     * @return 回访状态名称
     */
    public String getReturnVisitStatusName() {
        return this.returnVisitStatusName;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE).append("Id", getId()).append("Name",
                getName()).append(
                "Type", getType()).append("Cycle", getCycle()).append("ExpectExtractCount", getExpectExtractCount()).append(
                "ProjectName", getProjectName()).append("MobileType", getMobileType()).append("ApplyStartTime",
                getApplyStartTime()).append(
                "ApplyEndTime", getApplyEndTime()).append("ApplySource", getApplySource()).append("ActiveType",
                getActiveType()).append(
                "TotalPriceLower", getTotalPriceLower()).append("TotalPriceHigher", getTotalPriceHigher()).append(
                "AreaLower", getAreaLower()).append("AreaHigher", getAreaHigher()).append("ReturnVisitTimeStart",
                getReturnVisitTimeStart()).append(
                "ReturnVisitTimeEnd", getReturnVisitTimeEnd()).append("ReturnVisitStatus", getReturnVisitStatus()).append(
                "ReturnVisitResult", getReturnVisitResult()).append("CreateBy", getCreateBy()).append("CreateTime",
                getCreateTime()).append(
                "UpdateBy", getUpdateBy()).append("UpdateTime", getUpdateTime()).append("GainCount", getGainCount()).append(
                "OverTimeCount", getOverTimeCount()).append("VisitBackCount", getVisitBackCount()).append("WaitVisitCount",
                getWaitVisitCount()).append(
                "BoughtCount", getBoughtCount()).append("ApplySourceName", getApplySourceName()).append("ActiveTypeName",
                getActiveTypeName()).append(
                "ReturnVisitStatusName", getReturnVisitStatusName()).toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(getId()).toHashCode();
    }

    /**
     * 对象比较
     *
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MarketingActivityEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MarketingActivityEntity other = (MarketingActivityEntity) obj;
        return new EqualsBuilder().append(getId(), other.getId()).isEquals();
    }

    public void setAbandon(int abandon) {
        this.abandon = abandon;
    }

    public int getAbandon() {
        return abandon;
    }

    public int getCallAbandon() {
        return callAbandon;
    }

    public void setCallAbandon(int callAbandon) {
        this.callAbandon = callAbandon;
    }

    public Integer getAssign() {
        return assign;
    }

    public void setAssign(Integer assign) {
        this.assign = assign;
    }

    public Date getSeeStartTime() {
        return seeStartTime;
    }

    public void setSeeStartTime(Date seeStartTime) {
        this.seeStartTime = seeStartTime;
    }

    public Date getSeeEndTime() {
        return seeEndTime;
    }

    public void setSeeEndTime(Date seeEndTime) {
        this.seeEndTime = seeEndTime;
    }

    public String getSeeProjectName() {
        return seeProjectName;
    }

    public void setSeeProjectName(String seeProjectName) {
        this.seeProjectName = seeProjectName;
    }

    public int getSeeCount() {
        return seeCount;
    }

    public void setSeeCount(int seeCount) {
        this.seeCount = seeCount;
    }

    public String getDescSub() {
        return descSub;
    }

    public void setDescSub(String descSub) {
        this.descSub = descSub;
    }
}

