package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;

import javax.validation.constraints.NotNull;

/**
 * 回访录音实体，由customer_callback_log和customer两张表集成
 *
 * @author Administrator
 * @date 2018/6/26
 */
public class CustomerCallbackRecordEntity extends DomainObject {

    private String name;
    private String phone;
    private String content;

    @NotNull
    private String callRecordName;

    private String managerName;
    private String createTime;

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCallRecordName() {
        return callRecordName;
    }

    public void setCallRecordName(String callRecordName) {
        this.callRecordName = callRecordName;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getName() {

        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof CustomerCallbackRecordEntity)) return false;
        if (!super.equals(o)) return false;

        CustomerCallbackRecordEntity that = (CustomerCallbackRecordEntity) o;

        if (name != null ? !name.equals(that.name) : that.name != null) return false;
        if (phone != null ? !phone.equals(that.phone) : that.phone != null) return false;
        if (content != null ? !content.equals(that.content) : that.content != null) return false;
        if (callRecordName != null ? !callRecordName.equals(that.callRecordName) : that.callRecordName != null)
            return false;
        if (managerName != null ? !managerName.equals(that.managerName) : that.managerName != null) return false;
        return createTime != null ? createTime.equals(that.createTime) : that.createTime == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (phone != null ? phone.hashCode() : 0);
        result = 31 * result + (content != null ? content.hashCode() : 0);
        result = 31 * result + (callRecordName != null ? callRecordName.hashCode() : 0);
        result = 31 * result + (managerName != null ? managerName.hashCode() : 0);
        result = 31 * result + (createTime != null ? createTime.hashCode() : 0);
        return result;
    }
}
