/**
 * Description: CustomerCallbackLog数据库实体/领域对象
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-29 下午 17:24:59
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-29   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.entity;

import com.house365.beans.system.DomainObject;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * CustomerCallbackLog数据库实体/领域对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-29
 * @see
 * @since 1.0
 */
public class CustomerCallbackLogEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    //可以直接使用: @Length(max=50,message="用户名长度不能大于50")显示错误消息
    //columns START
    /**
     * 客户ID
     */
    @NotNull
    private Integer customerId;

    /**
     * 客户经理ID
     */

    private Integer managerId;

    /**
     * 客户经理姓名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String managerName;

    private String phone;

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    /**
     * 回访内容
     */
    @NotBlank
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String content;

    /**
     * createTime
     */
    @NotNull
    private Date createTime;

    /**
     * 回访结果
     */
    @Length(max = 1000, message = "长度需要大于0且小于1000")
    private String result;

    /**
     * 创建人姓名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * projectId
     */

    private Integer projectId;

    /**
     * 录音记录id
     */

    private Integer callRecordId;

    /**
     * 录音文件名
     */
    @Length(max = 100, message = "长度需要大于0且小于100")
    private String callRecordName;

    /**
     * 录音总时长
     */

    private Integer callRecordDuration;

    //来源 1 待回访客户第一次回访记录
    private Integer source;

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    /**
     * 获取客户ID
     * @return 客户ID
     */
    public Integer getCustomerId() {
        return this.customerId;
    }

    /**
     * 设置客户ID
     *
     * @param customerId 客户ID
     */
    public void setCustomerId(Integer customerId) {
        this.customerId = customerId;
    }

    /**
     * 获取客户经理ID
     * @return 客户经理ID
     */
    public Integer getManagerId() {
        return this.managerId;
    }

    /**
     * 设置客户经理ID
     * @param managerId 客户经理ID
     */
    public void setManagerId(Integer managerId) {
        this.managerId = managerId;
    }

    /**
     * 获取客户经理姓名
     * @return 客户经理姓名
     */
    public String getManagerName() {
        return this.managerName;
    }

    /**
     * 设置客户经理姓名
     *
     * @param managerName 客户经理姓名
     */
    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    /**
     * 获取回访内容
     *
     * @return 回访内容
     */
    public String getContent() {
        return this.content;
    }

    /**
     * 设置回访内容
     * @param content 回访内容
     */
    public void setContent(String content) {
        this.content = content;
    }

    /**
     * 设置createTime字符串格式
     *
     * @param createTime createTime
     */
    public void setCreateTimeStr(String createTime) {
        if (!com.house365.web.util.StringUtils.isBlank(createTime)) {
            try {
                this.createTime = java.text.DateFormat.getDateTimeInstance().parse(createTime);
            } catch (java.text.ParseException ex) {
                ex.printStackTrace();
            }
        }
    }

    /**
     * 获取createTime
     *
     * @return createTime
     */
    public java.util.Date getCreateTime() {
        return this.createTime;
    }

    /**
     * 设置createTime
     * @param createTime createTime
     */
    public void setCreateTime(java.util.Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取回访结果
     *
     * @return 回访结果
     */
    public String getResult() {
        return this.result;
    }

    /**
     * 设置回访结果
     *
     * @param result 回访结果
     */
    public void setResult(String result) {
        this.result = result;
    }

    /**
     * 获取创建人姓名
     *
     * @return 创建人姓名
     */
    public String getCreater() {
        return this.creater;
    }

    /**
     * 设置创建人姓名
     *
     * @param creater 创建人姓名
     */
    public void setCreater(String creater) {
        this.creater = creater;
    }

    /**
     * 获取projectId
     *
     * @return projectId
     */
    public Integer getProjectId() {
        return this.projectId;
    }

    /**
     * 设置projectId
     *
     * @param projectId projectId
     */
    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    /**
     * 获取录音记录id
     *
     * @return 录音记录id
     */
    public Integer getCallRecordId() {
        return this.callRecordId;
    }

    /**
     * 设置录音记录id
     *
     * @param callRecordId 录音记录id
     */
    public void setCallRecordId(Integer callRecordId) {
        this.callRecordId = callRecordId;
    }

    /**
     * 获取录音文件名
     *
     * @return 录音文件名
     */
    public String getCallRecordName() {
        return this.callRecordName;
    }

    /**
     * 设置录音文件名
     *
     * @param callRecordName 录音文件名
     */
    public void setCallRecordName(String callRecordName) {
        this.callRecordName = callRecordName;
    }

    /**
     * 获取录音总时长
     *
     * @return 录音总时长
     */
    public Integer getCallRecordDuration() {
        return this.callRecordDuration;
    }

    /**
     * 设置录音总时长
     *
     * @param callRecordDuration 录音总时长
     */
    public void setCallRecordDuration(Integer callRecordDuration) {
        this.callRecordDuration = callRecordDuration;
    }

    /**
     * 实体的toString方法
     *
     * @return 实体字符串
     */
    @Override
    public String toString() {
        return new ToStringBuilder(this, ToStringStyle.MULTI_LINE_STYLE)
                .append("Id", getId())
                .append("CustomerId", getCustomerId())
                .append("ManagerId", getManagerId())
                .append("ManagerName", getManagerName())
                .append("Content", getContent())
                .append("CreateTime", getCreateTime())
                .append("Result", getResult())
                .append("Creater", getCreater())
                .append("ProjectId", getProjectId())
                .append("CallRecordId", getCallRecordId())
                .append("CallRecordName", getCallRecordName())
                .append("CallRecordDuration", getCallRecordDuration())
                .toString();
    }

    /**
     * 获取hash码
     *
     * @return HASH码
     */
    @Override
    public int hashCode() {
        return new HashCodeBuilder()
                .append(getId())
                .toHashCode();
    }

    /**
     * 对象比较
     * @param obj 待比较对象
     * @return 是否相同<li>true--相同<li>false--不相同
     */
    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CustomerCallbackLogEntity == false) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        CustomerCallbackLogEntity other = (CustomerCallbackLogEntity) obj;
        return new EqualsBuilder()
                .append(getId(), other.getId())
                .isEquals();
    }
}

