package com.house365.beans.entity;

import com.house365.beans.common.HGSConstant;
import com.house365.beans.system.DomainObject;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * 云迹活动客户实体类
 *
 * @author Created by Administrator on 2020/3/25.
 */
public class CloudCustomerEntity extends DomainObject {

    private static final long serialVersionUID = 1L;

    /**
     * 活动ID
     */
    @NotNull
    private Integer activeId;

    /**
     * 是否记录过超时操作
     */
    @NotNull
    private Integer isOvertime;

    /**
     * 姓名
     */
    @NotBlank
    @Length(max = 250, message = "长度需要大于0且小于250")
    private String name;

    /**
     * 手机
     */
    @NotBlank
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String phone;

    /**
     * 备用号码1
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone1;

    /**
     * 备用号码2
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone2;

    /**
     * 备用号码3
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bakPhone3;

    /**
     * 1 男 0 女 2 未知
     */
    private Integer sex;

    /**
     * 1 线上 2 线下
     */
    @NotNull
    private Integer customerType;

    /**
     * 活动名称－CRM
     */
    @NotBlank
    @Length(max = 300, message = "长度需要大于0且小于300")
    private String actSource;

    /**
     * 初次来源-CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String firstSource;

    /**
     * 最近来源-CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String latestSource;

    /**
     * 最近回访纪录－CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String crmLatestCall;

    /**
     * 最近回访结果－CRM
     */
    @Length(max = 150, message = "长度需要大于0且小于150")
    private String crmLatestCallResult;

    /**
     * 客户状态 0 待派 1 已派 2 超时 3 放弃
     * 待派：所有可以进行派工的数据，包括超时又返回至当前活动的数据内容。
     * 已派：所有已进行派工的数据。
     * 超时：超时且未派的数据。
     */
    private Integer status;

    /**
     * 创建来源 CRM SYSTEM
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String createSource;

    /**
     * 创建日期
     */
    @NotNull
    private Date createTime;

    /**
     * 创建人
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String creater;

    /**
     * 购房意向－CRM 3 高 2 中 1低
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String buyIntention;

    /**
     * 最后到访日期
     */
    private Date lastVisitTime;

    /**
     * 最后回访日期
     */
    private Date lastCallTime;

    /**
     * 客户经理ID
     */
    private Integer managerId;

    /**
     * 客户经理姓名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String managerName;

    /**
     * 更新日期
     */
    @NotNull
    private Date updateTime;

    /**
     * 最后修改人
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String updater;

    /**
     * 城市
     */
    @NotBlank
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String cityCode;

    /**
     * 业务条口
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String bizPort;

    /**
     * CRM id
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String crmId;

    /**
     * 城市名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String cityName;

    /**
     * 活动来源ID
     */
    private Integer actSourceId;

    /**
     * 备注
     */
    @Length(max = 600, message = "长度需要大于0且小于600")
    private String remark;

    /**
     * 跟踪状态 1：有效；2：已购；3：我购；4：暂缓；
     */
    @NotNull
    private Integer traceStatus;

    /**
     * 是否已推送到CRM，1是0否，保护期同步任务使用
     */
    @Length(max = 2, message = "长度需要大于0且小于2")
    private String crmSync;

    /**
     * hotlineCallTime
     */
    private Date hotlineCallTime;

    /**
     * hotlineCallSpend
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String hotlineCallSpend;

    /**
     * 入公海时间
     */
    private Date oceanDate;

    /**
     * 公海无效客户可删除 是否删除 1 是 0 否
     */
    private Integer isDelete;

    /**
     * 移到公海后记录原客户经理名
     */
    @Length(max = 45, message = "长度需要大于0且小于45")
    private String lastManager;

    /**
     * bindTime
     */
    private Date bindTime;

    private Integer customerId;

    /**
     * 报名时间
     */
    private String signupTime;

    private String signupHouseId;
    private String signupHouseName;
    private String signupSourceId;
    private String signupSourceName;

    /**
     * 超时量
     */
    private Integer overTimeCount;

    /**
     * 回访量
     */
    private Integer visitBackCount;

    /**
     * 带访量
     */
    private Integer waitVisitCount;

    /**
     * 认购量
     */
    private Integer boughtCount;

    private Integer isabandon;

    //放弃时间
    private Date abandonTime;

    private Integer abandonLogId;

    public Integer getActiveId() {
        return activeId;
    }

    public void setActiveId(Integer activeId) {
        this.activeId = activeId;
    }

    public Integer getIsOvertime() {
        return isOvertime;
    }

    public void setIsOvertime(Integer isOvertime) {
        this.isOvertime = isOvertime;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getBakPhone1() {
        return bakPhone1;
    }

    public void setBakPhone1(String bakPhone1) {
        this.bakPhone1 = bakPhone1;
    }

    public String getBakPhone2() {
        return bakPhone2;
    }

    public void setBakPhone2(String bakPhone2) {
        this.bakPhone2 = bakPhone2;
    }

    public String getBakPhone3() {
        return bakPhone3;
    }

    public void setBakPhone3(String bakPhone3) {
        this.bakPhone3 = bakPhone3;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public Integer getCustomerType() {
        return customerType;
    }

    public void setCustomerType(Integer customerType) {
        this.customerType = customerType;
    }

    public String getActSource() {
        return actSource;
    }

    public void setActSource(String actSource) {
        this.actSource = actSource;
    }

    public String getFirstSource() {
        return firstSource;
    }

    public void setFirstSource(String firstSource) {
        this.firstSource = firstSource;
    }

    public String getLatestSource() {
        return latestSource;
    }

    public void setLatestSource(String latestSource) {
        this.latestSource = latestSource;
    }

    public String getCrmLatestCall() {
        return crmLatestCall;
    }

    public void setCrmLatestCall(String crmLatestCall) {
        this.crmLatestCall = crmLatestCall;
    }

    public String getCrmLatestCallResult() {
        return crmLatestCallResult;
    }

    public void setCrmLatestCallResult(String crmLatestCallResult) {
        this.crmLatestCallResult = crmLatestCallResult;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreateSource() {
        return createSource;
    }

    public void setCreateSource(String createSource) {
        this.createSource = createSource;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreater() {
        return creater;
    }

    public void setCreater(String creater) {
        this.creater = creater;
    }

    public String getBuyIntention() {
        return buyIntention;
    }

    public void setBuyIntention(String buyIntention) {
        this.buyIntention = buyIntention;
    }

    public Date getLastVisitTime() {
        return lastVisitTime;
    }

    public void setLastVisitTime(Date lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    public Date getLastCallTime() {
        return lastCallTime;
    }

    public void setLastCallTime(Date lastCallTime) {
        this.lastCallTime = lastCallTime;
    }

    public Integer getManagerId() {
        return managerId;
    }

    public void setManagerId(Integer managerId) {
        this.managerId = managerId;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String getUpdater() {
        return updater;
    }

    public void setUpdater(String updater) {
        this.updater = updater;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getBizPort() {
        return bizPort;
    }

    public void setBizPort(String bizPort) {
        this.bizPort = bizPort;
    }

    public String getCrmId() {
        return crmId;
    }

    public void setCrmId(String crmId) {
        this.crmId = crmId;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public Integer getActSourceId() {
        return actSourceId;
    }

    public void setActSourceId(Integer actSourceId) {
        this.actSourceId = actSourceId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Integer getTraceStatus() {
        return traceStatus;
    }

    public void setTraceStatus(Integer traceStatus) {
        this.traceStatus = traceStatus;
    }

    public String getCrmSync() {
        return crmSync;
    }

    public void setCrmSync(String crmSync) {
        this.crmSync = crmSync;
    }

    public Date getHotlineCallTime() {
        return hotlineCallTime;
    }

    public void setHotlineCallTime(Date hotlineCallTime) {
        this.hotlineCallTime = hotlineCallTime;
    }

    public String getHotlineCallSpend() {
        return hotlineCallSpend;
    }

    public void setHotlineCallSpend(String hotlineCallSpend) {
        this.hotlineCallSpend = hotlineCallSpend;
    }

    public Date getOceanDate() {
        return oceanDate;
    }

    public void setOceanDate(Date oceanDate) {
        this.oceanDate = oceanDate;
    }

    public Integer getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Integer isDelete) {
        this.isDelete = isDelete;
    }

    public String getLastManager() {
        return lastManager;
    }

    public void setLastManager(String lastManager) {
        this.lastManager = lastManager;
    }

    public Date getBindTime() {
        return bindTime;
    }

    public void setBindTime(Date bindTime) {
        this.bindTime = bindTime;
    }

    public Integer getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Integer customerId) {
        this.customerId = customerId;
    }

    public String getSignupTime() {
        return signupTime;
    }

    public void setSignupTime(String signupTime) {
        this.signupTime = signupTime;
    }

    public String getSignupHouseId() {
        return signupHouseId;
    }

    public void setSignupHouseId(String signupHouseId) {
        this.signupHouseId = signupHouseId;
    }

    public String getSignupHouseName() {
        return signupHouseName;
    }

    public void setSignupHouseName(String signupHouseName) {
        this.signupHouseName = signupHouseName;
    }

    public String getSignupSourceId() {
        return signupSourceId;
    }

    public void setSignupSourceId(String signupSourceId) {
        this.signupSourceId = signupSourceId;
    }

    public String getSignupSourceName() {
        return signupSourceName;
    }

    public void setSignupSourceName(String signupSourceName) {
        this.signupSourceName = signupSourceName;
    }

    public Integer getOverTimeCount() {
        return overTimeCount;
    }

    public void setOverTimeCount(Integer overTimeCount) {
        this.overTimeCount = overTimeCount;
    }

    public Integer getVisitBackCount() {
        return visitBackCount;
    }

    public void setVisitBackCount(Integer visitBackCount) {
        this.visitBackCount = visitBackCount;
    }

    public Integer getWaitVisitCount() {
        return waitVisitCount;
    }

    public void setWaitVisitCount(Integer waitVisitCount) {
        this.waitVisitCount = waitVisitCount;
    }

    public Integer getBoughtCount() {
        return boughtCount;
    }

    public void setBoughtCount(Integer boughtCount) {
        this.boughtCount = boughtCount;
    }

    public Integer getIsabandon() {
        return isabandon;
    }

    public void setIsabandon(Integer isabandon) {
        this.isabandon = isabandon;
    }

    public Date getAbandonTime() {
        return abandonTime;
    }

    public void setAbandonTime(Date abandonTime) {
        this.abandonTime = abandonTime;
    }

    public Integer getAbandonLogId() {
        return abandonLogId;
    }

    public void setAbandonLogId(Integer abandonLogId) {
        this.abandonLogId = abandonLogId;
    }

    public CustomerEntity convertCustomer() {
        CustomerEntity customerEntity = new CustomerEntity();
        customerEntity.setCustomerSourceType(HGSConstant.CustomerSourceType.MARKET.getType());
        customerEntity.setActSource(actSource);
        customerEntity.setActSourceId(actSourceId);
        customerEntity.setBizPort(bizPort);
        customerEntity.setBuyIntention(buyIntention);
        customerEntity.setCityCode(cityCode);
        customerEntity.setCityName(cityName);
        customerEntity.setCreater(creater);
        customerEntity.setCreateTime(createTime);
        customerEntity.setUpdater(updater);
        customerEntity.setUpdateTime(updateTime);
        customerEntity.setCrmId(crmId);
        customerEntity.setCrmSync(HGSConstant.CrmSyncStatus.DONE.getType());
        customerEntity.setName(name);
        customerEntity.setPhone(phone);
        customerEntity.setSex(sex);
        customerEntity.setActSource(actSource);
        customerEntity.setFirstSource(firstSource);
        customerEntity.setCreateSource("云迹");
        customerEntity.setCustomerType(HGSConstant.CustomerTypeEnum.ONLINE.getMsg());
        customerEntity.setLatestSource(latestSource);
        customerEntity.setCrmLatestCall(crmLatestCall);
        customerEntity.setCrmLatestCallResult(crmLatestCallResult);
        customerEntity.setStatus(HGSConstant.CustomerStatusEnum.NORECORD.getStatus());
        customerEntity.setTraceStatus(HGSConstant.TRACE_STATUS_INVALID);
        customerEntity.setIsDelete(0);
        return customerEntity;
    }
}
