package com.house365.beans.common;

import com.house365.web.util.MemoryPropertyPlaceholderConfigurer;

public enum MessageTypeEnum {

    NEWHOTLINE("1", "新增的400来电客户", "您有一个新增的400来电客户，请您及时进行跟踪回访",
            MemoryPropertyPlaceholderConfigurer.getContextProperty("WECHAT.SERVICE.URL") + "/customer/hotline?timeFilter=1"),
    NEWCUSTOMER("2", "新增客户", "您有一个新增客户，请您及时进行跟踪回访",
            MemoryPropertyPlaceholderConfigurer.getContextProperty("WECHAT.SERVICE.URL") + "/customer/customerdetail?customerId=@replace1@"),
    UPDATECUSTOMERSTATUS("3", "客户状态更新至:【@replace2@】", "客户【@replace1@】状态已更新至【@replace2@】，请您及时查看客户状态",
            MemoryPropertyPlaceholderConfigurer.getContextProperty("WECHAT.SERVICE.URL") + "/project/reportcustomer?customerProjectId=@replace1@"),
    NEWRECORDCUSTOMER("4", "新约看客户", "您有一个新约看客户\n" + "约看项目：【@replace1@】\n" + "客户姓名：【@replace2@】\n"
            + "客户电话：【@replace3@】\n" + "经纪人姓名：【@replace4@】\n" + "所属门店：\n" + "看房时间：\n",
            MemoryPropertyPlaceholderConfigurer.getContextProperty("WECHAT.SERVICE.URL") + "/project/reportcustomer?customerProjectId=@replace1@"),
    NEWNOTICE("5", "公告通知", "@replace1@",
            MemoryPropertyPlaceholderConfigurer.getContextProperty("WECHAT.SERVICE.URL") + "/customer/noticeDetail/@replace1@"),
    RUSHCUSTOMER("6", "抢客通知", "在过去的30分钟里，有@replace1@个客户正在关注你负责的项目",
            MemoryPropertyPlaceholderConfigurer.getContextProperty("WECHAT.SERVICE.URL") + "/customer/rushcustomerlist");

    private String id;
    private String des;
    private String message;
    private String url;

    private MessageTypeEnum(String id, String des, String message, String url) {
        this.id = id;
        this.des = des;
        this.message = message;
        this.url = url;
    }

    public String getId() {
        return id;
    }

    public String getDes() {
        return des;
    }

    public String getMessage() {
        return message;
    }

    public String getUrl() {
        return url;
    }
}
