package com.house365.ws.util;

import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.CustomerLogEntity;
import com.house365.beans.entity.LogFieldEntity;
import com.house365.ws.dao.mapper.CustomerLogMapper;
import com.house365.ws.dao.mapper.LogFieldMapper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author whh
 */
@Component
public class MergeCustomerUtil {

    @Autowired
    private CustomerLogMapper customerLogMapper;
    @Autowired
    private LogFieldMapper fieldMapper;


    /**
     * 更新合并客户
     *
     * @param customerEntity    旧的客户实体
     * @param oldCustomerEntity 新表客户实体
     * @return
     */
    public boolean checkMergeCustomer(CustomerEntity customerEntity, CustomerEntity oldCustomerEntity, Integer userId, String userName) {
        String oldbuyIntension = oldCustomerEntity.getBuyIntention();
        Integer oldtracestatus = oldCustomerEntity.getTraceStatus();
        String buyIntension = "".equals(customerEntity.getBuyIntention()) ? "" : customerEntity.getBuyIntention();
        Integer tracestatus = customerEntity.getTraceStatus();
        boolean needupdate = false;

        //记录日志需要字段
        String oldBuyIntention = oldCustomerEntity.getBuyIntention();
        Integer oldTrcStatus = oldCustomerEntity.getTraceStatus();
        if (StringUtils.isBlank(oldbuyIntension)) {
            oldCustomerEntity.setBuyIntention(String.valueOf(buyIntension));
            needupdate = true;
        } else if (StringUtils.isNotBlank(buyIntension) && Integer.valueOf(buyIntension) < Integer.valueOf(oldbuyIntension)) {
            oldCustomerEntity.setBuyIntention(String.valueOf(buyIntension));
            needupdate = true;
        }
        if (tracestatus != 4 && tracestatus > oldtracestatus) {
            oldCustomerEntity.setTraceStatus(tracestatus);
            needupdate = true;
        }
        //合并客户时记录新客户表的日志(更新才记录)
        String newBuyIntention = oldCustomerEntity.getBuyIntention();
        Integer newTraceStatus = oldCustomerEntity.getTraceStatus();
        if (needupdate) {
            if (StringUtils.isNotBlank(oldbuyIntension) && StringUtils.isNotBlank(newBuyIntention) && !oldbuyIntension.equals(newBuyIntention)) {
                CustomerLogEntity logEntity = new CustomerLogEntity();

                logEntity.setRelateId(oldCustomerEntity.getId());
                logEntity.setCustomerPhone(oldCustomerEntity.getPhone());
                if (oldCustomerEntity.getManagerId() != null) {
                    logEntity.setManagerId(oldCustomerEntity.getManagerId());
                } else {
                    logEntity.setManagerId(0);
                }
                Map<String, Object> map = new HashMap<>(10);
                map.put("type", 2);
                map.put("field", "buyIntention");
                List<LogFieldEntity> list = fieldMapper.queryByConditions(map);
                if (CollectionUtils.isNotEmpty(list)) {
                    logEntity.setModifyName(list.get(0).getFieldName());
                } else {
                    logEntity.setModifyName("");
                }
                logEntity.setModifyColumn("buyIntention");
                logEntity.setType(2);
                logEntity.setOldValue(oldBuyIntention);
                logEntity.setNewValue(newBuyIntention);
                if ("1".equals(oldBuyIntention)) {
                    logEntity.setOldValue("A");
                } else if ("2".equals(oldBuyIntention)) {
                    logEntity.setOldValue("B");
                } else if ("3".equals(oldBuyIntention)) {
                    logEntity.setOldValue("C");
                } else if ("4".equals(oldBuyIntention)) {
                    logEntity.setOldValue("D");
                } else if ("5".equals(oldBuyIntention)) {
                    logEntity.setOldValue("E");
                }

                if ("1".equals(newBuyIntention)) {
                    logEntity.setNewValue("A");
                } else if ("2".equals(newBuyIntention)) {
                    logEntity.setNewValue("B");
                } else if ("3".equals(newBuyIntention)) {
                    logEntity.setNewValue("C");
                } else if ("4".equals(newBuyIntention)) {
                    logEntity.setNewValue("D");
                } else if ("5".equals(newBuyIntention)) {
                    logEntity.setNewValue("E");
                }

                logEntity.setCreateUserId(userId);
                logEntity.setCreateUserName(userName);
                logEntity.setCreateTime(new Date());
                customerLogMapper.save(logEntity);
            }
            if (newTraceStatus != null && !oldTrcStatus.equals(newTraceStatus)) {
                CustomerLogEntity logEntity = new CustomerLogEntity();
                logEntity.setRelateId(oldCustomerEntity.getId());
                logEntity.setCustomerPhone(oldCustomerEntity.getPhone());
                if (oldCustomerEntity.getManagerId() != null) {
                    logEntity.setManagerId(oldCustomerEntity.getManagerId());
                } else {
                    logEntity.setManagerId(0);
                }
                Map<String, Object> map = new HashMap<>(10);
                map.put("type", 2);
                map.put("field", "traceStatus");
                List<LogFieldEntity> list = fieldMapper.queryByConditions(map);
                if (CollectionUtils.isNotEmpty(list)) {
                    logEntity.setModifyName(list.get(0).getFieldName());
                } else {
                    logEntity.setModifyName("");
                }
                logEntity.setModifyColumn("traceStatus");
                logEntity.setType(2);
                logEntity.setOldValue(oldTrcStatus.toString());
                logEntity.setNewValue(newTraceStatus.toString());
                if (oldTrcStatus == 1) {
                    logEntity.setOldValue("有效");
                } else if (oldTrcStatus == 2) {
                    logEntity.setOldValue("已购");
                } else if (oldTrcStatus == 3) {
                    logEntity.setOldValue("我购");
                } else if (oldTrcStatus == 4) {
                    logEntity.setOldValue("暂缓");
                }
                if (newTraceStatus == 1) {
                    logEntity.setNewValue("有效");
                } else if (newTraceStatus == 2) {
                    logEntity.setNewValue("已购");
                } else if (newTraceStatus == 3) {
                    logEntity.setNewValue("我购");
                } else if (newTraceStatus == 4) {
                    logEntity.setNewValue("暂缓");
                }
                logEntity.setCreateUserId(userId);
                logEntity.setCreateUserName(userName);
                logEntity.setCreateTime(new Date());
                customerLogMapper.save(logEntity);
            }
        }
        return needupdate;
    }


}
