/**
 * Description: 账户业务接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-14 下午 17:27:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import com.house365.beans.entity.RequestLoginEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.beans.entity.UserEvaluateEntity;
import com.house365.beans.entity.VersionEntity;
import com.house365.beans.system.QueryParams;
import com.house365.service.system.Interfaces.Service;

import java.util.List;
import java.util.Map;

/**
 * 账户业务接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public interface IUserService<T extends UserEntity> extends Service<T> {
    List<String> getMobilesByProject(Integer projectId);

    List<String> getIdsByProject(Integer projectId);

    List<Integer> getUserIdOnPath(Integer parentId);

    List queryShortNum4Crm();

    Map<String, Object> getSummary(String managerId);

    //按楼盘短号获取直销人员列表
    List<UserEntity> getUserByPorjectShort(Map<String, Object> queryMap);

    List<UserEvaluateEntity> queryEvaluateListById(UserEvaluateEntity uue);

    void reviewStatus(UserEvaluateEntity uue);//审核

    void delEvaluationById(UserEvaluateEntity uue);//删除

    void bindAccid(UserEntity userentity);//删除

    List<VersionEntity> getAppVersionList(QueryParams<VersionEntity> queryParams);

    UserEntity getRemotePath(Integer resourceId);

    UserEntity getCityName(String city);

    UserEntity getUserEvaluation(String accId);

    UserEntity getByCity(String city);

    void saveUnbindLog(UserEntity entity);

    /**
     * 通过userId判断是否为主管
     *
     * @param userId
     * @return
     */
    Boolean isDirector(Integer userId);

    List<UserEntity> getAccidByName(Map<String, Object> queryMap);

    List<RequestLoginEntity> getAuthorizationList(QueryParams<RequestLoginEntity> queryParams);

    Integer countAuthorizationList(QueryParams<RequestLoginEntity> queryParams);
}
