/**
 * Description: ProjectUser业务接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-18 上午 10:05:26
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-18   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.interfaces;

import java.util.List;

import com.house365.service.system.Interfaces.Service;
import com.house365.beans.entity.ProjectEntity;
import com.house365.beans.entity.ProjectUserEntity;
import com.house365.beans.entity.UserEntity;

/**
 * ProjectUser业务接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-18
 * @see
 * @since 1.0
 */
public interface IProjectUserService<T extends ProjectUserEntity> extends Service<T> {
	public List<UserEntity> queryUserByPrjId(Integer projectId);
	public List<UserEntity>  getProjectUser(List<Integer> projectIds);
	public List<ProjectEntity> getProjectByUserId(Integer userId, String cityCode);

    List<ProjectEntity> getProjectByUserId(Integer userId, String cityCode, String showStatus);
}
