/**
 * Description: 客户信息业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-05 下午 19:21:01
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.google.common.base.Strings;
import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.MarketCustomerEntity;
import com.house365.beans.entity.MarketingActivityEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.dao.system.interfaces.Dao;
import com.house365.rest.exception.ServiceRunException;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICustomerDao;
import com.house365.ws.dao.interfaces.IMarketCustomerDao;
import com.house365.ws.dao.interfaces.IMarketingActivityDao;
import com.house365.ws.dao.mapper.CustomerMapper;
import com.house365.ws.dao.mapper.MarketCustomerMapper;
import com.house365.ws.dao.mapper.UserMapper;
import com.house365.ws.interfaces.impl.CustomerImpl;
import com.house365.ws.service.interfaces.IMarketCustomerService;
import com.house365.ws.util.OperateLogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 客户信息业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
@Service("marketCustomerService")
public class MarketCustomerServiceImpl<T extends MarketCustomerEntity> extends DefaultServiceImpl<T> implements IMarketCustomerService<T> {

    private static final Logger LOGGER = LoggerFactory.getLogger(MarketCustomerServiceImpl.class);
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private IMarketCustomerDao<T> marketCustomerDao;

    @Autowired
    private IMarketingActivityDao marketingActivityDao;
    @Autowired
    private ICustomerDao customerDao;
    @Autowired
    private CustomerMapper customerMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private OperateLogUtils logUtils;
    @Autowired
    private MarketCustomerMapper marketCustomerMapper;

    @Override
    protected Dao<T> getDao() {
        return marketCustomerDao;
    }

    @Override
    public synchronized Integer queryProtectCount(String phone) {
        return marketingActivityDao.queryProtectCount(phone);
    }

    @Override
    public void clean() {
        marketCustomerDao.clean();
    }

    @Override
    public void updateSignupSourceName() {
        marketCustomerDao.updateSignupSourceName();
    }

    @Override
    public Integer queryCustomerCountByActive(Integer activeId) {
        return marketingActivityDao.queryCustomerCountByActive(activeId);
    }

    @Override
    public List<MarketCustomerEntity> queryByIds(String customerIds) {
        return marketCustomerDao.queryByIds(customerIds);
    }

    @Override
    public List<MarketCustomerEntity> getUseMarketingActivity(MarketCustomerEntity marketcustomerentity) {
        return marketCustomerDao.getUseMarketingActivity(marketcustomerentity);
    }

    @Override
    public MarketCustomerEntity queryByCustomerid(Integer custmerId) {
        return marketCustomerDao.queryByCustomerid(custmerId);
    }

    @Transactional(readOnly = false, propagation = Propagation.REQUIRED, rollbackFor = {Exception.class})
    @Override
    public void removeCustomer(CustomerEntity custmer, Integer userId) throws ServiceRunException {
        MarketCustomerEntity mc = queryByCustomerid(custmer.getId());
        if (null != mc) {
            MarketingActivityEntity activity = (MarketingActivityEntity) marketingActivityDao.getById(mc.getActiveId());
            if (activity != null) {
                Date cur = new Date();

                //超时而不是无效操作回公海 统计超时量使用, 超时任务传入的userid为-1 无效操作正常传入
                //活动结束不变更
                if (-1 == userId && null == mc.getOverTimeCount() && cur.before(activity.getFinishTime())) {
                    marketingActivityDao.addOverTimeCount(activity.getId());
                    mc.setOverTimeCount(1);
                    mc.setIsOvertime(1);
                } else if (-1 != userId) {
                    //如果是无效操作，清除超时标签. 超时数据-派工-无效后不在超时标签里展示
                    mc.setIsOvertime(0);
                }
                if (cur.before(activity.getFinishTime())) {
                    //常规公海不可见
                    custmer.setIsDelete(1);
                }
                customerDao.update(custmer);
                if (cur.before(activity.getFinishTime())) {
                    //新增客户删除日志
                    String userName;
                    if (userId == -1) {
                        userName = "超时定时任务";
                    } else {
                        UserEntity userEntity = userMapper.getById(userId);
                        userName = userEntity.getRealName();
                    }
                    logUtils.saveCustomerLog(custmer, 3, userId, userName);
                }
                String managerName = mc.getManagerName();
                if (!Strings.isNullOrEmpty(managerName)) {
                    mc.setLastManager(managerName);
                }
                mc.setManagerName(null);
                mc.setManagerId(null);
                mc.setOceanDate(new Date());
                mc.setUpdateTime(new Date());
                mc.setStatus(3);
                mc.setUpdater(String.valueOf(userId == -1 ? "SYSTEM" : userId));
                update((T) mc);

            } else {
                throw new ServiceRunException("activity is null");
            }
        } else {
            LOGGER.error("---------移入公海是该客户所在的营销活动客户数据异常-----------");
        }
    }

    @Override
    public List<String> getExistPhone(List<String> phones){
        Map<String,Object> map = new HashMap<>();
        map.put("phoneList",phones);
        List<String> list = marketCustomerMapper.getExistByPhone(map);
        return list;
    }
}
