/**
 * Description: 驻场日报业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 上午 10:14:22
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.google.common.base.Strings;
import com.house365.beans.entity.LocalReportEntity;
import com.house365.beans.po.ReportDailyPo;
import com.house365.beans.system.QueryParams;
import com.house365.beans.vo.LocalReportFormVo;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ILocalReportDao;
import com.house365.ws.service.interfaces.ILocalReportService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 驻场日报业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
@Service("localReportService")
public class LocalReportServiceImpl<T extends LocalReportEntity> extends DefaultServiceImpl<T> implements ILocalReportService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ILocalReportDao<T> localReportDao;

    @Override
    protected Dao<T> getDao() {
        return localReportDao;
    }

    @Override
    public List<LocalReportFormVo> queryFormVO(String city) {
        return localReportDao.queryFormVO(city);
    }

    @Override
    public List<LocalReportFormVo> queryFormVORecord(String city, String reportDate, Integer projectId) {
        return localReportDao.queryFormVORecord(city, reportDate, projectId);
    }

    @Override
    public void cleanDayReportByProject(String projectId, String date) {
        if (!Strings.isNullOrEmpty(projectId) && !Strings.isNullOrEmpty(date)) {
            localReportDao.cleanDayReportByProject(projectId, date);
        }
    }

    @Override
    public List<LocalReportFormVo> statistic(QueryParams<?> queryParams) {
        return localReportDao.statistic(queryParams);
    }

    @Override
    public List<ReportDailyPo> getDailies(String startTime, String endTime, String city) {
        Map<String, Object> param = new HashMap<>();
        param.put("startTime", startTime);
        param.put("endTime", endTime);
        param.put("city", city);
        return localReportDao.getDailies(param);
    }
}
