/**
 * Description: CrmSource业务实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-09 下午 16:02:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-09   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.service.impl;

import com.house365.beans.entity.BaseTreeEntity;
import com.house365.beans.entity.CrmSourceEntity;
import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.service.system.impl.DefaultServiceImpl;
import com.house365.ws.dao.interfaces.ICrmSourceDao;
import com.house365.ws.service.interfaces.IBaseTreeService;
import com.house365.ws.service.interfaces.ICrmSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * CrmSource业务实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-09
 * @see
 * @since 1.0
 */
@Service("crmSourceService")
public class CrmSourceServiceImpl<T extends CrmSourceEntity> extends DefaultServiceImpl<T> implements ICrmSourceService<T> {
    /**
     * 自动注入的数据访问对象
     */
    @Autowired
    private ICrmSourceDao<T> crmSourceDao;

    @Autowired
    private IBaseTreeService baseTreeService;


    @Override
    protected Dao<T> getDao() {
        return crmSourceDao;
    }

    @Override
    public void truncateTable() {
        crmSourceDao.truncateTable();
    }

    @Override
    public CrmSourceEntity getBySourceId(Integer sourceId) {
        CrmSourceEntity sourceEntity = new CrmSourceEntity();
        Map<String, Object> map = new HashMap<>();
        map.put("EQ_sourceId", sourceId);
        QueryParams queryParams = new QueryParams(map);
        List<CrmSourceEntity> sources = (List<CrmSourceEntity>) crmSourceDao.queryAll(queryParams);
        if (sources != null && sources.size() != 0) {
            sourceEntity = sources.get(0);
        }
        return sourceEntity;
    }

    @Override
    public List<CrmSourceEntity> getListByCategory(String categoryId) {
        List<CrmSourceEntity> list = new ArrayList<>();
        Map<String, Object> searchmap = new HashMap<>(10);
        searchmap.put("EQ_sourceId", categoryId);

        QueryParams queryParams = new QueryParams();
        queryParams.setSearchParams(searchmap);

        List<BaseTreeEntity> treeList = baseTreeService.queryAll(queryParams);
        if (!treeList.isEmpty()) {
            BaseTreeEntity baseTreeEntity = treeList.get(0);
            String urlPath = "^" + baseTreeEntity.getUrlPath() + "$|^" + baseTreeEntity.getUrlPath() + "/";
            list = crmSourceDao.getListByCategory(urlPath);
        }

        return list;
    }


}
