package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.BaseAttachment;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.IAttachmentService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/9/12.
 */
@Service("operateAttachment")
public class OperateAttachmentImpl implements IOperateAttachment {

    private static final Logger logger = LoggerFactory.getLogger(OperateAttachmentImpl.class);

    @Autowired
    private IAttachmentService attachmentService;

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<BaseAttachment> response = new House365RestResponse<>();
        // 业务层统一处理
        try {
            House365RestObject<BaseAttachment> data = doBusiness(map);
            response.setData(data);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        String result = JSONObject.fromObject(response).toString();
        return result;
    }

    private House365RestObject<BaseAttachment> doBusiness(Map<String, Object> map) throws Exception {
        House365RestObject<BaseAttachment> restObject = new House365RestObject<>();
        String type = getMapValueByKey("type", map, "");
        String resourceId = getMapValueByKey("resourceId", map, "");
        String resourceType = getMapValueByKey("resourceType", map, "");
        String remotePath = getMapValueByKey("remotePath", map, "");
        if(type.equals("del")){
            int id = Integer.valueOf(resourceId);
            attachmentService.delete(id);
        }else if(type.equals("add")){
            String size = getMapValueByKey("size", map, "");
            String bizType = getMapValueByKey("bizType", map, "");
            String suffix = getMapValueByKey("suffix", map, "");
            BaseAttachment attachment = new BaseAttachment();
            attachment.setSuffix(suffix);
            attachment.setRemotePath(remotePath);
            attachment.setBizType(Integer.valueOf(bizType));
            attachment.setResourceId(Integer.valueOf(resourceId));
            attachment.setResourceType(resourceType);
            attachment.setSize(Long.valueOf(size));

            attachmentService.save(attachment);
        }else if(type.equals("update")){
            List<BaseAttachment> headImg = attachmentService.queryByResourceIdAndResouceType(resourceId, resourceType);
            if(CollectionUtils.isNotEmpty(headImg)){
                BaseAttachment attachment = headImg.get(0);
                attachment.setRemotePath(remotePath);

                attachmentService.update(attachment);
            }
        }else if(type.equals("search")){
            List<BaseAttachment> headImg = attachmentService.queryByResourceIdAndResouceType(resourceId, resourceType);
            if(CollectionUtils.isNotEmpty(headImg)){
                restObject.setEntity(headImg.get(0));
            }
            return restObject;
        }
        return null;
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }
}
