package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.BaseAttachment;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.beans.response.AttachmentListResponse;
import com.house365.ws.beans.response.CustomerResponse;
import com.house365.ws.interfaces.server.IAttachmentInterface;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.Constant;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("getHeadImgByUserId")
public class GetHeadImgByUserIdImpl implements IGetHeadImgByUserId{

    private static final Logger LOGGER = LoggerFactory.getLogger(GetHeadImgByUserIdImpl.class);

    @Autowired
    private IAttachmentInterface attachmentInterface;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<CustomerResponse> response = new House365RestResponse<CustomerResponse>();
        try {
            checkInterfaceParameter(map, Constant.USERID);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }


        House365RestResponse<String> response2 = new House365RestResponse<>();
        // 业务层统一处理
        try {
            House365RestObject<String> data = doBusiness(map);
            response2.setData(data);
            response2.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            response2.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response2.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
            return JSONObject.fromObject(response2).toString();
        }
        String result = JSONObject.fromObject(response2).toString();
        return result;
    }

    /**
     * 业务层统逻辑处理
     */
    private House365RestObject<String> doBusiness(Map<String, Object> map) throws Exception {
        // 返回Json对象
        House365RestObject<String> restObject = new House365RestObject<>();
        String userId = getMapValueByKey("userId", map, "");

        AttachmentListResponse headImgRes = attachmentInterface.queryByResourceIdAndResouceType(String.valueOf(userId), "hgs_user_headImg");
        if (null != headImgRes.getObjectList() && !headImgRes.getObjectList().isEmpty()) {
            BaseAttachment attachment = (BaseAttachment) headImgRes.getObjectList().get(0);
            restObject.setEntity(attachment.getRemotePath());
        }
        return restObject;
    }





    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    /**
     * 业务层统校验自己所需参数是否存在
     * 所有参数都要存在
     *
     * @author hqc
     */
    protected void checkInterfaceParameter(
            Map<String, Object> map, String[] checkParams
    ) throws IllegalServiceParameterException {
        // 方法所需参数
        for (String str : checkParams) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }



}
