package com.house365.ws.interfaces.rest;

import com.house365.beans.entity.UserEntity;
import com.house365.beans.po.UserPo;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.IUserService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("getAllUserInfo")
public class GetAllUserInfoImpl implements IGetAllUserInfo{

    private static final Logger LOGGER = LoggerFactory.getLogger(GetAllUserInfoImpl.class);

    @Autowired
    private IUserService userService;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<UserEntity> response = new House365RestResponse<UserEntity>();
        // 业务层统一处理
        try {
            House365RestObject<UserEntity> data = doBusiness(map);
            response.setData(data);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        String result = JSONObject.fromObject(response).toString();
        return result;
    }

    /**
     * 业务层统逻辑处理
     */
    private House365RestObject<UserEntity> doBusiness(Map<String, Object> map) throws Exception {
        // 返回Json对象
        House365RestObject<UserEntity> restObject = new House365RestObject<>();
//        Map<String, Object> userQueryMap = new HashMap<>();
//        QueryParams queryParams = new QueryParams(userQueryMap);
//        queryParams.setOrderColumn("id");
//        queryParams.setOrderMode("asc");
        List userEntities = userService.queryShortNum4Crm();
        restObject.setList(userEntities);
        return restObject;

    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }


}
