package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.CustomerEntity;
import com.house365.beans.entity.UserEntity;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.beans.response.CustomerResponse;
import com.house365.ws.service.interfaces.ICustomerService;
import com.house365.ws.service.interfaces.IDepartmentService;
import com.house365.ws.service.interfaces.IUserService;
import com.house365.ws.system.ReturnAppResult;
import com.house365.ws.util.Constant;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

/**
 * <p>Title: CRM 接口 根据手机号获取三个月内 callCount 回访数 visitCount 到访数 signCount 签约数</p>
 * <p>Description: </p>
 * <p>Date: 2016/9/29</p>
 *
 * @author XN
 * @version 1.0
 */
@Service("customerStatistic")
public class CRMStatisticInfo implements ICRMStatisticInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger("sysLog");

    @Autowired
    private ICustomerService<CustomerEntity> customerService;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<Map<String, Object>> response = new House365RestResponse<Map<String, Object>>();
        // 业务校验统一入口
        try {
            checkInterfaceParameter(map, Constant.CRMStatisticParamsOLD);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (IllegalServiceParameterException e) {
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg(e.getMessage());
            return JSONObject.fromObject(response).toString();
        }

        // 业务层统一处理
        try {
            House365RestObject<Map<String, Object>> data = doBusiness(map);
            response.setData(data);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        String result = JSONObject.fromObject(response).toString();
        return result;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    /**
     * 业务层统逻辑处理
     */
    private House365RestObject<Map<String, Object>> doBusiness(Map<String, Object> map) throws Exception {
        // 返回Json对象
        House365RestObject<Map<String, Object>> restObject = new House365RestObject<>();
        String phone = getMapValueByKey(Constant.CUSTOMER_PHONE, map, "");
        String dateType = getMapValueByKey(Constant.CUSTOMER_PERIOD, map, "");//接口入参区分时间段1:标识去取近7天的,没有或者空是默认近3个月的
        if("1".equals(dateType)){//近7天
            Map<String, Object> statistic = customerService.getSummary7ForCRM(phone);
            restObject.setEntity(statistic);
        }else{//默认近3月
            Map<String, Object> statistic = customerService.getSummaryForCRM(phone);
            restObject.setEntity(statistic);
        }
        return restObject;
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    /**
     * 业务层统校验自己所需参数是否存在
     * 所有参数都要存在
     *
     * @author hqc
     */
    protected void checkInterfaceParameter(
        Map<String, Object> map, String[] checkParams
    ) throws IllegalServiceParameterException {
        // 方法所需参数
        for (String str : checkParams) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }
    }
}
