package com.house365.ws.interfaces.rest;

import com.google.common.base.Strings;
import com.house365.beans.entity.ProjectSalerEntity;
import com.house365.beans.po.UserPo;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.IllegalServiceParameterException;
import com.house365.rest.exception.ServiceRunException;
import com.house365.rest.parameter.House365RestObject;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.service.interfaces.IProjectSalerService;
import com.house365.ws.system.ReturnAppResult;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

/**
 * <p>Title: 获取直销人员推荐楼盘</p>
 * <p>Description: </p>
 * <p>Date: 16/9/15</p>
 *
 * @author XN
 * @version 1.0
 */
@Service("bindUserToHouse")
public class BindUserToHouseImpl implements IBindUserToHouse {

    private static final Logger LOGGER = LoggerFactory.getLogger(BindUserToHouseImpl.class);

    @Autowired
    private IProjectSalerService projectSalerService;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // 取得所需参数
        Map<String, Object> map = parameter.getArgs();
        House365RestResponse<UserPo> response = new House365RestResponse<>();
        // 业务层统一处理
        try {
            House365RestObject<UserPo> data = doBusiness(map);
            response.setData(data);
            response.setResult(ReturnAppResult.APP_SUCCESS.getResultMessage());
        } catch (Exception e) {
            LOGGER.error(e.getMessage(), e);
            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
        }
        String result = JSONObject.fromObject(response).toString();
        return result;
    }

    /**
     * 业务层统逻辑处理
     */
    private House365RestObject<UserPo> doBusiness(Map<String, Object> map) throws Exception {
        // 返回Json对象
        House365RestObject<UserPo> restObject = new House365RestObject<>();
        String city = getMapValueByKey("city", map, "");
        String userId = getMapValueByKey("userId", map, "");
        String userName = getMapValueByKey("userName", map, "");
        String houseinfo = getMapValueByKey("houseinfo", map, "");

        if (houseinfo.equals("")) {
            projectSalerService.deleteByUserId(userId);
            return restObject;
        }
        String[] houseArr = houseinfo.split("@#");

        projectSalerService.deleteByUserId(userId);
        for (String house : houseArr) {
            if (house.split(",").length >= 3) {
                ProjectSalerEntity entity = new ProjectSalerEntity();
                entity.setUserId(Integer.valueOf(userId));
                entity.setUserName(userName);
                entity.setProjectId(Integer.parseInt(house.split(",")[0]));
                entity.setProjectName(house.split(",")[1]);
                entity.setProjectCode("");
                entity.setChannel(house.split(",")[2]);
                entity.setCity(city);

                Date date = new Date();
                entity.setCreateTime(date);
                entity.setUpdateTime(date);
                entity.setCreateUserid(1);
                entity.setCreateUsername("直销接口");
                entity.setUpdateUserid(1);
                entity.setUpdateUsername("直销接口");

                projectSalerService.save(entity);
            }

        }
        return restObject;
    }

    /**
     * 获取map中的值
     *
     * @param key          key
     * @param map          map
     * @param defaultValue 默认值
     * @return value
     */
    private String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
        String value = "";
        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
            value = ((String[]) map.get(key))[0];
        }

        if (Strings.isNullOrEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    /**
     * 业务层统校验自己所需参数是否存在
     * 所有参数都要存在
     *
     * @author hqc
     */
    protected void checkInterfaceParameter(
            Map<String, Object> map, String[] checkParams
    ) throws IllegalServiceParameterException {
        // 方法所需参数
        for (String str : checkParams) {
            // 如果不存在跳出 同时抛出相应异常
            if (!map.containsKey(str)) {
                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
            }
        }
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }
}
