//package com.house365.ws.interfaces.rest;
//
//import com.google.common.base.Strings;
//import com.house365.beans.common.HGSConstant;
//import com.house365.beans.entity.CustomerEntity;
//import com.house365.beans.entity.UserEntity;
//import com.house365.rest.context.Parameter;
//import com.house365.rest.exception.IllegalServiceParameterException;
//import com.house365.rest.exception.ServiceRunException;
//import com.house365.rest.parameter.House365RestObject;
//import com.house365.rest.parameter.House365RestResponse;
//import com.house365.web.util.StringUtils;
//import com.house365.ws.beans.response.CustomerResponse;
//import com.house365.ws.service.interfaces.ICustomerService;
//import com.house365.ws.service.interfaces.IDepartmentService;
//import com.house365.ws.service.interfaces.IUserService;
//import com.house365.ws.system.ReturnAppResult;
//import com.house365.ws.util.Constant;
//import net.sf.json.JSONObject;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Service;
//
//import java.util.Date;
//import java.util.Map;
//
//@Service("addCustomer4NewHouse")
//public class AddCustomerInfo4NewHouseImpl implements IAddCustomer {
//
//    /**
//     * 跟踪状态：有效
//     */
//    static final int TRACE_STATUS_INVALID = 1;
//    private static final Logger LOGGER = LoggerFactory.getLogger(AddCustomerInfoImpl.class);
//    @Autowired
//    private ICustomerService<CustomerEntity> customerService;
//    @Autowired
//    private IUserService<UserEntity> userService;
//    @Autowired
//    private IDepartmentService departmentService;
//
//    public synchronized static CustomerEntity getCustomer(Map<String, Object> map) {
//        String name = getMapValueByKey(Constant.CUSTOMER_NAME, map, "");
//        String phone = getMapValueByKey(Constant.CUSTOMER_PHONE, map, "");
//        String cityCode = getMapValueByKey(Constant.CITY_CODE, map, "");
//        String cityName = getMapValueByKey(Constant.CITY_NAME, map, "");
////        String newhouseId = getMapValueByKey(Constant.NEWHOUSEID, map, "");
//        String sex = getMapValueByKey(Constant.CUSTOMER_SEX, map,
//                String.valueOf(Constant.CustomerSexEnum.NOTSURE.getMsg()));
//        String actSource = getMapValueByKey(Constant.CUSTOMER_ACTSOURCE, map, "");
//        String firstSource = getMapValueByKey(Constant.CUSTOMER_FIRSTSOURCE, map, "");
//        String latestSource = getMapValueByKey(Constant.CUSTOMER_LATESTSOURCE, map, "");
//        String latestCall = getMapValueByKey(Constant.CUSTOMER_CRM_LATESTSCALL, map, "");
//        String latestCallResult = getMapValueByKey(Constant.CUSTOMER_CRM_LATESTSCALL_RESULT, map, "");
//        String bizPort = getMapValueByKey("bizPort", map, "");
////        String buyIntention = getMapValueByKey("buyIntention", map, "");//新房固定传A:5
//        actSource = StringUtils.StringFilter(actSource);
//        CustomerEntity customerEntity = new CustomerEntity();
//        customerEntity.setName(name);
//        customerEntity.setPhone(phone);
//        customerEntity.setCityCode(cityCode);
//        customerEntity.setCityName(cityName);
////        customerEntity.setCrmId(newhouseId);
//        customerEntity.setSex(Integer.valueOf(sex));
//        customerEntity.setBizPort(bizPort);
//        customerEntity.setActSource(actSource);
//        customerEntity.setFirstSource(firstSource);
//        customerEntity.setCreateSource(Constant.CustomerSourceEnum.NEWHOUSE.getMsg());
//        customerEntity.setCustomerType(Constant.CustomerTypeEnum.ONLINE.getMsg());
//        customerEntity.setLatestSource(latestSource);
//        customerEntity.setCrmLatestCall(latestCall);
//        customerEntity.setCrmLatestCallResult(latestCallResult);
//        customerEntity.setCreateTime(new Date());
//        customerEntity.setCreater(Constant.CustomerSourceEnum.NEWHOUSE.getMsg());
//        customerEntity.setUpdater(Constant.CustomerSourceEnum.NEWHOUSE.getMsg());
//        customerEntity.setUpdateTime(new Date());
//        customerEntity.setStatus(Constant.CustomerStatusEnum.NORECORD.getStatus());
//        customerEntity.setBuyIntention(Constant.BUYINTENTION);//新房固定传A:5
//        customerEntity.setTraceStatus(TRACE_STATUS_INVALID);
//        customerEntity.setCrmSync("1");
//        customerEntity.setOceanDate(new Date());
//        customerEntity.setIsDelete(0);
//        customerEntity.setCustomerSourceType(HGSConstant.CustomerSourceType.NORMAL.getType());
//        return customerEntity;
//    }
//
//    /**
//     * 获取map中的值
//     *
//     * @param key          key
//     * @param map          map
//     * @param defaultValue 默认值
//     * @return value
//     */
//    private static String getMapValueByKey(String key, Map<String, Object> map, String defaultValue) {
//        String value = "";
//        if (map.containsKey(key) && map.get(key) != null && !Strings.isNullOrEmpty(((String[]) map.get(key))[0])) {
//            value = ((String[]) map.get(key))[0];
//        }
//
//        if (Strings.isNullOrEmpty(value)) {
//            value = defaultValue;
//        }
//        return value;
//    }
//
//    @Override
//    public Object rollback() {
//        return null;
//    }
//
//    @Override
//    public void commit() {
//
//    }
//
//    @Override
//    public Object exectue(Parameter parameter) throws ServiceRunException {
//        // 取得所需参数
//        Map<String, Object> map = parameter.getArgs();
//        House365RestResponse<CustomerResponse> response = new House365RestResponse<CustomerResponse>();
//        // 业务校验统一入口
//        try {
//            checkInterfaceParameter(map, Constant.AddCustomerParams4NewHouse);
//            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
//            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
//        } catch (IllegalServiceParameterException e) {
//            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
//            response.setMsg(e.getMessage());
//            return JSONObject.fromObject(response).toString();
//        }
//        // 业务层统一处理
//        try {
//            House365RestObject<CustomerEntity> data = doBusiness(map);
//            response.setResult(ReturnAppResult.APP_SUCCESS.getResultCode());
//            response.setMsg(ReturnAppResult.APP_SUCCESS.getResultMessage());
//        } catch (Exception e) {
//            LOGGER.error(e.getMessage(), e);
//            response.setResult(ReturnAppResult.APP_FAIL.getResultCode());
//            response.setMsg((ReturnAppResult.APP_FAIL.getResultMessage() + ":" + e.getMessage()));
//        }
//        String result = JSONObject.fromObject(response).toString();
//        return result;
//    }
//
//    @Override
//    public boolean isControlService() {
//        return false;
//    }
//
//    @Override
//    public boolean isLogService() {
//        return false;
//    }
//
//    @Override
//    public boolean isMonitorService() {
//        return false;
//    }
//
//    /**
//     * 业务层统逻辑处理
//     */
//    private House365RestObject<CustomerEntity> doBusiness(Map<String, Object> map) throws Exception {
//        // 返回Json对象
//        House365RestObject<CustomerEntity> restObject = new House365RestObject<>();
//        CustomerEntity customerEntity = getCustomer(map);
//        //重置客户绑定置业顾问时间
//        customerEntity.setBindTime(new Date());
//        customerService.createCustomer(customerEntity, Constant.CustomerSourceEnum.NEWHOUSE.getMsg());
//        LOGGER.warn("CRMADDCUSTOMER --- [{}]", customerEntity.toString());
//        //客户经理
//        String userId = getMapValueByKey(Constant.USER_ID, map, "");
//        //如果传了userid，绑定客户经理
//        if (!Strings.isNullOrEmpty(userId)) {
//            UserEntity user = userService.getById(Integer.valueOf(userId));
//            if (user != null) {
//                customerService.bindCustomer(customerEntity, user);
//            } else {
//                LOGGER.error("绑定客户经理失败，ID不存在：" + userId);
//            }
//        }
//
//        restObject.setEntity(customerEntity);
//        return restObject;
//    }
//
//    /**
//     * 业务层统校验自己所需参数是否存在
//     * 所有参数都要存在
//     *
//     * @author hqc
//     */
//    protected void checkInterfaceParameter(
//            Map<String, Object> map, String[] checkParams
//    ) throws IllegalServiceParameterException {
//        // 方法所需参数
//        for (String str : checkParams) {
//            // 如果不存在跳出 同时抛出相应异常
//            if (!map.containsKey(str)) {
//                throw new IllegalServiceParameterException("业务入口参数异常：" + str + "参数为空!");
//            }
//        }
//    }
//
//}
