/**
 * Description: 直销人员楼盘推荐WS接口
 * Copyright:   Copyright (c)2018
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2018-01-22 下午 13:57:27
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2018-01-22   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.UserProjectRecommendEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.UserProjectRecommendListRequest;
import com.house365.ws.beans.request.UserProjectRecommendRequest;
import com.house365.ws.beans.response.UserProjectRecommendListResponse;
import com.house365.ws.beans.response.UserProjectRecommendResponse;
import com.house365.ws.beans.util.HResult;
import com.house365.ws.dao.mapper.ProjectRecommendMapper;
import com.house365.ws.interfaces.server.IUserProjectRecommend;
import com.house365.ws.service.interfaces.IUserProjectRecommendService;
import com.house365.ws.system.ReturnResult;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * 直销人员楼盘推荐WS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2018-01-22
 * @see
 * @since 1.0
 */
@Service("userProjectRecommend")
public class UserProjectRecommendImpl implements IUserProjectRecommend {
    /**
     * 日志记录器
     */
    private static final Logger logger = LoggerFactory.getLogger(UserProjectRecommendImpl.class);

    /**
     * 直销人员楼盘推荐服务对象
     */
    @Autowired
    private IUserProjectRecommendService<UserProjectRecommendEntity> userProjectRecommendService;
    @Autowired
    private ProjectRecommendMapper recommendMapper;

    /**
     * 直销人员楼盘推荐列表查询
     *
     * @param request 直销人员楼盘推荐列表查询请求
     * @return 直销人员楼盘推荐列表查询响应
     */
    @Override
    public UserProjectRecommendListResponse getUserProjectRecommendList(UserProjectRecommendListRequest request) {
        UserProjectRecommendListResponse response = new UserProjectRecommendListResponse();
        try {
            QueryParams<UserProjectRecommendEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<UserProjectRecommendEntity> userProjectRecommends = userProjectRecommendService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(userProjectRecommends);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存直销人员楼盘推荐
     *
     * @param request 直销人员楼盘推荐请求
     * @return 保存直销人员楼盘推荐响应
     */
    @Override
    public UserProjectRecommendResponse addUserProjectRecommend(UserProjectRecommendRequest request) {
        UserProjectRecommendResponse response = new UserProjectRecommendResponse();
        try {
            UserProjectRecommendEntity entity = request.getEntity();
            //同一楼盘，1个安家顾问只能推荐一次
            String projectName = entity.getProjectName();
            int userId = entity.getUserId();
            String city = entity.getCity();
            Map<String, Object> map = new HashMap<>(10);
            map.put("userId", userId);
            map.put("projectName", projectName);
            map.put("city", city);
            List<UserProjectRecommendEntity> list = recommendMapper.queryByConditions(map);
            if (CollectionUtils.isNotEmpty(list)) {
                response.setResultCode("100");
                response.setResultMessage("该楼盘已推荐");
                throw new Exception(response.getResultMessage());
            } else {
                userProjectRecommendService.save(entity);
                response.setEntity(entity);
                response.setResultCode(ReturnResult.SUCCESS.getResultCode());
                response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
            }
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public HResult save(UserProjectRecommendEntity entity) {
        HResult result = new HResult();
        //同一楼盘，1个安家顾问只能推荐一次
        String projectName = entity.getProjectName();
        int userId = entity.getUserId();
        String city = entity.getCity();
        Map<String, Object> map = new HashMap<>(10);
        map.put("userId", userId);
        map.put("projectName", projectName);
        map.put("city", city);
        List<UserProjectRecommendEntity> list = recommendMapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            result.setStatus(100);
            result.setErrorMessage("该楼盘已推荐");
        } else {
            userProjectRecommendService.save(entity);
        }
        return result;
    }

    /**
     * 删除直销人员楼盘推荐通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除直销人员楼盘推荐响应
     */
    @Override
    public UserProjectRecommendResponse deleteUserProjectRecommendById(Integer id) {
        UserProjectRecommendResponse response = new UserProjectRecommendResponse();
        try {
            UserProjectRecommendEntity entity = userProjectRecommendService.getById(id);
            entity.setIsDeleted(1);
            entity.setUpdateTime(new Date());
            userProjectRecommendService.update(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改直销人员楼盘推荐
     *
     * @param request 修改直销人员楼盘推荐请求
     * @return 修改直销人员楼盘推荐响应
     */
    @Override
    public UserProjectRecommendResponse updateUserProjectRecommend(UserProjectRecommendRequest request) {
        UserProjectRecommendResponse response = new UserProjectRecommendResponse();
        try {
            userProjectRecommendService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取直销人员楼盘推荐
     *
     * @param id 唯一标识
     * @return 通过ID获取直销人员楼盘推荐响应
     */
    @Override
    public UserProjectRecommendResponse getUserProjectRecommendById(Integer id) {
        UserProjectRecommendResponse response = new UserProjectRecommendResponse();
        try {
            UserProjectRecommendEntity entity = userProjectRecommendService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }


    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
