/**
 * Description: StatusSourceStatisticsWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-11-02 下午 17:54:57
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-11-02   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.StatusSourceStatisticsEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.StatusSourceStatisticsListRequest;
import com.house365.ws.beans.request.StatusSourceStatisticsRequest;
import com.house365.ws.beans.response.SourceStatisticsListResponse;
import com.house365.ws.beans.response.StatusSourceStatisticsListResponse;
import com.house365.ws.beans.response.StatusSourceStatisticsResponse;
import com.house365.ws.dao.mapper.CallDailyMapper;
import com.house365.ws.interfaces.server.IStatusSourceStatistics;
import com.house365.ws.service.interfaces.IStatusSourceStatisticsService;
import com.house365.ws.system.ReturnResult;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * StatusSourceStatisticsWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-11-02
 * @see
 * @since 1.0
 */
@Service("statusSourceStatistics")
public class StatusSourceStatisticsImpl implements IStatusSourceStatistics {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusSourceStatisticsImpl.class);

    /**
     * StatusSourceStatistics服务对象
     */
    @Autowired
    IStatusSourceStatisticsService<StatusSourceStatisticsEntity> statusSourceStatisticsService;

    @Autowired
    private CallDailyMapper mapper;

    /**
     * StatusSourceStatistics列表查询
     *
     * @param request StatusSourceStatistics列表查询请求
     * @return StatusSourceStatistics列表查询响应
     */
    @Override
    public StatusSourceStatisticsListResponse getStatusSourceStatisticsList(StatusSourceStatisticsListRequest request) {
        StatusSourceStatisticsListResponse response = new StatusSourceStatisticsListResponse();
        try {
            QueryParams<StatusSourceStatisticsEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<StatusSourceStatisticsEntity> statusSourceStatisticss = statusSourceStatisticsService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(statusSourceStatisticss);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存StatusSourceStatistics
     *
     * @param request StatusSourceStatistics请求
     * @return 保存StatusSourceStatistics响应
     */
    @Override
    public StatusSourceStatisticsResponse addStatusSourceStatistics(StatusSourceStatisticsRequest request) {
        StatusSourceStatisticsResponse response = new StatusSourceStatisticsResponse();
        try {
            StatusSourceStatisticsEntity entity = request.getEntity();
            statusSourceStatisticsService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除StatusSourceStatistics通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除StatusSourceStatistics响应
     */
    @Override
    public StatusSourceStatisticsResponse deleteStatusSourceStatisticsById(Integer id) {
        StatusSourceStatisticsResponse response = new StatusSourceStatisticsResponse();
        try {
            statusSourceStatisticsService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改StatusSourceStatistics
     *
     * @param request 修改StatusSourceStatistics请求
     * @return 修改StatusSourceStatistics响应
     */
    @Override
    public StatusSourceStatisticsResponse updateStatusSourceStatistics(StatusSourceStatisticsRequest request) {
        StatusSourceStatisticsResponse response = new StatusSourceStatisticsResponse();
        try {
            statusSourceStatisticsService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取StatusSourceStatistics
     *
     * @param id 唯一标识
     * @return 通过ID获取StatusSourceStatistics响应
     */
    @Override
    public StatusSourceStatisticsResponse getStatusSourceStatisticsById(Integer id) {
        StatusSourceStatisticsResponse response = new StatusSourceStatisticsResponse();
        try {
            StatusSourceStatisticsEntity entity = statusSourceStatisticsService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 状态来源分析
     *
     * @param request
     * @param dateViewType
     * @return
     */
    @Override
    public SourceStatisticsListResponse statusSourceStatistic(StatusSourceStatisticsListRequest request, String dateViewType) {
        SourceStatisticsListResponse response = new SourceStatisticsListResponse();
        try {
            QueryParams<StatusSourceStatisticsEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());

            //按天 周 月 统计
            List<Map> projectSourceStatisticss = new ArrayList<>();
            if ("1".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = statusSourceStatisticsService.statisticStatusSource(queryParams);
            } else if ("2".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = statusSourceStatisticsService.statisticStatusSourceByWeek(queryParams);
            } else if ("3".equalsIgnoreCase(dateViewType)) {
                projectSourceStatisticss = statusSourceStatisticsService.statisticStatusSourceByMonth(queryParams);
            }

            //查询出上个周期数据，计算环比
            for (Map map : projectSourceStatisticss) {
                BigDecimal curData = map.get("customerNum") == null ? BigDecimal.ZERO : new BigDecimal(
                        String.valueOf(map.get("customerNum")));
                BigDecimal preData = map.get("prenum") == null ? BigDecimal.ZERO : new BigDecimal(
                        String.valueOf(map.get("prenum")));
                if (preData.compareTo(BigDecimal.ZERO) <= 0) {
                    map.put("huanbi", "-");
                } else {
                    BigDecimal huanbi = curData.subtract(preData).divide(preData, 4, BigDecimal.ROUND_HALF_UP);
                    if (huanbi.compareTo(BigDecimal.ZERO) == 0) {
                        map.put("huanbi", "-");
                    } else {
                        map.put("huanbi", huanbi.multiply(new BigDecimal(100)).setScale(2) + "%");
                    }
                }
            }

            response.setObjectList(projectSourceStatisticss);
            response.setPaging(queryParams.getPaging());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public List<Map<String, Object>> queryByUserId(Map<String, Object> map) {
        List<Map<String, Object>> list = mapper.queryByUserId(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> queryByDept(Map<String, Object> map) {
        List<Map<String, Object>> list = mapper.queryByDept(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
