/**
 * Description: ReportChannelDepartRelWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-07-17 上午 10:14:20
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.ReportChannelDepartRelEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.ReportChannelDepartRelListRequest;
import com.house365.ws.beans.request.ReportChannelDepartRelRequest;
import com.house365.ws.beans.response.ReportChannelDepartRelListResponse;
import com.house365.ws.beans.response.ReportChannelDepartRelResponse;
import com.house365.ws.interfaces.server.IReportChannelDepartRel;
import com.house365.ws.service.interfaces.IReportChannelDepartRelService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * ReportChannelDepartRelWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
@Service("reportChannelDepartRel")
public class ReportChannelDepartRelImpl implements IReportChannelDepartRel {
    /**
     * 日志记录器
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportChannelDepartRelImpl.class);

    /**
     * ReportChannelDepartRel服务对象
     */
    @Autowired
    IReportChannelDepartRelService<ReportChannelDepartRelEntity> reportChannelDepartRelService;

    /**
     * ReportChannelDepartRel列表查询
     *
     * @param request ReportChannelDepartRel列表查询请求
     * @return ReportChannelDepartRel列表查询响应
     */
    @Override
    public ReportChannelDepartRelListResponse getReportChannelDepartRelList(
            ReportChannelDepartRelListRequest request
    ) {
        ReportChannelDepartRelListResponse response = new ReportChannelDepartRelListResponse();
        try {
            QueryParams<ReportChannelDepartRelEntity> queryParams = new QueryParams<>(request.getSearchParams());
            queryParams.setPaging(request.getPaging());
            queryParams.setOrderColumn(request.getOrderColumn());
            queryParams.setOrderMode(request.getOrderMode());
            List<ReportChannelDepartRelEntity> reportChannelDepartRels = reportChannelDepartRelService.queryByPage(
                    queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(reportChannelDepartRels);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 保存ReportChannelDepartRel
     *
     * @param request ReportChannelDepartRel请求
     * @return 保存ReportChannelDepartRel响应
     */
    @Override
    public ReportChannelDepartRelResponse addReportChannelDepartRel(ReportChannelDepartRelRequest request) {
        ReportChannelDepartRelResponse response = new ReportChannelDepartRelResponse();
        try {
            ReportChannelDepartRelEntity entity = request.getEntity();
            reportChannelDepartRelService.save(entity);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 删除ReportChannelDepartRel通过唯一标识
     *
     * @param id 唯一标识
     * @return 删除ReportChannelDepartRel响应
     */
    @Override
    public ReportChannelDepartRelResponse deleteReportChannelDepartRelById(Integer id) {
        ReportChannelDepartRelResponse response = new ReportChannelDepartRelResponse();
        try {
            reportChannelDepartRelService.delete(id);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 修改ReportChannelDepartRel
     *
     * @param request 修改ReportChannelDepartRel请求
     * @return 修改ReportChannelDepartRel响应
     */
    @Override
    public ReportChannelDepartRelResponse updateReportChannelDepartRel(
            ReportChannelDepartRelRequest request
    ) {
        ReportChannelDepartRelResponse response = new ReportChannelDepartRelResponse();
        try {
            reportChannelDepartRelService.update(request.getEntity());
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    /**
     * 通过ID获取ReportChannelDepartRel
     *
     * @param id 唯一标识
     * @return 通过ID获取ReportChannelDepartRel响应
     */
    @Override
    public ReportChannelDepartRelResponse getReportChannelDepartRelById(Integer id) {
        ReportChannelDepartRelResponse response = new ReportChannelDepartRelResponse();
        try {
            ReportChannelDepartRelEntity entity = reportChannelDepartRelService.getById(id);
            response.setEntity(entity);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;
    }

    @Override
    public void deleteByChannelId(Integer... ids) {
        reportChannelDepartRelService.deleteByChannelId(ids);
    }

    /**
     * 以下均为自动生成
     */

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {
    }
}
