package com.house365.ws.interfaces.impl;

import com.house365.beans.entity.ProjectLogEntity;
import com.house365.ws.dao.mapper.ProjectLogMapper;
import com.house365.ws.interfaces.server.IProjectLogInterface;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * @author Created by Administrator on 2019/8/12.
 */
@Service("projectLog")
public class ProjectLogImpl implements IProjectLogInterface {

    @Autowired
    private ProjectLogMapper logMapper;

    @Override
    public void save(ProjectLogEntity entity) {
        logMapper.save(entity);
    }

    @Override
    public List<ProjectLogEntity> queryByConditions(Map<String, Object> map) {
        List<ProjectLogEntity> list = logMapper.queryByConditions(map);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Collections.emptyList();
    }
}
