package com.house365.ws.interfaces.impl;

import com.google.common.base.Joiner;
import com.house365.beans.entity.CustomerCallbackRecordEntity;
import com.house365.beans.system.QueryParams;
import com.house365.rest.context.Parameter;
import com.house365.rest.exception.ServiceRunException;
import com.house365.ws.beans.request.CustomerCallbackRecordListRequest;
import com.house365.ws.beans.response.CustomerCallbackRecordListResponse;
import com.house365.ws.interfaces.server.ICustomerCallbackRecord;
import com.house365.ws.service.interfaces.ICustomerCallbackRecordService;
import com.house365.ws.service.interfaces.IUserService;
import com.house365.ws.system.ReturnResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Description
 *
 * @author Administrator
 * @date 2018/6/26
 */
@Service("callbackRecord")
public class CustomerCallbackRecordImpl implements ICustomerCallbackRecord {

    private static final Logger LOGGER = LoggerFactory.getLogger(CustomerCallbackRecordImpl.class);

    @Autowired
    private ICustomerCallbackRecordService<CustomerCallbackRecordEntity> customerCallbackRecordService;

    @Autowired
    IUserService userService;

    @Override
    public Object rollback() {
        return null;
    }

    @Override
    public void commit() {

    }

    @Override
    public Object exectue(Parameter parameter) throws ServiceRunException {
        return null;
    }

    @Override
    public boolean isControlService() {
        return false;
    }

    @Override
    public boolean isLogService() {
        return false;
    }

    @Override
    public boolean isMonitorService() {
        return false;
    }

    @Override
    public CustomerCallbackRecordListResponse getCustomerCallbackRecordList(CustomerCallbackRecordListRequest listRequest) {

        CustomerCallbackRecordListResponse response = new CustomerCallbackRecordListResponse();

        try {
            QueryParams<CustomerCallbackRecordEntity> queryParams = new QueryParams<>(
                    listRequest.getSearchParams());

            //拿到此用户id和cityCode
            Integer userId = (Integer) listRequest.getSearchParams().get("EQ_userId");
            String cityCode = (String)listRequest.getSearchParams().get("EQ_cityCode");

            List<Integer> userIds = userService.getUserIdOnPath(userId);

            listRequest.getSearchParams().put("EQ_userIds", Joiner.on(",").join(userIds));
            listRequest.getSearchParams().put("EQ_cityCode", cityCode);

            queryParams.setPaging(listRequest.getPaging());
            queryParams.setOrderColumn(listRequest.getOrderColumn());
            queryParams.setOrderMode(listRequest.getOrderMode());
            List<CustomerCallbackRecordEntity> customerCallbackRecord = customerCallbackRecordService.queryCallbackRecord(queryParams);
            //List<CustomerCallbackRecordEntity> customerCallbackRecord =customerCallbackRecordService.queryByPage(queryParams);
            response.setPaging(queryParams.getPaging());
            response.setObjectList(customerCallbackRecord);
            response.setResultCode(ReturnResult.SUCCESS.getResultCode());
            response.setResultMessage(ReturnResult.SUCCESS.getResultMessage());
        } catch (Exception ex) {
            LOGGER.error(ex.getMessage(), ex);
            response.setResultCode(ReturnResult.FAIL.getResultCode());
            response.setResultMessage(ex.getMessage());
        }
        return response;

    }
}
