/**
 * Description: ProjectSourceStatistics数据访问接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-10-17 下午 14:59:25
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-10-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import java.util.List;

import com.house365.beans.system.QueryParams;
import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.entity.ProjectSourceStatisticsEntity;
import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.beans.po.ProjectSrouceRePo;

/**
 * ProjectSourceStatistics数据访问接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-10-17
 * @see
 * @since 1.0
 */
public interface IProjectSourceStatisticsDao<T extends ProjectSourceStatisticsEntity> extends Dao<T> {
    public List<ProjectSrouceRePo> queryByDay(ProjectSrouceParaPo para);

    public List<ProjectSrouceRePo> queryByWeek(ProjectSrouceParaPo para);

    public List<ProjectSrouceRePo> queryByMonth(ProjectSrouceParaPo para);

    List<ProjectSourceStatisticsEntity> statisticCustomer(QueryParams<?> queryParams);

    void updateProjectName();

    void updateSourceName();

    void updateCityName();

    void deleteByDate(String startDateStr);
}
