/**
 * Description: 客户信息数据访问接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-12-05 下午 19:21:01
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import com.house365.beans.entity.MarketingActivityEntity;
import com.house365.dao.system.interfaces.Dao;

import com.house365.beans.entity.MarketCustomerEntity;

import java.util.List;

/**
 * 客户信息数据访问接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public interface IMarketCustomerDao<T extends MarketCustomerEntity> extends Dao<T>{
    void clean();

    void updateSignupSourceName();

    List<T> getByActiveId(Integer activeId);

    List<MarketCustomerEntity> queryByIds(String customerIds);

    List<MarketCustomerEntity> getUseMarketingActivity(MarketCustomerEntity marketcustomerentity);

    T queryByCustomerid(Integer custmerId);

    List<MarketCustomerEntity> getOverTimeCustomers();

}
