/**
 * Description: 客户状态变更纪录数据访问接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-15 下午 15:36:20
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.interfaces;

import java.util.List;
import java.util.Map;

import com.house365.dao.system.interfaces.Dao;
import com.house365.beans.entity.CustomerStatusLogEntity;
import com.house365.beans.po.ProjectSrouceParaPo;

/**
 * 客户状态变更纪录数据访问接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public interface ICustomerStatusLogDao<T extends CustomerStatusLogEntity> extends Dao<T>{
    CustomerStatusLogEntity addCustomerStatusLog(CustomerStatusLogEntity customerStatusLogEntity);
    public List<Map<String, Long>> getProjectTransform(Map<String, Object> map);
    public List<Map<String, Object>> getProjectSource(ProjectSrouceParaPo map);
}
