/**
 * Description: CmDictionary数据访问实现类
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-08-30 下午 13:46:00
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-08-30   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.DictionaryEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.IDictionaryDao;
import org.springframework.stereotype.Repository;

/**
 * CmDictionary数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-08-30
 * @see
 * @since 1.0
 */
@Repository("dictionaryDao")
public class DictionaryDaoImpl extends DefaultDaoImpl<DictionaryEntity> implements IDictionaryDao<DictionaryEntity> {
    @Override
    public void deleteByKey(String key) {
        getWriteTemplate().delete(getStatement(), key);
    }
}
