/**
 * Description: CrmSource数据访问实现类
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2017-12-09 下午 16:02:32
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-09   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.dao.impl;

import com.house365.beans.entity.CrmSourceEntity;
import com.house365.dao.system.impl.DefaultDaoImpl;
import com.house365.ws.dao.interfaces.ICrmSourceDao;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * CrmSource数据访问实现类<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-09
 * @see
 * @since 1.0
 */
@Repository("crmSourceDao")
public class CrmSourceDaoImpl extends DefaultDaoImpl<CrmSourceEntity> implements ICrmSourceDao<CrmSourceEntity> {

    @Override
    public void truncateTable() {
        getReadTemplate().delete(getStatement());
    }

    @Override
    public List<CrmSourceEntity> getListByCategory(String categoryReg) {
        return (List<CrmSourceEntity>) getReadTemplate().queryForList(getStatement(), categoryReg);
    }


}
