/**
 * Description: StatusSourceStatisticsWS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-11-02 下午 17:54:57
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-11-02   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.StatusSourceStatisticsListRequest;
import com.house365.ws.beans.request.StatusSourceStatisticsRequest;
import com.house365.ws.beans.response.SourceStatisticsListResponse;
import com.house365.ws.beans.response.StatusSourceStatisticsListResponse;
import com.house365.ws.beans.response.StatusSourceStatisticsResponse;

import java.util.List;
import java.util.Map;


/**
 * StatusSourceStatisticsWS接口<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-11-02
 * @see
 * @since 1.0
 */
public interface IStatusSourceStatistics extends IService {

    /**
     * StatusSourceStatistics列表查询
     *
     * @param request
     *            StatusSourceStatistics列表查询请求
     * @return StatusSourceStatistics列表查询响应
     */
    StatusSourceStatisticsListResponse getStatusSourceStatisticsList(
        StatusSourceStatisticsListRequest request
    );

    /**
     * 保存StatusSourceStatistics
     *
     * @param request
     *            StatusSourceStatistics请求
     * @return 保存StatusSourceStatistics响应
     */
    StatusSourceStatisticsResponse addStatusSourceStatistics(StatusSourceStatisticsRequest request);

    /**
     * 删除StatusSourceStatistics通过唯一标识
     *
     * @param id
     *            唯一标识
     * @return 删除StatusSourceStatistics响应
     */
    StatusSourceStatisticsResponse deleteStatusSourceStatisticsById(Integer id);

    /**
     * 修改StatusSourceStatistics
     *
     * @param request
     *            修改StatusSourceStatistics请求
     * @return 修改StatusSourceStatistics响应
     */
    StatusSourceStatisticsResponse updateStatusSourceStatistics(
        StatusSourceStatisticsRequest request
    );

    /**
     * 通过ID获取StatusSourceStatistics
     *
     * @param id
     *            唯一标识
     * @return 通过ID获取StatusSourceStatistics响应
     */
    StatusSourceStatisticsResponse getStatusSourceStatisticsById(Integer id);

    SourceStatisticsListResponse statusSourceStatistic(
        StatusSourceStatisticsListRequest request, String dateViewType
    );

    List<Map<String,Object>> queryByUserId(Map<String,Object> map);

    List<Map<String,Object>> queryByDept(Map<String,Object> map);
}
