/**
 * Description: ReportChannelDepartRelWS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-07-17 上午 10:14:20
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-07-17   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.ReportChannelDepartRelListRequest;
import com.house365.ws.beans.request.ReportChannelDepartRelRequest;
import com.house365.ws.beans.response.ReportChannelDepartRelListResponse;
import com.house365.ws.beans.response.ReportChannelDepartRelResponse;


/**
 * ReportChannelDepartRelWS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-07-17
 * @see
 * @since 1.0
 */
public interface IReportChannelDepartRel extends IService{

    /**
     * ReportChannelDepartRel列表查询
     * 
     * @param request
     *            ReportChannelDepartRel列表查询请求
     * @return ReportChannelDepartRel列表查询响应
     */
    ReportChannelDepartRelListResponse getReportChannelDepartRelList(
        ReportChannelDepartRelListRequest request
    );

    /**
     * 保存ReportChannelDepartRel
     * 
     * @param request
     *            ReportChannelDepartRel请求
     * @return 保存ReportChannelDepartRel响应
     */
    ReportChannelDepartRelResponse addReportChannelDepartRel(ReportChannelDepartRelRequest request);

    /**
     * 删除ReportChannelDepartRel通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除ReportChannelDepartRel响应
     */
    ReportChannelDepartRelResponse deleteReportChannelDepartRelById(Integer id);

    /**
     * 修改ReportChannelDepartRel
     * 
     * @param request
     *            修改ReportChannelDepartRel请求
     * @return 修改ReportChannelDepartRel响应
     */
    ReportChannelDepartRelResponse updateReportChannelDepartRel(
        ReportChannelDepartRelRequest request
    );

    /**
     * 通过ID获取ReportChannelDepartRel
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取ReportChannelDepartRel响应
     */
    ReportChannelDepartRelResponse getReportChannelDepartRelById(Integer id);

    void deleteByChannelId(Integer... ids);
}
