/**
 * Description: 公告WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-14 下午 17:27:17
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.NoticeListRequest;
import com.house365.ws.beans.request.NoticeRequest;
import com.house365.ws.beans.response.NoticeListResponse;
import com.house365.ws.beans.response.NoticeResponse;


/**
 * 公告WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-14
 * @see
 * @since 1.0
 */
public interface INotice extends IService{

    /**
     * 公告列表查询
     * 
     * @param request
     *            公告列表查询请求
     * @return 公告列表查询响应
     */
    NoticeListResponse getNoticeList(
            NoticeListRequest request);

    NoticeListResponse getNoticeListForIndexPage(String city);

    /**
     * 保存公告
     * 
     * @param request
     *            公告请求
     * @return 保存公告响应
     */
    NoticeResponse addNotice(NoticeRequest request);

    /**
     * 删除公告通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除公告响应
     */
    NoticeResponse deleteNoticeById(Integer id);

    /**
     * 修改公告
     * 
     * @param request
     *            修改公告请求
     * @return 修改公告响应
     */
    NoticeResponse updateNotice(
            NoticeRequest request);

    /**
     * 通过ID获取公告
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取公告响应
     */
    NoticeResponse getNoticeById(Integer id);
}
