/**
 * Description: 客户信息WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-12-05 下午 19:21:01
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-12-05   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.beans.entity.MarketCustomerEntity;
import com.house365.rest.context.IService;
import com.house365.rest.parameter.House365RestResponse;
import com.house365.ws.beans.request.MarketCustomerListRequest;
import com.house365.ws.beans.request.MarketCustomerRequest;
import com.house365.ws.beans.response.MarketCustomerListResponse;
import com.house365.ws.beans.response.MarketCustomerResponse;
import com.house365.ws.beans.util.HResult;

import java.util.List;


/**
 * 客户信息WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-12-05
 * @see
 * @since 1.0
 */
public interface IMarketCustomer extends IService{

    House365RestResponse assignCustomer(Integer id);

    /**
     * 客户信息列表查询
     * 
     * @param request
     *            客户信息列表查询请求
     * @return 客户信息列表查询响应
     */
    MarketCustomerListResponse getMarketCustomerList(MarketCustomerListRequest request);

    MarketCustomerListResponse getTotalCount(MarketCustomerListRequest request);

    /**
     * 保存客户信息
     * 
     * @param request
     *            客户信息请求
     * @return 保存客户信息响应
     */
    MarketCustomerResponse addMarketCustomer(MarketCustomerRequest request);

    /**
     * 删除客户信息通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除客户信息响应
     */
    MarketCustomerResponse deleteMarketCustomerById(Integer id);

    /**
     * 修改客户信息
     * 
     * @param request
     *            修改客户信息请求
     * @return 修改客户信息响应
     */
    MarketCustomerResponse updateMarketCustomer(MarketCustomerRequest request);

    /**
     * 通过ID获取客户信息
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取客户信息响应
     */
    MarketCustomerResponse getMarketCustomerById(Integer id);

    void addCallbackCount(Integer customerId);

    void addVisitCount(Integer customerId);

    void addBuyCount(Integer customerId);

    HResult judgeCustomer(int id);

    List<String> getExistPhone(List<String> phoneList);

}
