/**
 * Description: 客户-置业顾问关联WS接口
 * Copyright:   Copyright (c)2017
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2017-03-14 下午 13:43:59
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2017-03-14   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CustomerUserListRequest;
import com.house365.ws.beans.request.CustomerUserRequest;
import com.house365.ws.beans.response.CustomerUserListResponse;
import com.house365.ws.beans.response.CustomerUserResponse;


/**
 * 客户-置业顾问关联WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2017-03-14
 * @see
 * @since 1.0
 */
public interface ICustomerUser extends IService{

    /**
     * 客户-置业顾问关联列表查询
     * 
     * @param request
     *            客户-置业顾问关联列表查询请求
     * @return 客户-置业顾问关联列表查询响应
     */
    CustomerUserListResponse getCustomerUserList(
        CustomerUserListRequest request
    );

    /**
     * 保存客户-置业顾问关联
     * 
     * @param request
     *            客户-置业顾问关联请求
     * @return 保存客户-置业顾问关联响应
     */
    CustomerUserResponse addCustomerUser(CustomerUserRequest request);

    /**
     * 删除客户-置业顾问关联通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除客户-置业顾问关联响应
     */
    CustomerUserResponse deleteCustomerUserById(Integer id);

    /**
     * 修改客户-置业顾问关联
     * 
     * @param request
     *            修改客户-置业顾问关联请求
     * @return 修改客户-置业顾问关联响应
     */
    CustomerUserResponse updateCustomerUser(
        CustomerUserRequest request
    );

    /**
     * 通过ID获取客户-置业顾问关联
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取客户-置业顾问关联响应
     */
    CustomerUserResponse getCustomerUserById(Integer id);
}
