/**
 * Description: 客户状态变更纪录WS接口
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 * @author:     江苏三六五网络股份有限公司
 * @version:    1.0
 * Create at:   2016-09-15 下午 15:36:20
 *  
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.ws.interfaces.server;

import java.util.List;
import java.util.Map;

import com.house365.beans.po.ProjectSrouceParaPo;
import com.house365.rest.context.IService;
import com.house365.ws.beans.request.CustomerStatusLogListRequest;
import com.house365.ws.beans.request.CustomerStatusLogRequest;
import com.house365.ws.beans.response.CustomerStatusLogListResponse;
import com.house365.ws.beans.response.CustomerStatusLogResponse;


/**
 * 客户状态变更纪录WS接口<br>
 * 
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public interface ICustomerStatusLog extends IService{

    /**
     * 客户状态变更纪录列表查询
     * 
     * @param request
     *            客户状态变更纪录列表查询请求
     * @return 客户状态变更纪录列表查询响应
     */
    CustomerStatusLogListResponse getCustomerStatusLogList(
        CustomerStatusLogListRequest request
    );

    /**
     * 保存客户状态变更纪录
     * 
     * @param request
     *            客户状态变更纪录请求
     * @return 保存客户状态变更纪录响应
     */
    CustomerStatusLogResponse addCustomerStatusLog(CustomerStatusLogRequest request);

    /**
     * 删除客户状态变更纪录通过唯一标识
     * 
     * @param id
     *            唯一标识
     * @return 删除客户状态变更纪录响应
     */
    CustomerStatusLogResponse deleteCustomerStatusLogById(Integer id);

    /**
     * 修改客户状态变更纪录
     * 
     * @param request
     *            修改客户状态变更纪录请求
     * @return 修改客户状态变更纪录响应
     */
    CustomerStatusLogResponse updateCustomerStatusLog(
        CustomerStatusLogRequest request
    );

    /**
     * 通过ID获取客户状态变更纪录
     * 
     * @param id
     *            唯一标识
     * @return 通过ID获取客户状态变更纪录响应
     */
    CustomerStatusLogResponse getCustomerStatusLogById(Integer id);
    
    public List<Map<String, Long>> getProjectTransform(Map<String, Object> map);
    public List<Map<String, Object>> getProjectSource(ProjectSrouceParaPo map);
}
