<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/userprojectrecommend/recommend<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">
    <input type="hidden" id="id" name="entity.id" value="${entity.id}"/>
    <input type="hidden" id="userId" name="entity.userId" value="${entity.userId}"/>
    <input type="hidden" id="userName" name="entity.userName" value="${entity.userName}"/>
    <input type="hidden" id="projectId" name="entity.projectId" value="${entity.projectId}"/>
    <input type="hidden" id="projectName" name="entity.projectName" value="${entity.projectName}"/>
    <input type="hidden" id="createTimeStr" name="entity.createTimeStr"
           value="<fmt:formatDate value='${entity.createTime}' pattern='yyyy-MM-dd HH:mm:ss' />"/>
    <input type="hidden" id="updateTimeStr" name="entity.updateTimeStr"
           value="<fmt:formatDate value='${entity.updateTime}' pattern='yyyy-MM-dd HH:mm:ss' />"/>
    <input type="hidden" id="isDeleted" name="entity.isDeleted" value="${entity.isDeleted}"/>
    <input type="hidden" id="channel" name="entity.channel" value="${entity.channel}"/>
    <input type="hidden" id="city" name="entity.city" value="${entity.city}"/>

    <div class=" control-group">
        <label class="control-label">楼盘名称:</label>
        <div class="controls">
            <c:if test="${action=='edit'}">
                <input type="text" id="chooseRelBuilding" class="span4" readonly>
            </c:if>
            <c:if test="${action!='edit'}">
                <input type="text" id="chooseRelBuilding" class="span4">
            </c:if>
        </div>
    </div>
    <div class=" control-group">
        <label class="control-label">推荐理由:</label>
        <div class="controls">
                <textarea id="recommendReason" style='margin: 0px 0px 10px; width: 436px; height: 191px;' cols="80"
                          rows="10"
                          name="entity.recommendReason">${entity.recommendReason}</textarea>
        </div>
    </div>
</form>
</body>
<script>

    $("#chooseRelBuilding").select2({
        placeholder: "${entity.projectName}" || "请选择推荐楼盘",
        // 输入几个字符开始联想
        minimumInputLength: 1,
        // 最大返回记录数
        minimumResultsForSearch: 10,
        maximumSelectionLength: 1,
        minimumSelectionLength: 1,
        containerCssClass: "chosen, chosen-with-diselect",
        query: function (query) {
            $.ajax({
                timeout: 1000,
                url: "${ctx}/remoteJson/getJson",
                data: {
                    url: "http://newapi.house365.com/projects/name",
                    city: "${city}",
                    limit: 20,
                    name: query.term,
                    like: 1
                },
                type: "GET",
                dataType: "json",
                success: function (data, status) {
                    console.log(data)
                    var pageData = {
                        results: []
                    };
                    $.each(data.data.list, function (i, item) {
                        pageData.results.push({
                            id: item.itemname + "@#" + item.listid + "@#" + item.channel_name + "@#" + item.channel,
                            text: item.itemname + "(" + item.channel_name + ")"
                        });
                    });
                    query.callback(pageData);
                },
                error: function () {
                    var pageData = {
                        results: []
                    };
                    query.callback(pageData);
                }
            });
        }
    });

    $("#chooseRelBuilding").change(function () {
        var chooseHouse = $(this).val();
        if (chooseHouse) {
            var houses = chooseHouse.split("@#");
            $("#projectId").val(houses[1]);
            $("#projectName").val(houses[0] + "(" + houses[2] + ")");
            $("#channel").val(houses[3]);
        }
    });
</script>
</html>
