<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>客户转化分析</title>
</head>
<body>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" name="filterForm" class="form-inline filterForm"
                  action="${ctx}/statistic/customerTransStatistic" method="get">
                &nbsp;&nbsp;&nbsp;&nbsp;
                <select name="dateViewType" id="dateViewType" class="form-inline chosen">
                    <option value="1" <c:if test="${param['dateViewType']==1}">selected="selected"</c:if>>日视图</option>
                    <option value="2" <c:if test="${param['dateViewType']==2}">selected="selected"</c:if>>周视图</option>
                    <option value="3" <c:if test="${param['dateViewType']==3}">selected="selected"</c:if>>月视图</option>
                </select>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <input type="text" name="startTime" id="startTime"
                       value="${startDate}"
                       class="m-wrap small mydate span2 " placeholder="起始时间">到
                <input type="text" name="endTime" id="endTime"
                       value="${endDate}"
                       class="m-wrap small mydate span2 " placeholder="截止时间">

                <div style="margin: 15px 0px;">

                    <select name="department" id="department" class="span10 nochosen  multiselect" multiple="multiple"
                            data-placeholder="请选择部门">
                        <c:forEach items="${departmentList}" var="d">
                            <option value="${d.id}"
                                    <c:if test="${'1' eq d.type}">selected="selected"</c:if>>${d.name}</option>
                        </c:forEach>
                    </select>
                    &nbsp;&nbsp;<a class="btn " onclick="btnSubmit();">按部门分析</a>

                    &nbsp;&nbsp;&nbsp;&nbsp;
                    <select name="user" id="user" class="span10 nochosen  multiselect" multiple="multiple"
                            data-placeholder="请选择职员">
                        <c:forEach items="${userList}" var="u">
                            <option value="${u.id}"
                                    <c:if test="${'1' eq u.weiXinId}">selected="selected"</c:if>>${u.realName}</option>
                        </c:forEach>
                    </select>
                    &nbsp;&nbsp;<a class="btn " onclick="btnUserSubmit();">按职员分析</a>

                    &nbsp;&nbsp;<a class="btn "
                                   onclick="$('#filterForm').attr('action','${ctx}/statistic/customerTransExportExcel');$('#filterForm').submit();$('#filterForm').attr('action','${ctx}/statistic/customerTransStatistic');">Excel下载</a>
                    <input type="hidden" id="departmentIds" name="departmentIds" value="${departmentIds}"/>
                    <input type="hidden" id="departmentNames" name="departmentNames" value="${departmentNames}"/>
                    <input type="hidden" id="userIds" name="userIds" value="${userIds}"/>
                    <input type="hidden" id="userNames" name="userNames" value="${userNames}"/>
                    <input type="hidden" id="statisticType" name="statisticType" value="${statisticType}"/>
                </div>
            </form>
        </div>

        <div class="span10" id="table">
            <table class="table table-bordered table-advance table-hover">
                <tr class="info">
                    <td width="60" style="text-align:center">转化率</td>
                    <td width="60" style="text-align:center">约看</td>
                    <td width="60" style="text-align:center">到访</td>
                    <td width="60" style="text-align:center">认筹</td>
                    <td width="60" style="text-align:center">认购</td>
                    <td width="60" style="text-align:center">签约</td>
                    <td width="60" style="text-align:center">退房</td>
                </tr>
                <c:forEach var="data" items="${tableData}">
                    <tr class="info">
                        <c:forEach var="cell" items="${data}" varStatus="index">
                                <c:if test="${not empty cell}">
                                    <c:if test="${1 eq index.count}">
                                        <td width="60" style="text-align:center;background-color: #c4e3f3">${cell}</td>
                                    </c:if>
                                    <c:if test="${1 lt index.count}">
                                        <td width="60" style="text-align:center;background-color: #ffffff">${cell}</td>
                                    </c:if>
                                </c:if>
                                <c:if test="${empty cell}">
                                </c:if>
                        </c:forEach>
                    </tr>
                </c:forEach>

            </table>
        </div>
    </div>

</div>

<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>

<script type="text/javascript">
    $(document).ready(function () {
        $('#department').multiselect({
            includeSelectAllOption: true,
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 320,
            numberDisplayed: 2,
            filterPlaceholder: '请输入部门名',
            includeSelectAllOption: false,
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择部门 ';
                } else if (options.length > 5) {
                    return options.length + ' 选中 ';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }

            },
            optionLabel: function (element) {
                return $(element).html();
            },
            onInitialized: function (select, container) {
                var selectedOptions = $('#department option:selected');

                if (selectedOptions.length >= 5) {
                    var nonSelectedOptions = $('#department option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#department').siblings('.multiselect-container');
                    nonSelectedOptions.each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                }
                else {
                    var dropdown = $('#department').siblings('.multiselect-container');
                    $('#department option').each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            },
            onChange: function (option, checked) {
                var selectedOptions = $('#department option:selected');
                if (selectedOptions.length >= 5) {
                    var nonSelectedOptions = $('#department option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#department').siblings('.multiselect-container');
                    nonSelectedOptions.each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                } else {
                    var dropdown = $('#department').siblings('.multiselect-container');
                    $('#department option').each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            }
        });

        $('#user').multiselect({
            includeSelectAllOption: true,
            enableFiltering: true,
            maxHeight: 500,
            buttonWidth: 320,
            numberDisplayed: 2,
            filterPlaceholder: '请输入职员名',
            includeSelectAllOption: false,
            templates: {
                filterClearBtn: '<span></span>',
            },
            buttonText: function (options) {
                if (options.length == 0) {
                    return '未选择职员 ';
                } else if (options.length > 5) {
                    return options.length + ' 选中 ';
                } else {
                    var selected = '';
                    options.each(function () {
                        selected += $(this).text() + ', ';
                    });
                    return selected.substr(0, selected.length - 2);
                }
            },
            optionLabel: function (element) {
                return $(element).html();
            },
            onInitialized: function (select, container) {
                var selectedOptions = $('#user option:selected');

                if (selectedOptions.length >= 5) {
                    var nonSelectedOptions = $('#user option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#user').siblings('.multiselect-container');
                    nonSelectedOptions.each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                }
                else {
                    var dropdown = $('#user').siblings('.multiselect-container');
                    $('#user option').each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            },
            onChange: function (option, checked) {
                var selectedOptions = $('#user option:selected');

                if (selectedOptions.length >= 5) {
                    var nonSelectedOptions = $('#user option').filter(function () {
                        return !$(this).is(':selected');
                    });

                    var dropdown = $('#user').siblings('.multiselect-container');
                    nonSelectedOptions.each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', true);
                        input.parent('li').addClass('disabled');
                    });
                } else {
                    var dropdown = $('#user').siblings('.multiselect-container');
                    $('#user option').each(function () {
                        var input = $('input[value="' + $(this).val() + '"]');
                        input.prop('disabled', false);
                        input.parent('li').addClass('disabled');
                    });
                }
            }
        });

        var startTime = $("#startTime");
        var endTime = $("#endTime");
        endTime.bind("focus", function () {
            WdatePicker({startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d-1}'});
        });
        startTime.bind("focus", function () {
            WdatePicker({
                startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d-1}',
                onpicked: function () {
                    WdatePicker({
                        /* doubleCalendar: true, */
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        maxDate: '%y-%M-{%d-1}',
                        el: 'endTime'
                    })
                }
            });
        });

        <c:if test="${'1' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-{%d-1}'});
        });
        </c:if>
        <c:if test="${'2' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({isShowWeek: true, maxDate: '%y-%M-{%d-1}'});
        });
        </c:if>
        <c:if test="${'3' eq param['dateViewType']}">
        $(".mydate").unbind("focus");
        $(".mydate").bind("focus", function () {
            WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-{%d-1}'});
        });
        </c:if>

        $("#dateViewType").change(function () {
            var val = $(this).val();
            $(".mydate").val("");
            if (val == 1) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-{%d-1}'});
                });
            } else if (val == 2) {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({isShowWeek: true, maxDate: '%y-%M-{%d-1}'});
                });
            } else {
                $(".mydate").unbind("focus");
                $(".mydate").bind("focus", function () {
                    WdatePicker({dateFmt: 'yyyy-MM', maxDate: '%y-%M-{%d-1}'});
                });
            }
            setTime();
        });

        setTime();

    });


    function exportExcel() {
        document.filterForm.action = "${ctx}/statistic/projectSourceExcel";
        filterForm.submit();
        document.filterForm.action = "${ctx}/statistic/projectSource";
    }

    function btnUserSubmit() {
        var tmp = ",";
        var tmpName = ",";
        $("#user").find("option:selected").each(function () {
            tmp = tmp + $(this).val() + ",";
            tmpName = tmpName + $(this).text() + ",";
        });
        if (tmp == ",") {
            House365Util.createModal("请选择", "请选择职员", function () {
            });
            return;
        }

        $("#statisticType").val("2");
        $("#userIds").val(tmp);
        $("#userNames").val(tmpName);
        $('#filterForm').submit();
    }

    function btnSubmit() {
        var tmp = ",";
        var tmpName = ",";
        $("#department").find("option:selected").each(function () {
            tmp = tmp + $(this).val() + ",";
            tmpName = tmpName + $(this).text() + ",";
        });
        if (tmp == ",") {
            House365Util.createModal("请选择", "请选择部门", function () {
            });
            return;
        }

        $("#departmentNames").val(tmpName);
        $("#statisticType").val("1");
        $("#departmentIds").val(tmp);
        $('#filterForm').submit();
    }

    function dispayFun(obj) {
        if (obj == 1) {
            $("#report").show();
            $("#table").hide();
            $("#reportLi").addClass("active");
            $("#tableLi").removeClass("active");
        } else {
            $("#table").show();
            $("#report").hide();
            $("#tableLi").addClass("active");
            $("#reportLi").removeClass("active");
        }
    }
</script>
</body>
</html>
