<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>回访跟进统计</title>
</head>
<body>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>统计与分析
                <span class="divider" style="color:#26a0da;font-weight:bold;"> / </span>回访跟进统计
            </li>
        </ul>
    </div>
</div>


<div class="page-container">
    <div class="row${fluid}">
        <c:choose>
            <c:when test="${departments!= null && fn:length(departments) == 0}">
                <div style="width: 90%;height: 40%;text-align: center;font-size: larger;margin-top: 30px;">名下暂无置业顾问数据
                </div>
            </c:when>
            <c:otherwise>
                <form id="filterForm" name="filterForm" class="form-inline filterForm"
                      action="${ctx}/statistic/callBackTraceStatistic" method="get">
                    <div class="row-fluid">
                        <ul class="nav nav-tabs" style="margin-bottom: 0;position: relative;">
                            <c:forEach items="${departments}" var="dept">
                                <li <c:if test="${dept.id == deptId}">class="active"</c:if>>
                                    <c:choose>
                                        <c:when test="${dept.id == deptId}">
                                            <a href="#">${dept.name}</a>
                                        </c:when>
                                        <c:when test="${dept.id != deptId}">
                                            <a href="${ctx}/statistic/callBackTraceStatistic?deptId=${dept.id}&pageSize=${param['pageSize']}">${dept.name}</a>
                                        </c:when>
                                        <c:otherwise>

                                        </c:otherwise>
                                    </c:choose>
                                </li>
                            </c:forEach>
                        </ul>
                    </div>
                    <div style="margin-top:10px;">
                        &nbsp;&nbsp;数据日期：&nbsp;&nbsp;
                        <input type="text" name="startTime" id="startTime" value="${startTime}"
                               style="width: 120px;" class="m-wrap small mydate span2" placeholder="起始时间">到
                        <input type="text" name="endTime" id="endTime" value="${endTime}"
                               style="width: 120px;" class="m-wrap small mydate span2" placeholder="截止时间">
                        &nbsp;&nbsp;

                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <input type="text" placeholder="搜索置业顾问" name="search_LIKE_realName"
                               value="${param['search_LIKE_realName']}">
                        <div class="inputSearch__btn" onclick="$('#filterForm').submit();"
                             style="display: inline-block; position: relative; top: 9px;left: 5px;"
                        ></div>
                    </div>

                    <input type="hidden" name="deptId" id="deptId" value="${deptId}">
                    <input type="hidden" name="pageSize" id="pageSize" value="${param['pageSize']}">
                </form>
                <c:choose>
                    <c:when test="${list!= null && fn:length(list) == 0}">
                        <div style="width: 90%;height: 40%;text-align: center;font-size: larger;margin-top: 30px;">
                            暂无置业顾问数据
                        </div>
                    </c:when>
                    <c:otherwise>
                        <table class="table table-advance table-hover">
                            <tbody>
                            <c:forEach items="${list}" var="user" varStatus="n">
                                <c:choose>
                                    <c:when test="${n.index % 2!=0 && user.star=='off'}">
                                        <c:set var="bgc" value="style='background-color:#ddd;'"/>
                                    </c:when>
                                    <c:when test="${user.star=='on'}">
                                        <c:set var="bgc" value="style='background-color: #FFEB3B;'"/>
                                    </c:when>
                                    <c:otherwise>
                                        <c:set var="bgc" value=""/>
                                    </c:otherwise>
                                </c:choose>

                                <tr class="header expand" ${bgc}>

                                    <td class="mangerId mangerItem" style="width: 130px;">
                                        <div class="mangerItem__border"></div>
                                        <span class="mangerId_num">${user.managerId}</span>
                                    </td>
                                    <td class="mangerName mangerItem" style="width: 130px;">
                                        <div class="mangerItem__border"></div>
                                            ${user.managerName}
                                    </td>
                                    <td class="mangerItem doub" style="width: 130px;">
                                        <div class="mangerItem__border"></div>
                                        <div class="mangerItem__up">${user.total}</div>
                                        <div class="mangerItem__down">累计客户</div>
                                    </td>
                                    <td class="mangerItem doub" style="width: 130px;">
                                        <div class="mangerItem__border"></div>
                                        <div class="mangerItem__up">${user.waitCount}</div>
                                        <div class="mangerItem__down">待回访客户</div>
                                    </td>
                                    <td class="mangerItem doub" style="width: 130px;">
                                        <div class="mangerItem__border"></div>
                                        <div class="mangerItem__up">${user.callCount}</div>
                                        <div class="mangerItem__down">回访客户</div>
                                    </td>
                                    <td class="mangerItem doub" style="width: 130px;">
                                        <div class="mangerItem__border"></div>
                                        <div class="mangerItem__up">${user.cloudSent}</div>
                                        <div class="mangerItem__down">云迹派工数</div>
                                    </td>
                                    <td class="mangerItem doub" style="width: 130px;">
                                        <div class="mangerItem__border"></div>
                                        <div class="mangerItem__up">${user.cloudWait}</div>
                                        <div class="mangerItem__down">云迹数据待回访数</div>
                                    </td>
                                    <td class="mangerItem mangerCollect ${user.star}"
                                        onclick="toggleCollect(this,'${user.managerId}')">
                                        <div class="mangerItem__border"></div>
                                    </td>
                                    <c:if test="${isDirector eq 1}">
                                        <td class="mangerItem">
                                            <a href="#">
                                                <div class="mangerItem__detail"
                                                     onclick="clearCustomerByManagerId('${user.managerId}', '${user.managerName}' ,${user.isClear})">
                                                    清空客户
                                                </div>
                                            </a>
                                        </td>
                                    </c:if>

                                    <td class="mangerItem">
                                        <a href="#">
                                            <div class="mangerItem__detail"
                                                 onclick="window.open('${ctx}/customermanagement/myCustomerNew?managerId=${user.managerId}');">
                                                查看详情
                                            </div>
                                        </a>
                                    </td>
                                </tr>
                            </c:forEach>
                            </tbody>
                        </table>
                        <div class="row${fluid}">
                            <house365:newPagination page="${page}"/>
                        </div>
                    </c:otherwise>
                </c:choose>
            </c:otherwise>
        </c:choose>
    </div>
</div>

<input type="hidden" value="${queryUser}" name="queryUser" id="queryUser">

<link rel="stylesheet" href="${static_common }/script/bootstrap/css/bootstrap-multiselect.css" type="text/css">
<script type="text/javascript" src="${static_common }/script/bootstrap/js/bootstrap-multiselect.js"></script>
<script src="${ctx}/resources/script/echarts/echarts.min.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>

<script type="text/javascript">

    <%--$(document).ready(function () {--%>
    <%--    var timeStart = "${startTime}";--%>
    <%--    var timeEnd = "${endTime}";--%>
    <%--    if (timeEnd == '' && timeStart == '') {--%>
    <%--        $(".mydate").unbind("focus");--%>
    <%--        $(".mydate").bind("focus", function () {--%>
    <%--            WdatePicker({dateFmt: 'yyyy-MM-dd', maxDate: '%y-%M-{%d}'});--%>
    <%--        });--%>
    <%--        setTime();--%>
    <%--    } else {--%>
    <%--        $("#startTime").val(timeStart);--%>
    <%--        $("#endTime").val(timeEnd);--%>
    <%--    }--%>
    <%--});--%>

    $(document).ready(function () {
        var startTime = $("#startTime");
        var endTime = $("#endTime");
        endTime.bind("focus", function () {
            WdatePicker({startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d}'});
        });
        startTime.bind("focus", function () {
            WdatePicker({
                startDate: "%y-{%M}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: false, maxDate: '%y-%M-{%d}',
                onpicked: function () {
                    WdatePicker({
                        /* doubleCalendar: true, */
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        maxDate: '%y-%M-{%d}',
                        el: 'endTime'
                    })
                }
            });
        });
        setTime();
    });

    function btnSubmit() {
        $('#filterForm').submit();
    }

    function setTime() {
        var startTime = $("#startTime");
        var endTime = $("#endTime");
        if (startTime.val() == '') {
            startTime.val(getToday());
        }
        if (endTime.val() == '') {
            endTime.val(getToday());
        }
    }

    $(document).keydown(function (event) {
        if (event.keyCode == "13") {
            //回车执行查询
            $('#filterForm').submit();
        }
    })

    var clearCustomerByManagerId = function (managerId, managerName, isClear) {
        if(isClear == 0){
            alert("名下暂无客户");
            return false;
        }else{
            House365Util.createModal("清空客户", "确认后所有客户将被移入公海,请谨慎操作！", function () {
                $.ajax({
                    url: '${ctx}/manager/clearCustomerByManagerId',
                    data: {"managerId": managerId, "managerName": managerName},
                    success: function (data) {
                        if (data.flag == '1') {
                            window.location.reload();
                        } else {
                            alert("清空失败，");
                        }
                        window.location.reload();
                    }
                });
            });
        }
    };

    function toggleCollect(_this, starUserId) {
        //收藏
        var flag = "off";
        if ($(_this).hasClass('on')) {
            $(_this).removeClass('on');
            $(_this).closest("tr").css("background-color", "#fff");
        } else {
            flag = "on";
            $(_this).addClass('on');
            $(_this).closest("tr").css("background-color", "#FFEB3B");
        }
        $.ajax({
            url: "${ctx}/manager/starToggle",
            data: {flag: flag, 'starUserId': starUserId},
            success: function (data) {

            }
        });
    }

</script>
</body>
</html>
