<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<form id="input_form" class="form-horizontal valid" action="${ctx}/role/updateInfo/${entity.id}" method="post">
    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/">首页</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    新增
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <input id="accid" type="hidden" name="entity.accId" value="${entity.accId}">
    <div class="row${fluid}">
        <div class="span10 offset1">
            <shiro:hasPermission name="USER_EDIT">
                <div class="portlet-header">
                    <div class="operation-btn pull-right">
                        <c:choose>
                            <c:when test="${action=='edit'}">
                                <button class="btn blue" type="submit"><i
                                        class="icon-save"></i>&nbsp;保存
                                </button>
                                <a href="${ctx}/user/${entity.id}" class="btn gray"><i
                                        class="icon-mail-reply"></i>&nbsp;取消</a>
                            </c:when>
                            <c:when test="${action=='create'}">
                                <button class="btn blue"><i class="icon-save"></i>&nbsp;保存</button>
                                <a href="${ctx}/user/?search_EQ_deptId=${sessionTreeDept}" class="btn gray"><i
                                        class="icon-mail-reply"></i>&nbsp;返回</a>
                            </c:when>
                            <c:otherwise>
                                <a href="${ctx}/user/${entity.id}?action=edit" class="btn blue"><i
                                        class="icon-edit"></i>&nbsp;编辑</a>
                                <a href="${ctx}/user/?search_EQ_deptId=${sessionTreeDept}" class="btn gray"><i
                                        class="icon-mail-reply"></i>&nbsp;返回</a>
                            </c:otherwise>
                        </c:choose>
                    </div>
                </div>
            </shiro:hasPermission>
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        编辑
                    </div>

                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <%--<label class="control-label">${entity.headImgURL}</label>--%>
                            <label class="control-label">个人头像:</label>
                            <div class="controls">
                                <input id="headImgURL" type="hidden" name="entity.headImgURL"
                                       value="${entity.headImgURL}">
                                <tags:imageSection resourceId="${entity.id}"
                                                   resourceType="hgs_user_headImg"
                                                   bizType="1" editAble="true" title="个人头像" maxSize="1"/>
                                <span class="f12 col_7f pl10">图片建议尺寸：300*300</span>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">全身照:</label>
                            <div class="controls">
                                <input id="fullImgURL" type="hidden" name="entity.fullImgURL"
                                       value="${entity.fullImgURL}">
                                <tags:imageSection resourceId="${entity.id}"
                                                   resourceType="hgs_user_fullImg"
                                                   bizType="2" editAble="true" title="全身照" maxSize="1"/>
                                <span class="f12 col_7f pl10">图片建议尺寸：172*230</span>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">微信:</label>
                            <div class="controls">
                                <input id="wxCodeImgUrl" type="hidden" name="entity.wxCodeImgUrl"
                                       value="${entity.wxCodeImgUrl}">
                                <tags:imageSection resourceId="${entity.id}"
                                                   resourceType="wx_code_imgUrl"
                                                   bizType="3" editAble="true" title="微信二维码" maxSize="1"/>
                                <span class="f12 col_7f pl10">图片建议尺寸：172*230</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span12 control-group">
                            <label class="control-label">微信号:</label>
                            <div class="controls">
                                <input type="text" id="wxNumber" name="entity.wxNumber" maxlength="20"
                                       value="${entity.wxNumber}"/>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
            <div class="portlet-header">
                <div class="operation-btn">
                    <input class="btn blue" type="button" onclick="commitForm()" value="保存">
                </div>
            </div>
        </div>

    </div>

</form>

<script>

    function commitForm() {
        var phone = $("#entity_mobile").val();
        var name = $("#entity_realName").val();
        var position = $("#entity_position").val();
        var description = $("#entity_description").val();
        var defaultVisit = $("#entity_defaultVisit").val();
        var wxNumber = $("#wxNumber").val();
        var wxCodeImgUrl = $("#wxCodeImgUrl").val();
        if (description.length > 200) {
            House365Util.createModal("提示", "个人介绍不能超过200个字", function () {
                $("#entity_description").focus();
            });
            return false;
        }

        if (phone != "" && !checkMobile(phone)) {
            House365Util.createModal("提示", "号码格式不正确", function () {
                $("#entity_mobile").focus();
            });
            return false;
        }
        if (description.length > 200) {
            House365Util.createModal("提示", "个人介绍不能超过200个字", function () {
                $("#entity_description").focus();
            });
            return false;
        }

        if(defaultVisit!=""&&!checkDefaultVisit(defaultVisit)){
            House365Util.createModal("提示", "请填入小于等于50的正整数", function () {
                $("#entity_defaultVisit").focus();
            });
            return false;
        }
        if(wxNumber == null || wxNumber == ''){
            alert("请填写微信号");
            return false;
        }
        $("#input_form").submit();
    }

</script>

</body>

</html>
