<%@ page language="java" pageEncoding="UTF-8" %>
<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<html>
<head>
    <title>添加项目图片</title>
    <style>
        .cancelImg {
            cursor: pointer;
        }
    </style>
</head>
<body>
<form id="addAttachForm" method="post" action="${ctx}/project/addAttach" enctype="multipart/form-data">
    <input type="hidden" name="projectId" value="${projectId}">
    <p>
        图片名称：
        <input id="remark" name="remark"/>
    </p>
    <div class="uploadFile">
        <input type="file" name="file" multiple/>
        <span class="upload-box"></span>
        <span class="cancelImg">取消</span>
    </div>

</form>


<script>
    $(".uploadFile span").on("click", function () {
        cancelImg(this);
    });

    function cancelImg(_this) {
        $(_this).parent().children("input").val("");
        $(_this).parent().children(".upload-box").html("");
    }


    $(".uploadFile input").on("change", function (e) {
        var file = e.target.files,   // 获取本地文件File对象集合
            typelist = ["image/jpeg", "image/png", "image/gif", "image/jpg"],  // 合法文件type列表
            filetype, // 当前文件的类型
            isPic;  // 文件类型是否合法标识
        if (file == null) {
            alert("请上传图片");
        } else {
            if (file.length > 10) {
                alert("一次最多上传10张图片");
                return;
            }
            for (var i = 0; i < file.length; i++) {
                var a = file[i];
                if (a.size > 2097152) {
                    alert("图片不能大于2M");
                    cancelImg(this);
                    return;
                }
                console.log(a);
                filetype = a.type;
                //判断filetype是否属于图片
                isPic = typelist.some(function (item) {
                    return item == filetype;
                });
                if (isPic) {
//                    addImage(file);   //同时添加到页面
                } else {
                    // 提示文件非图片
                    alert("不支持的文件类型");
                    return;
                }
            }
            addImage(file);
        }

    });

    //    $(".uploadFile input").on("change", function (e) {
    //        debugger;
    //        var file = e.target.files[0],   // 获取本地文件File对象集合
    //            typelist = ["image/jpeg", "image/png", "image/gif", "image/jpg"],  // 合法文件type列表
    //            filetype, // 当前文件的类型
    //            isPic;  // 文件类型是否合法标识
    //        if (file.size > 2097152) {
    //            alert("图片不能大于2M");
    //            cancelImg(this);
    //            return false;
    //        }
    //        filetype = file.type;
    //        //判断filetype是否属于图片
    //        isPic = typelist.some(function (item) {
    //            return item == filetype;
    //        });
    //        if (isPic) {
    //            addImage(file);   //同时添加到页面
    //        } else {
    //            // 提示文件非图片
    //            // AnimateUtils.info('不支持的文件类型');
    //        }
    //    });


    //    将图片加载至浏览器中,并且显示出来
    function addImage(file) {
        function createObjectURL(blob) {
            if (window.URL) {
                return window.URL.createObjectURL(blob);
            } else if (window.webkitURL) {
                return window.webkitURL.createObjectURL(blob);
            }
            return null;
        }

        function revokeObjectURL(url) {
            if (window.URL) {
                return window.URL.revokeObjectURL(blob);
            } else if (window.webkitURL) {
                return window.webkitURL.revokeObjectURL(blob);
            }
        }

        if (file != null) {
            var a = '';
            for (var i = 0; i < file.length; i++) {
                a += '<img style="width:100px;height:100px; padding:.2rem;" src="' + createObjectURL(file[i]) + '" alt="' + file[i].name + '" />'
            }
        }
        $(".upload-box").wrapInner(a).insertBefore('.add-button');

//        $(".upload-box").wrapInner('<img style="width:100px;height:100px; padding:.2rem;" src="' + createObjectURL(file) + '" alt="' + file.name + '" />').insertBefore('.add-button');
    }


</script>
</body>
</html>
