<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>营销活动-step2</title>
</head>
<body>
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>

<form id="input_form" class="form-horizontal valid" action="${ctx}/marketingactivity/step2" method="post">
    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/marketingactivity">营销活动列表</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="form-horizontal house365Page">

                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <h5>输入数据提取条件</h5>
                    </div>
                    <div class="alert">
                        <strong>注意：</strong>
                        <p>报名时间是报名条件组合中的必填项，若不选择报名时间，整个报名条件均不会生效；</p>
                        <p>浏览项目和浏览时间是浏览轨迹条件的必选项，若不选择，整个浏览轨迹条件不会生效；</p>
                        <p>同时填写“报名条件”和“浏览轨迹条件”时，将取两者数据交集。</p>
                    </div>
                    <input id="activeId" name="entity.id" type="hidden" value="${entity.id}"/>
                    <input name="entity.name" type="hidden" value="${entity.name}"/>
                    <input name="entity.type" type="hidden" value="${entity.type}"/>
                    <input name="entity.status" type="hidden" value="${entity.status}"/>
                    <input name="entity.projectName" type="hidden" value="${entity.projectName}"/>
                    <input name="entity.createName" type="hidden" value="${entity.createName}"/>
                    <input name="entity.createBy" type="hidden" value="${entity.createBy}"/>
                    <input type="hidden" id="entity.createTimeStr"
                           name="entity.createTimeStr"
                           value="<fmt:formatDate value='${entity.createTime}' pattern='yyyy-MM-dd HH:mm:ss' />"/>
                    <input type="hidden" id="finishTime" name="entity.finishTimeStr"
                           value="<fmt:formatDate value='${entity.finishTime}' pattern='yyyy-MM-dd HH:mm:ss' />"/>

                    <input id="cycle" name="entity.cycle" type="hidden" value="${entity.cycle}"/>
                    <input id="expectExtractCount" name="entity.expectExtractCount" type="hidden"
                           value="${entity.expectExtractCount}"/>
                </div>

                <div class="house365Border">
                    <div class="sectionTitle">
                        <h5>项目条件</h5>
                    </div>
                    <div class="row-fluid">
                        <div class="span4 control-group">
                            <label class="control-label">报名来源:</label>
                            <div class="controls">
                                <input type="text" id="applySourceName" value="${entity.applySourceName}"
                                       name="entity.applySourceName" class="form-control span12"
                                       onclick="chooseSource()">
                                <input type="hidden" id="applySource" name="entity.applySource">
                                <p>
                                    <input type="checkbox" value="2,3,29,30,31" name="quickSource"
                                           onchange="disableInput()">来源（电商、房博士、400电话、楼盘订阅、看房团）
                                </p>
                            </div>
                        </div>
                        <div class="span2 control-group">
                            <label class="control-label">活动名称：</label>
                            <div class="controls">
                                <select id="activeType" name="entity.activeType">
                                    <option value="">--请选择--</option>
                                    <c:forEach items="${fns:getDictList('crm_activity_type')}" var="dict">
                                        <option value="${dict.dicValue}">${dict.dicName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <div style="margin-left:200px;">
                                <input maxlength="100" type="text" id="actName" value="${entity.actName}"
                                       name="entity.actName" class="span9 form-control">
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span4 control-group">
                            <label class="control-label"><span style="color: red">*</span>报名时间:</label>
                            <div class="controls">
                                <input type="hidden" id="applyStartTime" name="entity.applyStartTimeStr"/>
                                <input type="hidden" id="applyEndTime" name="entity.applyEndTimeStr"/>
                                <input type="text" id="signTime" name="signTime" class="form-control span12">
                                <a href="javascript:void(0)" class="btn blue" onclick="cleanSignTime()">
                                    清空
                                </a>
                            </div>
                            <div style="margin-left: 180px;">报名时间与访问时间至少选一个</div>
                        </div>
                        <div class="span2 control-group">
                            <label class="control-label">会员电话：</label>
                            <div class="controls">
                                <select id="mobileType" name="entity.mobileType">
                                    <option value="">--请选择--</option>
                                    <c:forEach items="${fns:getDictList('crm_phone_type')}" var="dict">
                                        <option value="${dict.dicValue}"
                                                <c:if test="${entity.mobileType eq dict.dicValue}">selected="selected"</c:if>>${dict.dicName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <div style="margin-left:200px;">
                                <input maxlength="50" type="text" id="mobile" value="${entity.mobile}"
                                       name="entity.mobile" class="form-control span9">
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">项目名称:</label>
                            <div class="controls">
                                <%--<input type="hidden" id="buildingId" name="buildingId"--%>
                                <%--value="${buildingId}"/>--%>
                                <%--<input type="text" id="buildingName" name="buildingName" class=" span12"--%>
                                <%--onclick="assignBuilding(500)"--%>
                                <%--value="${buildingName}"/>--%>
                                <input type="hidden" id="buildingId" name="buildingId"/>
                                <input type="text" id="buildingName" name="buildingName" class=" span12"
                                       onclick="assignBuilding(500)"/>
                                <span color="red"><form:errors path="projectVo.entity.buildingName"/></span>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="house365Border">
                    <div class="sectionTitle">
                        <h5>意向条件</h5>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">总价范围:</label>
                            <div class="controls">
                                <input type="text" id="totalPriceLower" name="entity.totalPriceLower"
                                       class="span3 number digits">
                                <input type="text" id="totalPriceHigher" name="entity.totalPriceHigher"
                                       class="span3 number digits ">(万元)
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">面积范围：</label>
                            <div class="controls">
                                <input type="text" id="areaLower" name="entity.areaLower"
                                       class="span3 number digits ">
                                <input type="text" id="areaHigher" name="entity.areaHigher"
                                       class="span3 number digits ">(㎡)
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">板块:</label>
                            <div class="controls">
                                <input name="entity.blockName" id="blockName" type="hidden" value="${entity.block}"/>
                                <select id="block" name="entity.block" class="selectpicker show-tick form-control"
                                        multiple data-live-search="false">
                                    <%--<option value="">--请选择--</option>--%>
                                    <c:forEach items="${blocks}" var="block">
                                        <option value="${block.dicValue}">${block.dicName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">区域：</label>
                            <div class="controls">
                                <input name="entity.districtName" id="districtName" type="hidden"
                                       value="${entity.district}"/>
                                <select id="district" name="entity.district" class="selectpicker show-tick form-control"
                                        multiple data-live-search="false">
                                    <%--<option value="">--请选择--</option>--%>
                                    <c:forEach items="${districts}" var="district">
                                        <option value="${district.dicValue}">${district.dicName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">物业类型:</label>
                            <div class="controls">
                                <input name="entity.channelName" id="channelName" type="hidden"
                                       value="${entity.channel}"/>
                                <select id="channel" name="entity.channel" onchange="setchannel()">
                                    <option value="">--请选择--</option>
                                    <c:forEach items="${fns:getDictList('crm_property_type')}" var="dict">
                                        <option value="${dict.dicValue}">${dict.dicName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="house365Border">
                    <div class="sectionTitle">
                        <h5>回访条件</h5>
                    </div>
                    <div class="row-fluid">
                        <div class="span10 control-group">
                            <label class="control-label">回访时间:</label>
                            <div class="controls">
                                <input type="hidden" id="returnVisitTimeStart" name="entity.returnVisitTimeStart"
                                       class="form-control">
                                <input type="hidden" id="returnVisitTimeEnd" name="entity.returnVisitTimeEnd"
                                       class="form-control">
                                <input type="text" id="callbackTime" name="callbackTime" class="form-control span6">
                                <a href="javascript:void(0)" class="btn blue" onclick="cleanTime()">
                                    清空
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span6 control-group">
                            <label class="control-label">回访状态:</label>
                            <div class="controls">
                                <select id="returnVisitStatus" name="entity.returnVisitStatus">
                                    <option value="">--请选择--</option>
                                    <c:forEach items="${fns:getDictList('crm_visit_status')}" var="dict">
                                        <option value="${dict.dicValue}">${dict.dicName}</option>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                        <div class="span6 control-group">
                            <label class="control-label">回访结果：</label>
                            <div class="controls">
                                <input name="entity.returnVisitResultName" id="returnVisitResultName" type="hidden"
                                       value="${entity.returnVisitResult}"/>
                                <select id="returnVisitResult" name="entity.returnVisitResult"
                                        class="selectpicker show-tick form-control" multiple data-live-search="false">
                                    <%--<option value="">--请选择--</option>--%>
                                    <c:forEach items="${fns:getDictList('crm_visit_result')}" var="dict">
                                        <c:if test="${dict.dicValue <= 5}">
                                            <option value="${dict.dicValue}">${dict.dicName}</option>
                                        </c:if>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span1 control-group"></div>
                        <div class="span6 control-group" style="margin-left: 50%;margin-top: 10px;">
                            <a href="javascript:void(0)" class="btn blue" onclick="checkForm()">
                                <i class="icon-save"></i>&nbsp;下一步
                            </a>
                            <%--<a href="${ctx}/marketingactivity/step1/${entity.id}?action=edit" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>--%>
                        </div>
                    </div>

                </div>

                <%--<div class="house365Border">--%>
                    <%--<div class="sectionTitle">--%>
                        <%--<h5>浏览轨迹条件</h5>--%>
                    <%--</div>--%>
                    <%--<div class="row-fluid">--%>
                        <%--<div class="span6 control-group">--%>
                            <%--<label class="control-label">浏览项目:</label>--%>
                            <%--<div class="controls">--%>
                                <%--<input type="hidden" id="projectId" name="projectId"/>--%>
                                <%--<input type="text" id="projectName" name="projectName" class=" span12"--%>
                                       <%--onclick="assignProject(500)"/>--%>
                            <%--</div>--%>
                        <%--</div>--%>
                        <%--<div class="span4 control-group">--%>
                            <%--<label class="control-label">访问时间:</label>--%>
                            <%--<div class="controls">--%>
                                <%--<input type="hidden" id="seeStartTime" name="seeStartTime"/>--%>
                                <%--<input type="hidden" id="seeEndTime" name="seeEndTime"/>--%>
                                <%--<input type="text" id="signTimeNew" name="signTimeNew" class="form-control span12">--%>
                                <%--<a href="javascript:void(0)" class="btn blue" onclick="cleanVisitTime()">--%>
                                    <%--清空--%>
                                <%--</a>--%>
                            <%--</div>--%>
                            <%--<div style="margin-left: 180px;">报名时间与访问时间至少选一个。由于CRM限制，访问时间暂时仅限近10天</div>--%>
                        <%--</div>--%>
                    <%--</div>--%>

                    <%--<div class="row-fluid">--%>
                        <%--<label class="control-label">浏览次数:</label>--%>
                        <%--<div class="controls">--%>
                            <%--<select id="seeCount" name="seeCount">--%>
                                <%--<option value="0" selected>--请选择--</option>--%>
                                <%--<option value="5">>5</option>--%>
                                <%--<option value="10">>10</option>--%>
                                <%--<option value="20">>20</option>--%>
                                <%--<option value="30">>30</option>--%>
                            <%--</select>--%>
                        <%--</div>--%>
                    <%--</div>--%>

                    <%--<div class="row-fluid">--%>
                        <%--<div class="span1 control-group">--%>
                        <%--</div>--%>
                        <%--<div class="span6 control-group" style="margin-left: 50%;margin-top: 10px;">--%>
                            <%--<a href="javascript:void(0)" class="btn blue" onclick="checkForm()">--%>
                                <%--<i class="icon-save"></i>&nbsp;下一步--%>
                            <%--</a>--%>
                        <%--</div>--%>
                    <%--</div>--%>

                <%--</div>--%>

            </div>
        </div>
    </div>

</form>

<div id="confirmDialog" style="display: none" title="">

</div>

<div id="loadingDialog" style="display: none;">
    <div class="progress" id="prog_out">
        <div class="bar" style="width: 0%;" id="prog_in"></div>
    </div>
    已导入<span id="complete">0</span>条
</div>

<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
<script src="${static_common }/script/jquery/bootstrap-select.min.js" type="text/javascript"></script>
<link rel="stylesheet"
      href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.10.0/css/bootstrap-select.min.css">
<script href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.10.0/js/i18n/defaults-*.min.js"></script>
<script type="text/javascript">


    var $form = $("#input_form");

    function disableInput() {
        var checked = $('[name="quickSource"]:checked').length;
        if (checked > 0) {
            $("#applySourceName").val("");
            $("#applySource").val("");
            $("#applySourceName").prop('disabled', true);
        } else {
            $("#applySourceName").prop('disabled', false);
        }
    }

    function setblock() {
        var name = $("#block").find("option:selected").text();
        $("#blockName").val(name);
    }

    function setdistrict() {
        var name = $("#district").find("option:selected").text();
        $("#districtName").val(name);
    }

    function setReturnVisitResult() {
        var name = $("#returnVisitResult").find("option:selected").text();
        $("#returnVisitResultName").val(name);
    }

    function setchannel() {
        var name = $("#channel").find("option:selected").text();
        $("#channelName").val(name);
    }

    function cleanTime() {
        $("#callbackTime").val("");
        $("#returnVisitTimeStart").val("");
        $("#returnVisitTimeEnd").val("");
        return false;
    }
    function cleanSignTime() {
        $("#signTime").val("");
        $("#applyStartTime").val("");
        $("#applyEndTime").val("");
        return false;
    }
    function cleanVisitTime() {
        $("#signTimeNew").val("");
        $("#seeStartTime").val("");
        $("#seeEndTime").val("");
        return false;
    }

    function chooseSource() {
        House365Util.createRemoteModal("选择来源", "/house365-hgs-web/basetree/modalTree?choseIds=" + $("#applySource").val() + "&sourceSel=" + $("#applySourceName").val(), null, function () {
            $("#applySource").val($("#choseIds").val());
            $("#applySourceName").val($("#sourceSel").val());
        });
    }

    function doImport() {

        $("#loadingDialog").dialog({
            dialogClass: "no-close",
            autoOpen: false,
            width: 1000,
            modal: true,
            show: {
                effect: "blind",
                duration: 100
            },
            hide: {
                effect: "explode",
                duration: 100
            }
        }).dialog("open");
        // $(".ui-dialog-titlebar").hide();

        var sitv = setInterval(function () {
            var prog_url = "${ctx}/marketingactivity/getLoad/" + $("#activeId").val() + "/" + $("#expectExtractCount").val();
            $.getJSON(prog_url, function (res) {
                $('#prog_in').width(res.entity + '%'); //改变进度条进度，注意这里是内层的div，res是后台返回的进度
                $('#complete').text(res.total);
                if (res.entity == 100) {
                    $("#loadingDialog").dialog("close");
                    clearInterval(sitv);
                    $("#ui-id-1").text("加入成功");
                    $("#confirmDialog").text(res.total + "组数据已进入待派列表，其中" + res.paraMap.protectCount + "条数据处于保护未显示");
                    $("#confirmDialog").dialog({
                        dialogClass: "no-close",
                        autoOpen: false,
                        modal: true,
                        show: {
                            effect: "blind",
                            duration: 100
                        },
                        hide: {
                            effect: "explode",
                            duration: 100
                        },
                        buttons: [
                            {
                                text: "确认",
                                click: function () {
                                    $(this).dialog("close");
                                    window.location.href = "${ctx}/marketcustomer?search_EQ_activeId=" + $("#activeId").val();
                                    return true;
                                }
                            }
                        ]
                    }).dialog("open");
                    // $(".ui-dialog-titlebar").hide();
                }
            });
        }, 900);

        $.ajax({
            url: "${ctx}/marketingactivity/import",
            type: "POST",
            async: true,
            data: $form.serialize(),
            success: function (response) {
            }
        });

    }

    function assignBuilding(maxCount) {
        House365Util.createRemoteModal("选择楼盘", "${ctx}/customer/assignBuilding?maxCount=" + maxCount
            + "&departmentNames=" + $("#buildingName").val() + "&departmentIds=" + $("#buildingId").val(), null, function () {
            var buildIds = "", buildNames = "";
            $("[name='buildId']").each(function () {
                buildIds = buildIds + $(this).val() + ",";
            });

            $("[name='buildName']").each(function () {
                buildNames = buildNames + $(this).val() + ",";
            });

            $("#buildingId").val(buildIds);
            $("#buildingName").val(buildNames);
            return true;
        });
    }

    function assignProject(maxCount) {
        House365Util.createRemoteModal("选择楼盘", "${ctx}/customer/assignBuildingNew?maxCount=" + maxCount
            + "&departmentNames=" + $("#projectName").val() + "&departmentIds=" + $("#projectId").val(), null, function () {
            var projectIds = "", projectNames = "";
            $("[name='prtId']").each(function () {
                projectIds = projectIds + $(this).val() + ",";
            });

            $("[name='prtName']").each(function () {
                projectNames = projectNames + $(this).val() + ",";
            });

            $("#projectId").val(projectIds);
            $("#projectName").val(projectNames);
            return true;
        });
    }

    function checkForm() {
        var applyStartTime = $("#applyStartTime").val();
        var applyEndTime = $("#applyEndTime").val();
//        var seeStartTime = $("#seeStartTime").val();
//        var seeEndTime = $("#seeEndTime").val();
//        var seeCount = $("#seeCount").val();
        if (applyStartTime == '' ) {
            alert("报名时间不能为空");
            return;
        }
//        if (seeStartTime != '') {
//            var projectId = $('#projectId').val();
//            if (projectId == null || projectId == '') {
//                alert("请填写浏览项目");
//                return;
//            }
//            var date = new Date(new Date().getTime() - (1000 * 60 * 60 * 24 * 30));
//            var seperator = "-";
//            var year = date.getFullYear();
//            var month = date.getMonth() + 1;
//            var strDate = date.getDate();
//            if (month >= 1 && month <= 9) {
//                month = "0" + month;
//            }
//            if (strDate >= 0 && strDate <= 9) {
//                strDate = "0" + strDate;
//            }
//            var dateNew = year + seperator + month + seperator + strDate + " 00:00:00";
//
//            if (seeStartTime < dateNew) {
//                alert("仅限近10天的数据");
//                return;
//            }
//        }
        if ($("#totalPriceLower").val() && !$("#totalPriceHigher").val()) {
            alert("请填写完整总价范围");
            return;
        }
        if ($("#areaLower").val() && !$("#areaHigher").val()) {
            alert("请填写完整面积范围");
            return;
        }

        var totalPriceLower = parseInt($("#totalPriceLower").val(), 10) || 0;
        var totalPriceHigher = parseInt($("#totalPriceHigher").val(), 10) || 0;
        var areaLower = parseInt($("#areaLower").val(), 10) || 0;
        var areaHigher = parseInt($("#areaHigher").val(), 10) || 0;

        var actName = $("#actName").val();
        if (actName) {
            var bid = actName.split(',');
            if (bid.length > 5) {
                alert("活动名称最多填5个");
                return false;
            }
        }

        var validValue = $form.valid();

        if (validValue) {
            $.ajax({
                url: $form.attr("action"),
                type: "POST",
                data: $form.serialize(),
                success: function (response) {
                    if (0 == response.status) {
                        var total = response.data.total;
                        if (total > 3000) {
                            alert("数据量超过3000条，请缩小范围");
                            return false;
                        }
                        $("#confirmDialog").attr("title", "查询确认");
                        $("#confirmDialog").text("根据条件查询到" + total + "组客户数据\n" + "是否加入到活动中？");
                        $("#confirmDialog").dialog({
                            dialogClass: "no-close",
                            autoOpen: false,
                            width: 600,
                            height: 150,
                            modal: true,
                            show: {
                                effect: "blind",
                                duration: 100
                            },
                            hide: {
                                effect: "explode",
                                duration: 100
                            },
                            buttons: [
                                {
                                    text: "确认",
                                    click: function () {
                                        $("#confirmDialog").dialog("close");
                                        doImport();
                                        //更新查询条件状态
//                                        updateQueryCondStatus()
                                        return true;
                                    }
                                },
                                {
                                    text: "取消",
                                    click: function () {
                                        $(this).dialog("close");
                                        return false;
                                    }
                                }
                            ]
                        }).dialog("open");

                    } else {
                        alert(response.errorMessage);
                        return false;
                    }
                }
            });
        }

    }

    $(document).ready(function () {
        var curDate;
        var limitDate = "${limitDate}";
        var maxDate;
        if (1 == limitDate) {
            curDate = moment(new Date().getTime() - 3 * 24 * 60 * 60 * 1000);
            maxDate = moment(new Date() - 3 * 24 * 60 * 60 * 1000);
        } else {
            curDate = new Date();
            maxDate = new Date(curDate.getTime() + 0 * 24 * 60 * 60 * 1000);
        }
        $.ajaxSetup({
            async: false
        });

        var options = {
            "showWeekNumbers": true,
            "showISOWeekNumbers": true,
            "startDate": curDate,
            "endDate": new Date(curDate + 0 * 24 * 60 * 60 * 1000),
            "maxDate": maxDate,
            "timePickerSeconds": true,
            "autoApply": true,
            // "dateLimit": {
            //     "days": 60
            // },
            "locale": {
                "direction": "ltr",
                "format": "YYYY年MM月DD日",
                "separator": " 至 ",
                "applyLabel": "确定",
                "cancelLabel": "取消",
                "fromLabel": "从",
                "toLabel": "至",
                "customRangeLabel": "Custom",
                "daysOfWeek": [
                    "日",
                    "一",
                    "二",
                    "三",
                    "四",
                    "五",
                    "六"
                ],
                "monthNames": [
                    "一月",
                    "二月",
                    "三月",
                    "四月",
                    "五月",
                    "六月",
                    "七月",
                    "八月",
                    "九月",
                    "十月",
                    "十一月",
                    "十二月"
                ],
                "firstDay": 1
            },
            weekendDis: false,
            "alwaysShowCalendars": true
        };

        $('#signTime').daterangepicker(options, function (start, end, label) {
//            console.log("New date range selected: ' + start.format('YYYY-MM-DD') + ' to ' + end.format('YYYY-MM-DD') + ' (predefined range: ' + label + ')");
            $("#applyStartTime").val(start.format('YYYY-MM-DD 00:00:00'));
            $("#applyEndTime").val(end.format('YYYY-MM-DD 00:00:00'));
        });
        $('#callbackTime').daterangepicker(options, function (start, end, label) {
            $("#returnVisitTimeStart").val(start.format('YYYY-MM-DD 00:00:00'));
            $("#returnVisitTimeEnd").val(end.format('YYYY-MM-DD 00:00:00'));
        });

        $('#signTimeNew').daterangepicker(options, function (start, end, label) {
            $("#seeStartTime").val(start.format('YYYY-MM-DD 00:00:00'));
            $("#seeEndTime").val(end.format('YYYY-MM-DD 00:00:00'));
        });

        $("#signTime").val("");
        $("#callbackTime").val("");
        $("#signTimeNew").val("");
    });
</script>

</body>

</html>
