<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>营销活动-step1</title>
</head>
<body>

<form id="input_form" class="form-horizontal valid" action="${ctx}/marketingactivity/step1" method="post">
    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li>
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <a href="${ctx}/marketingactivity">新增营销活动</a>
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='create'}">
                            <span class="inline">新增</span>
                        </c:when>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.id} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.id}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <div id="message"></div>
    <house365:flushMessage/>
    <div class="row${fluid}">
        <div class="span12">
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <div class="sectionTitle">
                        <c:choose>
                            <c:when test="${action=='create'}">
                                <h5>创建营销活动</h5>
                            </c:when>
                            <c:when test="${action=='edit'}">
                                <h5>编辑营销活动</h5>
                            </c:when>
                            <c:otherwise>
                                <h5>详情</h5>
                            </c:otherwise>
                        </c:choose>
                        <p>受CRM系统查询影响，单次获取的客户数量最多为3000个，活动周期为10天</p>
                    </div>
                    <input name="entity.id" type="hidden" value="${entity.id}"/>
                    <input name="action" type="hidden" value="${action}"/>
                    <div class="row-fluid">
                        <div class="span10 control-group">
                            <label class="control-label"><font color="red">*</font>活动名称:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <input type="text" id="entity.name" class="required"
                                               name="entity.name" maxlength="100"
                                               value="${entity.name}"/>
                                        <font color="red"><form:errors path="marketingActivityVo.entity.name"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.name}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span10 control-group">
                            <label class="control-label"><font color="red">*</font>活动类型:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='create' || action=='edit'}">
                                        <select id="type" name="entity.type" class="required">
                                            <option value="1"
                                                    <c:if test="${entity.type eq '1'}">selected="selected"</c:if>>电商活动
                                            </option>
                                            <option value="2"
                                                    <c:if test="${entity.type eq '2'}">selected="selected"</c:if>>分销活动
                                            </option>
                                            <option value="3"
                                                    <c:if test="${entity.type eq '3'}">selected="selected"</c:if>>其他
                                            </option>
                                        </select>
                                        <font color="red"><form:errors path="marketingActivityVo.entity.type"/></font>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.type}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>

                            </div>
                        </div>
                    </div>

                    <input type="hidden" id="cycle" name="entity.cycle" value="20"/>
                    <input type="hidden" id="expectExtractCount" name="entity.expectExtractCount" value="999"/>

                    <div class="row-fluid">
                        <div class="span1 control-group">
                        </div>
                        <div class="span6 control-group">
                            <c:if test="${action=='create'}">
                                <a href="javascript:void(0)" class="btn blue" onclick="checkFormdata()">
                                    <i class="icon-save"></i>&nbsp;下一步</a>
                            </c:if>
                            <c:if test="${action=='edit'}">
                                <a href="javascript:void(0)" class="btn blue" onclick="checkFormdata()">
                                    <i class="icon-save"></i>&nbsp;保存</a>
                            </c:if>
                            <a href="${ctx}/marketingactivity" class="btn gray"><i class="icon-mail-reply"></i>&nbsp;返回</a>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>

</form>

<script language="JavaScript">

    function checkFormdata() {
        var cycle = parseInt($("#cycle").val(), 10) || 0;
        var expectExtractCount = parseInt($("#expectExtractCount").val(), 10) || 0;
        <c:if test="${action=='create'}">
        if (cycle <= 0 || cycle > 30) {
            House365Util.showAlertMessage($("#message"), "活动周期最多持续30天，请重新输入！", "error");
            return;
        }
        </c:if>
        if (expectExtractCount <= 0 || expectExtractCount > 3000) {
            House365Util.showAlertMessage($("#message"), "单次活动最大提取数量为3000，请重新输入！", "error");
            return;
        }
        var $form = $("#input_form");
        var validValue = $form.valid();
        if (validValue) {
            $form.submit();
        }
    }

</script>
</body>

</html>
