<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
    <meta http-equiv="Content-Type" content="text/html" charset="utf-8">
    <meta name="viewport" content="width=device-width,minimum-scale=1.0,maximum-scale=1.0,user-scalable=no"/>
    <meta name="format-detection" content="telephone=no"/>
    <meta name="baidu-site-verification" content="v3NGId0qCU"/>
    <meta name="keywords" content=""/>
    <meta name="description" content=""/>
    <meta name="apple-mobile-web-app-title" content="">
    <meta name="apple-mobile-web-app-capable" content="yes"/>
    <link rel="stylesheet" href="http://frontend.house365.com/css/reset.css"/>
    <link rel="stylesheet" href="${ctx}/resources/customize/css/evaluate.css" type="text/css">
    <script type="text/javascript">
        (function (doc, win) {
            var docEl = doc.documentElement,
                resizeEvt = 'orientationchange' in window ? 'orientationchange' : 'resize',
                recalc = function () {
                    var clientWidth = docEl.clientWidth;
                    if (!clientWidth) return;
                    docEl.style.fontSize = 20 * (clientWidth / 375) + 'px';
                };
            if (!doc.addEventListener) return;
            win.addEventListener(resizeEvt, recalc, false);
            doc.addEventListener('DOMContentLoaded', recalc, false);
        })(document, window);
    </script>
</head>
<body>
<input type="hidden" id="id" value="${entity.id}"/>
<input type="hidden" id="tags"/>
<input type="hidden" id="score" value="0"/>
<header class="title">
    安家顾问-<span>${entity.userName}&nbsp;</span>邀请您进行带看评价
</header>
<c:if test="${entity.isEvaluated eq 1}">
    <div class="sucessC">
        <div class="sucess"></div>
        <p>该评价已打分！</p>
    </div>
</c:if>
<c:if test="${entity.isEvaluated ne 1}">
    <div class="cotent">
        <div class="cotentUp">
            <div class="flex" style="margin: .825rem 0 .71rem 0;">
                <p>评分</p>
                <div class="starList flex">
                    <div class="star"></div>
                    <div class="star"></div>
                    <div class="star"></div>
                    <div class="star"></div>
                    <div class="star"></div>
                </div>
                <p id="scoreShow">0分</p>
            </div>
            <p>评价</p>
            <div class="tagList flex">
                <c:forEach items="${evaluateOptions}" var="evaluateOption">
                    <div class="tag">${evaluateOption}</div>
                </c:forEach>
            </div>
        </div>
        <div class="cotentDown">
                <%--<p>内容 <span>可以从服务，态度等方面进行评价</span></p>--%>
            <textarea id="content" value="${entity.content}" maxlength="200"
                      placeholder="可以从服务，态度等方面进行评价"></textarea>
        </div>
        <div id="submitButton" class="btn">提交评价</div>
    </div>
    <div class="sucessC" style="display: none;">
        <div class="sucess"></div>
        <p>提交成功，感谢您的评价！</p>
    </div>
</c:if>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/jquery/jquery-1.10.2.min.js"></script>
<script>
    $(function () {
        $(".star").on("click", function () {
            var score = $(this).index() + 1;
            $(this).prevAll().addClass("on");
            $(this).addClass("on");
            $(this).nextAll().removeClass("on");
            $("#scoreShow").html(score + "分");
            $("#score").val(score);
        });

        $(".tag").on("click", function () {
            $(this).toggleClass("on");
            var content = "";
            $(".tag.on").each(function (n, tag) {
                content += $(tag).html() + " ";
            });
            $("#tags").val(content);
        });

        $("#submitButton").on("click", function () {
            var score = $("#score").val();
            if (score == "0") {
                alert("您还未给予评分！");
                return false;
            }
            var tags = $("#tags").val();
            var content = $("#content").val();
            if (content == "" && tags == "") {
                alert("请输入评价内容或者选择评价标签！");
                return false;
            }
            var tags = $("#tags").val();
            $.ajax({
                url: "${ctx}/evaluateusercustomerlog/evaluate/${entity.id}",
                type: "post",
                data: {
                    id: $("#id").val(),
                    score: score,
                    content: content,
                    tags: tags
                },
                success: function (data) {
                    $(".cotent").hide();
                    $(".sucessC").show();
                }
            });
        })
    });
</script>
</body>
</html>