<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<link rel="stylesheet" type="text/css" href="${static_common}/label/tag.css"/>
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "展开↓";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "收起↑";
    }

    .div-inline {
        display: inline-block;
    }

    .div-aaa {
        position: relative;
        overflow: auto;
        padding-left: 20px;
    }

    .div-aaa:before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        display: inline-block;
        background: #1890ff;
        width: 10px;
        height: 10px;
        border: 1px solid white;
        border-radius: 5px;
        z-index: 9;
    }

    .div-aaa:after {
        content: '';
        position: absolute;
        left: 4px;
        top: 0;
        display: inline-block;
        background: #1890ff;
        height: 100%;
        width: 2px;
        z-index: 8;
    }

    .div-aaa:last-child:after {
        display: none;
    }

    .td {
        text-align: center !important;
    }

    .tag-item {
        color: white;
    }

    .clearfix:before, .clearfix:after {
        content: "";
        display: block;
        clear: both;
    }

    .bt {
        padding: 5px 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
    }

    .color_999 {
        border: 1px solid #999;
        color: #999;
    }

    .color_d9534f {
        border: 1px solid #d9534f;
        color: #d9534f;
    }

    .color_f0ad4e {
        border: 1px solid #f0ad4e;
        color: #f0ad4e;
    }

    .color_5cb85c {
        border: 1px solid #5cb85c;
        color: #5cb85c;
    }

    .color_5bc0de {
        border: 1px solid #5bc0de;
        color: #5bc0de;
    }

    .color_0275d8 {
        border: 1px solid #0275d8;
        color: #0275d8;
    }

    .color_663399 {
        border: 1px solid #663399;
        color: #663399;
    }

    .temp {
        border: 1px solid #cccccc;
        width: 430px !important;
        height: 160px !important;
        position: relative;
        top: -26px;
        left: 81px;
    }

    .bat {
        padding: 5px 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
        margin: 0 5px;
    }

    .color_999 {
        border: 1px solid #999;
        color: #999;
    }

    .color_d9534f {
        border: 1px solid #d9534f;
        color: #d9534f;
    }

    .color_f0ad4e {
        border: 1px solid #f0ad4e;
        color: #f0ad4e;
    }

    .color_5cb85c {
        border: 1px solid #5cb85c;
        color: #5cb85c;
    }

    .color_5bc0de {
        border: 1px solid #5bc0de;
        color: #5bc0de;
    }

    .color_0275d8 {
        border: 1px solid #0275d8;
        color: #0275d8;
    }

    .color_663399 {
        border: 1px solid #663399;
        color: #663399;
    }

    .bt_last {
        background-color: #f0f0f0 !important;
        border: none !important;
        background-image: none !important;
    }

    .chosen-container {
        width: 96px !important;
    }
</style>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/customer<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li><a href="/house365-hgs-web/">首页</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    <%--<a href="/house365-hgs-web/customermanagement/myCustomerNew?type=&search_EQ_orderByTime=5">数据公海</a>--%>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> 数据公海> </span>
                    公海客户信息
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <span class="inline"> ${entity.name}</span>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>

    <div class="row${fluid}">
        <div class="span10 offset1">
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <input name="entity.id" type="hidden" value="${entity.id}"/>

                    <div class="sectionTitle" style="height:30px;">
                        基本信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label"><span style="color:red;">*</span> 客户姓名:</label>
                            <div class="controls">
                                <span class="inline">${entity.name}&nbsp;</span>
                                <sapn><a href="#" onclick="getCRM(${entity.id})">查看CRM视图</a></sapn>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">手机号码:</label>
                            <div class="controls">
                                <span class="inline">${entity.phone}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户类型:</label>
                            <div class="controls">
                                ${entity.createSource}
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">安家顾问:</label>
                            <div class="controls">
                                ${entity.managerName}
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">性别:</label>
                            <div class="controls">
                                <c:if test="${'2' eq entity.sex}">未知</c:if>
                                <c:if test="${'1' eq entity.sex}">男</c:if>
                                <c:if test="${'0' eq entity.sex}">女</c:if>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">其他号码1:</label>
                            <div class="controls">
                                <span class="inline">${entity.bakPhone1}&nbsp;</span>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">跟踪状态:</label>
                            <div class="controls">
                                <c:if test="${'1' eq entity.traceStatus}">有效</c:if>
                                <c:if test="${'2' eq entity.traceStatus}">已购</c:if>
                                <c:if test="${'3' eq entity.traceStatus}">我购</c:if>
                                <c:if test="${'4' eq entity.traceStatus}">暂缓</c:if>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">购房意向:</label>
                            <div class="controls">
                                <c:forEach items="${fns:getDictList('crm_visit_result')}" var="dict">
                                    <c:if test="${dict.dicValue <= 5}">
                                        <c:if test="${dict.dicValue eq entity.buyIntention}">${dict.dicName}</c:if>
                                    </c:if>
                                </c:forEach>
                            </div>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">标签:</label>
                        </div>
                    </div>

                    <div class="row-fluid">
                        <div class="clearfix" style="padding-bottom: 15px;">
                            <div style="margin-top: 5px;float:left;margin-left: 15px;">
                                <c:forEach items="${labs}" var="lid">
                                    <c:if test="${1 eq lid.colorId}">
                                        <span class="tag-item gray"
                                              style="background-color: #999;border-color: transparent;" data-index="1">
                                                ${lid.labelName}
                                        </span>

                                    </c:if>
                                    <c:if test="${2 eq lid.colorId}">
                                        <span class="tag-item red"
                                              style="background-color: #d9534f;border-color: transparent;"
                                              data-index="2">
                                                ${lid.labelName}
                                        </span>
                                    </c:if>
                                    <c:if test="${3 eq lid.colorId}">
                                        <span class="tag-item orange"
                                              style="background-color: #f0ad4e;border-color: transparent;"
                                              data-index="3">
                                                ${lid.labelName}
                                        </span>
                                    </c:if>
                                    <c:if test="${4 eq lid.colorId}">
                                        <span class="tag-item green"
                                              style="background-color: #5cb85c;border-color: transparent;"
                                              data-index="4">
                                                ${lid.labelName}
                                        </span>
                                    </c:if>
                                    <c:if test="${5 eq lid.colorId}">
                                        <span class="tag-item blue"
                                              style="background-color: #5bc0de;border-color: transparent;"
                                              data-index="5">
                                                ${lid.labelName}
                                        </span>
                                    </c:if>
                                    <c:if test="${6 eq lid.colorId}">
                                        <span class="tag-item darkblue"
                                              style="background-color: #0275d8;border-color: transparent;"
                                              data-index="6">
                                                ${lid.labelName}
                                        </span>
                                    </c:if>
                                    <c:if test="${7 eq lid.colorId}">
                                        <span class="tag-item zi"
                                              style="background-color: #663399;border-color: transparent;"
                                              data-index="7">
                                                ${lid.labelName}
                                        </span>
                                    </c:if>
                                </c:forEach>
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        回访记录&约看记录
                    </div>
                    <div>
                        <div class="div-inline" style="width: 45%;margin-left: 2%;vertical-align: top;">
                            <span>回访记录</span>
                            <div style="margin-top: 10px;border: 1px solid #ccc;padding: 10px;">
                                <c:forEach items="${callLogs}" var="call">
                                    <div class="row-fluid div-aaa">
                                        <div style="color: #ccc;margin-bottom: 10px;">
                                                ${call.managerName}
                                            <span style="float: right;color: #ccc">
                                                 <fmt:formatDate value='${call.createTime}'
                                                                 pattern='yyyy-MM-dd HH:mm:ss'/>
                                            </span>
                                        </div>

                                        <div style="margin-bottom: 10px;">
                                                ${call.content}
                                            <c:if test="${null ne call.callRecordName && '' ne call.callRecordName}">
                                                <span>
                                                    <audio controls>
                                                        <source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path=${call.callRecordName}">
                                                         Your browser does not support this audio format.
                                                    </audio>
                                                </span>
                                            </c:if>
                                        </div>
                                    </div>
                                </c:forEach>
                                <c:if test="${0 eq fn:length(callLogs)}">
                                    <div style="margin-bottom: 10px;">
                                        暂无回访记录！
                                    </div>
                                </c:if>
                            </div>
                        </div>
                        <div class="div-inline" style="width: 45%;margin-left: 2%;">
                            <span>约看记录</span>
                            <div style="border: 1px solid #ccc;margin-top: 10px;">
                                <table class="table table-bordered"
                                       style="width: 90%;margin-left: 5%;margin-top: 10px;">
                                    <thead>
                                    <tr>
                                        <th class="td" width="100">约看项目</th>
                                        <th class="td" width="100">客户状态</th>
                                        <th class="td" width="100">约看时间</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <c:if test="${0 eq fn:length(customerProjects)}">
                                        <tr>
                                            <td colspan="3" class="td">
                                                暂无约看记录！
                                            </td>
                                        </tr>
                                    </c:if>
                                    <c:forEach items="${customerProjects}" var="cp">
                                        <tr>
                                            <td class="td">
                                                <a href="${ctx}/customer/updateProjectInfo/${cp.id}"
                                                   target="_blank">${cp.projectName}</a>
                                            </td>
                                            <td class="td">
                                                <c:if test="${not empty cp.status}">
                                                    <c:choose>
                                                        <c:when test="${cp.status eq '1'}">
                                                            <span class="inline">约看</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '2'}">
                                                            <span class="inline">到访</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '3'}">
                                                            <span class="inline">认筹</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '4'}">
                                                            <span class="inline">认购</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '5'}">
                                                            <span class="inline">签约</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '6'}">
                                                            <span class="inline">退房</span>
                                                        </c:when>
                                                    </c:choose>
                                                </c:if>
                                                <span style="color:red;">${cp.remark}</span>
                                            </td>
                                            <td class="td">
                                                <c:if test="${null ne cp.recordedTime}">
                                                    <f:formatDate value='${cp.recordedTime}'
                                                                  pattern='yyyy-MM-dd HH:mm:ss'/>
                                                </c:if>
                                            </td>
                                        </tr>
                                    </c:forEach>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;margin-top: 10px;">
                        客户情况与来源
                    </div>
                    <div class="row-fluid">
                        <table class="table table-bordered" style="width: 90%;margin-left: 5%;">
                            <thead>
                            <tr>
                                <th class="td" width="100">id</th>
                                <th class="td" width="100">来源类型</th>
                                <th class="td" width="100">最近来源</th>
                                <th class="td" width="100">活动名称</th>
                                <th class="td" width="100">CRM最近回访</th>
                                <th class="td" width="100">CRM回访结果</th>
                                <th class="td" width="100">添加时间</th>
                            </tr>
                            </thead>
                            <tbody>
                            <c:forEach items="${oldList}" var="old">
                                <tr>
                                    <td class="td" width="100">${old.id}</td>
                                    <td class="td" width="100">${old.createSource}</td>
                                    <td class="td" width="100">${old.latestSource}</td>
                                    <td class="td" width="100">${old.actSource}</td>
                                    <td class="td" width="100">${old.crmLatestCall}</td>
                                    <td class="td" width="100">${old.crmLatestCallResult}</td>
                                    <td class="td">
                                        <c:if test="${null ne old.createTime}">
                                            <f:formatDate value='${old.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                                        </c:if>
                                    </td>
                                </tr>
                            </c:forEach>
                            </tbody>
                        </table>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        客户日志
                    </div>
                    <ul>
                        <c:forEach items="${logList}" var="log">
                            <li>
                                <c:out value="${log}"/>
                            </li>
                        </c:forEach>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</form>

<script>

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/customer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    $(document).on('click', '.bat', function () {
        var bor_color = $(this).css("borderRightColor");
        var bg_color = $(this).css("background-color");
        var labelIds = $("#labelIds").val();

        if (bg_color === 'rgb(255, 255, 255)') {
            $(this).css("background-color", bor_color);
            $(this).css("color", "white");
            $(this).attr("opsel", 1);
            var lid = $(this).attr("data-index");
            arr.push(lid);
        } else {
            $(this).css("background-color", "rgb(255, 255, 255)");
            $(this).css("color", bor_color);
            $(this).attr("opsel", 0);
            var lid = $(this).attr("data-index");
            for (var i = 0; i < arr.length; i++) {
                if (arr[i] == lid) {
                    arr.splice(i, 1);
                }
            }
        }
    });

    var resultNum = [];
    $(document).on('click', '.bt', function () {
        var bor_color = $(this).css("borderRightColor");
        var bg_color = $(this).css("background-color");
        if (bg_color === 'rgb(255, 255, 255)') {
            if (arr3.indexOf($(this).attr("value")) == -1) {
                resultNum.push($(this).attr("value"));
            }
            $(this).css("background-color", bor_color);
            $(this).css("color", "white");
        } else {
            resultNum.splice(resultNum.indexOf($(this).attr("value")), 1);
            $(this).css("background-color", "rgb(255, 255, 255)");
            $(this).css("color", bor_color);
        }
    });

</script>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>
<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>

</body>

</html>
