<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>我的客户</title>
</head>
<body>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "-";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "+";
    }
</style>
<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li><a href="/house365-hgs-web/">首页</a>
                <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                我的客户
            </li>
        </ul>
    </div>
</div>

<!-- 面包屑 begin -->
<div class="row-fluid">
    <div class="span12">
        <ul class="breadcrumb">
            <li class="active">
                <b>今日新增客户：</b>
                <span color="red" style="cursor:pointer;">
                    <b onclick="viewCustomer('1')">${summary['newadd']}</b>
                </span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <b>累计客户：</b>
                <span color="red" style="cursor:pointer;">
                    <b onclick="javascript:window.open('${ctx}/customer/myCustomer','_blank')">${summary['allCount']}</b>
                </span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <b>超过7天未回访的新增客户：</b>
                <span color="red" style="cursor:pointer;">
                    <b onclick="viewCustomer('3')">${summary['nocall7']}</b>
                </span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <b>超过3天未回访的客户：</b>
                <span color="red" style="cursor:pointer;">
                    <b onclick="viewCustomer('4')">${summary['nocall3']}</b>
                </span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                <b>已到访后超过7天状态未更新的客户：</b>
                <span color="red" style="cursor:pointer;">
                    <b onclick="viewCustomer('5')">${summary['noupdate']}</b>
                </span>
            </li>
        </ul>
    </div>
</div>

<div class="page-container">
    <div class="row${fluid}">
        <div class="span12">
            <form id="filterForm" class="form-inline filterForm" action="${ctx}/customer/myCustomer" method="get">
                <input type="hidden" name="summaryType" value="${summaryType}"/>
                <input style="width: 6rem" type="text" name="search_LIKE_name" value="${param['search_LIKE_name']}"
                       class="m-wrap small span2" placeholder="客户姓名/手机号码">
                <input style="width: 6rem" type="text" name="search_LIKE_houseName"
                       value="${param['search_LIKE_houseName']}"
                       class="m-wrap small span2" placeholder="楼盘名称">
                <input style="width: 6rem" type="text" name="search_LIKE_managerName"
                       value="${param['search_LIKE_managerName']}"
                       class="m-wrap small span2" placeholder="置业顾问">
                <input style="width: 6rem" type="text" name="search_GTE_createTimeStart" id="search_GTE_createTimeStart"
                       value="${param['search_GTE_createTimeStart']}"
                       class="m-wrap small span2" placeholder="创建时间-起始">至
                <input style="width: 6rem" type="text" name="search_LTE_createTimeEnd" id="search_LTE_createTimeEnd"
                       value="${param['search_LTE_createTimeEnd']}"
                       class="m-wrap small span2" placeholder="创建时间-截止">
                <select style="width: 6rem" name="search_EQ_recordedStatus" id="search_EQ_recordedStatus">
                    <option>案场报备状态</option>
                    <option value=""
                            <c:if test="${'' eq param['search_EQ_recordedStatus']}">selected="selected"</c:if>>
                        待定
                    </option>
                    <option value="0"
                            <c:if test="${'0' eq param['search_EQ_recordedStatus']}">selected="selected"</c:if>>
                        无效
                    </option>
                    <option value="1"
                            <c:if test="${'1' eq param['search_EQ_recordedStatus']}">selected="selected"</c:if>>
                        有效
                    </option>
                </select>
                <select style="width: 6rem" name="search_EQ_projectStatus" id="search_EQ_projectStatus">
                    <option value="">客户状态</option>
                    <option value="1"
                            <c:if test="${'1' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        约看
                    </option>
                    <option value="2"
                            <c:if test="${'2' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        到访
                    </option>
                    <option value="3"
                            <c:if test="${'3' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        认筹
                    </option>
                    <option value="4"
                            <c:if test="${'4' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        认购
                    </option>
                    <option value="5"
                            <c:if test="${'5' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        签约
                    </option>
                    <option value="6"
                            <c:if test="${'6' eq param['search_EQ_projectStatus']}">selected="selected"</c:if>>
                        退房
                    </option>
                </select>
                <select style="width: 6rem" name="search_EQ_loanStatus" id="search_EQ_loanStatus">
                    <option value="">贷款状态</option>
                    <option value="0" <c:if test="${'0' eq param['search_EQ_loanStatus']}">selected="selected"</c:if>>
                        未办理
                    </option>
                    <option value="1" <c:if test="${'1' eq param['search_EQ_loanStatus']}">selected="selected"</c:if>>
                        申请中
                    </option>
                    <option value="2" <c:if test="${'2' eq param['search_EQ_loanStatus']}">selected="selected"</c:if>>
                        已下款
                    </option>
                    <option value="3" <c:if test="${'3' eq param['search_EQ_loanStatus']}">selected="selected"</c:if>>
                        被拒绝
                    </option>
                    <option value="4" <c:if test="${'4' eq param['search_EQ_loanStatus']}">selected="selected"</c:if>>
                        全款支付
                    </option>
                </select>
                <select style="width: 6rem" name="search_EQ_traceStatus" id="search_EQ_traceStatus">
                    <option value="">跟踪状态</option>
                    <option value="1" <c:if test="${'1' eq param['search_EQ_traceStatus']}">selected="selected"</c:if>>
                        有效
                    </option>
                    <option value="2" <c:if test="${'2' eq param['search_EQ_traceStatus']}">selected="selected"</c:if>>
                        已购
                    </option>
                    <option value="3" <c:if test="${'3' eq param['search_EQ_traceStatus']}">selected="selected"</c:if>>
                        我购
                    </option>
                    <option value="4" <c:if test="${'4' eq param['search_EQ_traceStatus']}">selected="selected"</c:if>>
                        暂缓
                    </option>
                </select>
                <select style="width: 6rem" name="search_EQ_buyIntention" id="search_EQ_buyIntention">
                    <option>购房意向</option>
                    <option value=""
                            <c:if test="${'' eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>
                        待定
                    </option>
                    <c:forEach items="${fns:getDictList('crm_visit_result')}" var="dict">
                        <c:if test="${dict.dicValue <= 5}">
                            <option value="${dict.dicValue}"
                                    <c:if test="${dict.dicValue eq param['search_EQ_buyIntention']}">selected="selected"</c:if>>${dict.dicName}</option>
                        </c:if>
                    </c:forEach>
                </select>
                <input type="hidden" name="orderColumn" value="${param['orderColumn']}"/>
                <input type="hidden" name="orderMode" value="${param['orderMode']}"/>
                <div class="buttons pull-right" style="margin-left:15px;">
                    <button type="button" class="btn btn-default" onclick="assignHouse()">批量约看</button>
                    <button type="button" class="btn btn-default" onclick="assignManager()">客户转移</button>
                    <button type="button" class="btn btn-default"
                            onclick="window.open('${ctx}/customer/newCustomer','_blank')">添加客户
                    </button>
                </div>
                <%--<div class="buttons pull-right">--%>
                <%--<a href="javascript:void(0);" onclick="deleteById('')" class="btn blue pull-right" title="删除"><i--%>
                <%--class="icon-minus"></i></a>--%>
                <%--</div>--%>
                <div class="buttons pull-right" style="margin:3px 30px 0 0;">
                    <i class="icon-search icon-2x pointer" onclick="$('#filterForm').submit();" title="搜索"></i>
                </div>
            </form>
        </div>
    </div>
    <table class="table table-advance table-hover">
        <thead>
        <tr>
            <th width="40" style="text-align:center">
                <input id="memberCheckAll" type="checkbox" onclick="checkAll(this)"/>
            </th>
            <th width="40">序号</th>
            <th width="50">姓名</th>
            <th width="100">电话</th>
            <th width="40">跟踪状态</th>
            <th width="100">置业顾问</th>
            <th width="240">最近回访记录</th>
            <th width="80" style="cursor:pointer;" onclick="sortBy('last_call_time','
            <c:if
                    test="${param['orderMode'] eq 'desc'}">asc</c:if>
            <c:if
                    test="${param['orderMode'] eq 'asc'}"></c:if>
            <c:if
                    test="${empty param['orderMode']}">desc</c:if>')">最近回访时间<c:if
                    test="${param['orderMode'] eq 'desc'}">&nbsp;↓</c:if><c:if
                    test="${param['orderMode'] eq 'asc'}">&nbsp;↑</c:if>
            </th>
            <th width="80">添加日期</th>
            <th width="150">操作</th>
        </tr>
        </thead>
        <c:forEach items="${customers}" var="customer" varStatus="vs">
            <tr class="header expand" <c:if test="${vs.index%2==0}">style="background-color:#ddd;"</c:if></tr>
            <td nowrap="nowrap" style="text-align:center">
                <input type="checkbox" name="memberCheck" value="${customer.id}" onclick="checkMember(this)"/>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne customer.id && '' ne customer.id}">
                    <c:out value="${customer.id}"/>
                </c:if>
                <c:if test="${null eq customer.id || '' eq customer.id}">
                    &nbsp;
                </c:if>
                <c:if test="${not empty customer.cps}">
                    <span class="sign"></span>
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne customer.name && '' ne customer.name}">
                    <c:choose>
                        <c:when test="${fn:length(customer.name) > 4}">
                            <c:out value="${fn:substring(customer.name, 0, 4)}..."/>
                        </c:when>
                        <c:otherwise>
                            <c:out value="${customer.name}"/>
                        </c:otherwise>
                    </c:choose>
                </c:if>
                <c:if test="${null eq customer.name || '' eq customer.name}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne customer.phone && '' ne customer.phone}">
                    <c:out value="${customer.phone}"/>
                </c:if>
                <c:if test="${null eq customer.phone || '' eq customer.phone}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${not empty customer.traceStatus}">
                    <c:choose>
                        <c:when test="${customer.traceStatus eq '1'}">
                            <span class="inline">有效</span>
                        </c:when>
                        <c:when test="${customer.traceStatus eq '2'}">
                            <span class="inline">已购</span>
                        </c:when>
                        <c:when test="${customer.traceStatus eq '3'}">
                            <span class="inline">我购</span>
                        </c:when>
                        <c:when test="${customer.traceStatus eq '4'}">
                            <span class="inline">暂缓</span>
                        </c:when>
                    </c:choose>
                </c:if>
                <c:if test="${empty customer.traceStatus}">
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne customer.managerName && '' ne customer.managerName}">
                    <c:out value="${customer.managerName}"/>
                </c:if>
                <c:if test="${null eq customer.managerName || '' eq customer.managerName}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:choose>
                    <c:when test="${fn:length(customer.remark) > 24}">
                        <c:out value="${fn:substring(customer.remark, 0, 24)}..."/>
                    </c:when>
                    <c:otherwise>
                        <c:out value="${customer.remark}"/>
                    </c:otherwise>
                </c:choose>
                <c:if test="${null eq customer.remark || '' eq customer.remark}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne customer.lastCallTime && '' ne customer.lastCallTime}">
                    <f:formatDate value='${customer.lastCallTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                </c:if>
                <c:if test="${null eq customer.lastCallTime || '' eq customer.lastCallTime}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <c:if test="${null ne customer.createTime && '' ne customer.createTime}">
                    <f:formatDate value='${customer.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                </c:if>
                <c:if test="${null eq customer.createTime || '' eq customer.createTime}">
                    &nbsp;
                </c:if>
            </td>
            <td nowrap="nowrap">
                <button type="button" class="btn btn-default" onclick="assignHouseSingle(${customer.id})">约看
                </button>
                <button type="button" class="btn btn-default" onclick="customerInfo(${customer.id})">详情</button>
            </td>
            </tr>
            <c:if test="${not empty customer.cps}">
                <tr>
                    <td colspan="11" style="background-color: #eef4f6;">
                        <table class="table table-bordered">
                            <thead>
                            <tr>
                                <th>约看楼盘</th>
                                <th>案场报备</th>
                                <th>客户状态</th>
                                <th>贷款状态</th>
                                <th>约看时间</th>
                            </tr>
                            </thead>

                            <c:forEach items="${customer.cps}" var="cc">
                                <tr>
                                    <td nowrap="nowrap">
                                        <a href="${ctx}/project/detail/${cc.projectId}"
                                           target="_blank">${cc.projectName}</a>
                                    </td>
                                    <td nowrap="nowrap">
                                        <c:if test="${not empty cc.recordedStatus}">
                                            <c:choose>
                                                <c:when test="${cc.recordedStatus eq '1'}">
                                                    <span class="inline">有效</span>
                                                </c:when>
                                                <c:when test="${cc.recordedStatus eq '0'}">
                                                    <span class="inline">无效</span>
                                                </c:when>
                                            </c:choose>
                                        </c:if>
                                        <c:if test="${empty cc.recordedStatus}">
                                            待定
                                        </c:if>
                                    </td>
                                    <td nowrap="nowrap">
                                        <c:if test="${not empty cc.status}">
                                            <c:choose>
                                                <c:when test="${cc.status eq '1'}">
                                                    <span class="inline">约看</span>
                                                </c:when>
                                                <c:when test="${cc.status eq '2'}">
                                                    <span class="inline">到访</span>
                                                </c:when>
                                                <c:when test="${cc.status eq '3'}">
                                                    <span class="inline">认筹</span>
                                                </c:when>
                                                <c:when test="${cc.status eq '4'}">
                                                    <span class="inline">认购</span>
                                                </c:when>
                                                <c:when test="${cc.status eq '5'}">
                                                    <span class="inline">签约</span>
                                                </c:when>
                                                <c:when test="${cc.status eq '6'}">
                                                    <span class="inline">退房</span>
                                                </c:when>
                                            </c:choose>
                                        </c:if>
                                        <c:if test="${empty cc.status}">
                                        </c:if>
                                        <c:if test="${'new' eq cc.remark}">
                                            <img src="${ctx}/resources/image/new.gif"> &nbsp;&nbsp;
                                        </c:if>
                                    </td>
                                    <td nowrap="nowrap">
                                        <c:if test="${not empty cc.loanStatus}">
                                            <c:choose>
                                                <c:when test="${cc.loanStatus eq '0'}">
                                                    <span class="inline">未办理</span>
                                                </c:when>
                                                <c:when test="${cc.loanStatus eq '1'}">
                                                    <span class="inline">申请中</span>
                                                </c:when>
                                                <c:when test="${cc.loanStatus eq '2'}">
                                                    <span class="inline">已下款</span>
                                                </c:when>
                                                <c:when test="${cc.loanStatus eq '3'}">
                                                    <span class="inline">被拒绝</span>
                                                </c:when>
                                                <c:when test="${cc.loanStatus eq '4'}">
                                                    <span class="inline">全款支付</span>
                                                </c:when>
                                            </c:choose>
                                        </c:if>
                                        <c:if test="${empty cc.loanStatus}">
                                        </c:if>
                                    </td>
                                    <td nowrap="nowrap">
                                        <c:if test="${not empty cc.createTime}">
                                            <f:formatDate value='${cc.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                                        </c:if>
                                        <c:if test="${empty cc.createTime}">
                                        </c:if>
                                    </td>
                                    <td nowrap="nowrap">
                                        <button type="button" class="btn btn-default"
                                                onclick="window.open('${ctx}/customer/updateProjectInfo/${cc.id}','_blank')">
                                            约看详情
                                        </button>
                                    </td>
                                </tr>
                            </c:forEach>
                        </table>
                    </td>
                </tr>

            </c:if>
        </c:forEach>
    </table>
    <div class="row${fluid}">
        <house365:pagination page="${page}"/>
    </div>
</div>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/script/My97DatePicker/WdatePicker.js"></script>
<script language="javascript" type="text/javascript"
        src="${ctx}/resources/jquery.qtip.custom/jquery.qtip.min.js"></script>

<script type="text/javascript">
    $(function () {
        var startTime = $("#search_GTE_createTimeStart")
        var endTime = $("#search_LTE_createTimeEnd");
        endTime.bind("click", function () {
            WdatePicker({doubleCalendar: true, startDate: "%y-{%M-1}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: true});
        });
        startTime.bind("click", function () {
            WdatePicker({
                doubleCalendar: true, startDate: "%y-{%M-1}-%d", dateFmt: "yyyy-MM-dd", autoPickDate: true,
                onpicked: function () {
//                    $("#search_LTE_createTimeEnd").click();
                    WdatePicker({
                        doubleCalendar: true,
                        startDate: "%y-{%M-1}-%d",
                        dateFmt: "yyyy-MM-dd",
                        autoPickDate: true,
                        el: 'search_LTE_createTimeEnd'
                    })
                }
            });
        });

        $('.baobei').each(function () { // Notice the .each() loop, discussed below
            $(this).qtip({
                content: {
                    text: $(this).next('div') // Use the "div" element next to this for the content
                }, position: {
                    at: 'bottom center', // at the bottom right of...
                    target: $(this) // my target
                }
            });
        });

        $('.header').each(function () {
            $(this).nextUntil('tr.header').hide();
        })

        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });
    });

    function assignHouse() {
        var customerIds = "";
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
            }
        }
        if (customerIds == '') {
            alert("请至少选择一个客户!");
            return false;
        }

        House365Util.createRemoteModal("批量约看客户", "${ctx}/customer/assignProject?customerId=" + customerIds, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("约看项目不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            if (customerIds == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            $.ajax({
                url: '${ctx}/customer/bindProject',
                data: {"projectIds": userIds, "customerIds": customerIds},
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
    }

    function assignHouseSingle(obj) {
        House365Util.createRemoteModal("约看客户", "${ctx}/customer/assignProject?customerId=" + obj, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("约看项目不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            if (obj == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            $.ajax({
                url: '${ctx}/customer/bindProject',
                data: {"projectIds": userIds, "customerIds": obj},
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
    }

    function assignManagerSingle(obj) {
        House365Util.createRemoteModal("批量派工", "${ctx}/customer/transManager?customerCount=1", null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });

            if (obj == '') {
                alert("请至少选择一个客户!");
                return false;
            }

            $.ajax({
                url: '${ctx}/customer/assign',
                data: {"userIds": userIds, "customerIds": obj},
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
    }

    function assignManager() {
        var customerIds = "", customerCont = 0;
        for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
            if (document.getElementsByName('memberCheck')[i].checked) {
                customerIds += document.getElementsByName('memberCheck')[i].value + ",";
                customerCont += 1;
            }
        }

        if (customerIds == '') {
            alert("请至少选择一个客户!");
            return false;
        }

        House365Util.createRemoteModal("客户转移", "${ctx}/customer/transManager?customerCount=" + customerCont, null, function () {
            var userIds = "";
            if ($("#custom-headers").find("option:selected").length == 0) {
                alert("分派人员不可为空!");
                return false;
            }

            $("#custom-headers").find("option:selected").each(function () {
                userIds = userIds + $(this).val() + ",";
            });


            if (customerIds == '') {
                alert("至少要选择一个客户!");
                return false;
            }

            $.ajax({
                url: '${ctx}/customer/assign',
                data: {"userIds": userIds, "customerIds": customerIds},
                type: "GET",
                success: function (data) {
                    if (data.result == '1') {
                        window.location.reload();
                    } else {
                        alert("操作失败，" + data.msg);
                    }
                }
            });
            return true;
        });
    }


    //全选
    function checkAll(btn) {
        if (btn.checked) {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "checked";
            }
        }
        else {
            for (i = 0; i < document.all("memberCheck").length; i++) {
                document.all("memberCheck")[i].checked = "";
            }
        }
    }

    //单选
    function checkMember(btn) {
        if (btn.checked) {
            var checkAll = true;
            for (i = 0; i < document.all("memberCheck").length; i++) {
                if (document.all("memberCheck")[i].checked == false) {
                    checkAll = false;
                }
            }

            if (checkAll) {
                document.getElementById("memberCheckAll").checked = true;
            }
        }
        else {
            document.getElementById("memberCheckAll").checked = false;
        }
    }

    var deleteById = function (selectedId) {
        /*
         id为空则是多选  判断是否为空
         为空 提示选择
         不为空 确认后删除
         不为空单选确认后删除
         */
        if (selectedId == "") {
            for (i = 0; i < document.getElementsByName('memberCheck').length; i++) {
                if (document.getElementsByName('memberCheck')[i].checked) {
                    selectedId += document.getElementsByName('memberCheck')[i].value + ",";
                }
            }

            var str = "";
            if (selectedId != "") {
                str = selectedId.split(",");

                if (str[str.length - 1] == "") {
                    selectedId = selectedId.substring(0, selectedId.length - 1);
                }
            }
        }

        if (selectedId == "") {
            House365Util.createModal("删除公告", "请至少选择一条公告!", function () {
            });
        } else {
            House365Util.createModal("删除公告", "确定要删除该公告？", function () {
                $.ajax({
                    url: '${ctx}/customer/' + selectedId,
                    type: "DELETE",
                    success: function () {
                        window.location.reload();
                    }
                });
            });
        }

    };

    function customerInfo(id) {
        window.open("${ctx}/customer/customerInfo?action=edit&customerId=" + id, "_blank");
    }

    function viewCustomer(type) {
        window.open("${ctx}/customer/myCustomer?summaryType=" + type, "_blank");
    }

    //排序
    function sortBy(column, mode) {
        $("form input[name='orderColumn']").val(column);
        $("form input[name='orderMode']").val(mode);
        $('#filterForm').submit();
    }
</script>
</body>
</html>
