<%@include file="/WEB-INF/common/layouts/common.jsp" %>
<%@ page language="java" pageEncoding="UTF-8" %>
<html>
<head>
    <title>${entity.id}</title>
</head>
<body>
<link rel="stylesheet" type="text/css" href="${static_common}/label/tag.css"/>
<style>
    tr.header {
        cursor: pointer;
    }

    .header .sign:after {
        content: "展开↓";
        display: inline-block;
    }

    .header.expand .sign:after {
        content: "收起↑";
    }

    .div-inline {
        display: inline-block;
    }

    .div-aaa {
        position: relative;
        overflow: auto;
        padding-left: 20px;
    }

    .div-aaa:before {
        content: '';
        position: absolute;
        left: 0;
        top: 0;
        display: inline-block;
        background: #1890ff;
        width: 10px;
        height: 10px;
        border: 1px solid white;
        border-radius: 5px;
        z-index: 9;
    }

    .div-aaa:after {
        content: '';
        position: absolute;
        left: 4px;
        top: 0;
        display: inline-block;
        background: #1890ff;
        height: 100%;
        width: 2px;
        z-index: 8;
    }

    .div-aaa:last-child:after {
        display: none;
    }

    .td {
        text-align: center !important;
    }

    .tag-item {
        color: white;
    }

    .clearfix:before, .clearfix:after {
        content: "";
        display: block;
        clear: both;
    }

    .bt {
        padding: 5px 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
    }

    .color_999 {
        border: 1px solid #999;
        color: #999;
    }

    .color_d9534f {
        border: 1px solid #d9534f;
        color: #d9534f;
    }

    .color_f0ad4e {
        border: 1px solid #f0ad4e;
        color: #f0ad4e;
    }

    .color_5cb85c {
        border: 1px solid #5cb85c;
        color: #5cb85c;
    }

    .color_5bc0de {
        border: 1px solid #5bc0de;
        color: #5bc0de;
    }

    .color_0275d8 {
        border: 1px solid #0275d8;
        color: #0275d8;
    }

    .color_663399 {
        border: 1px solid #663399;
        color: #663399;
    }

    .temp {
        border: 1px solid #cccccc;
        width: 430px !important;
        height: 160px !important;
        position: relative;
        top: -26px;
        left: 81px;
    }

    .bat {
        padding: 5px 10px;
        background-color: white;
        border-radius: 5px;
        outline: 0;
        border-color: transparent;
        box-shadow: none;
        margin: 0 5px;
    }

    .color_999 {
        border: 1px solid #999;
        color: #999;
    }

    .color_d9534f {
        border: 1px solid #d9534f;
        color: #d9534f;
    }

    .color_f0ad4e {
        border: 1px solid #f0ad4e;
        color: #f0ad4e;
    }

    .color_5cb85c {
        border: 1px solid #5cb85c;
        color: #5cb85c;
    }

    .color_5bc0de {
        border: 1px solid #5bc0de;
        color: #5bc0de;
    }

    .color_0275d8 {
        border: 1px solid #0275d8;
        color: #0275d8;
    }

    .color_663399 {
        border: 1px solid #663399;
        color: #663399;
    }

    .bt_last {
        background-color: #f0f0f0 !important;
        border: none !important;
        background-image: none !important;
    }

    .chosen-container {
        width: 96px !important;
    }
</style>
<form id="input_form" class="form-horizontal valid"
      action="${ctx}/customer<c:if test="${action=='edit'}">/${entity.id}</c:if>"
      method="post">

    <!-- 面包屑 begin -->
    <div class="row-fluid">
        <div class="span12">
            <ul class="breadcrumb">
                <li><a href="/house365-hgs-web/">首页</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    <a href="/house365-hgs-web/customermanagement/myCustomerNew?type=&search_EQ_orderByTime=5">我的客户</a>
                    <span class="divider" style="color:#26a0da;font-weight:bold;"> > </span>
                    客户信息
                </li>
                <li class="active">
                    <span class="divider" style="color:#26a0da;font-weight:bold;">/</span>
                    <c:choose>
                        <c:when test="${action=='edit'}">
                            <span class="inline"> ${entity.name} </span>
                        </c:when>
                        <c:otherwise>
                            <span class="inline"> ${entity.name}</span>
                        </c:otherwise>
                    </c:choose>
                </li>
            </ul>
        </div>
    </div>
    <!-- 面包屑 end -->
    <house365:flushMessage/>
    <div class="row-fluid">
        <c:if test="${displayBackToSeaDate == true}">
            <div class="span12">
                <span style="position: absolute;left: 40%;border-style: solid;padding: 20px;border-width: thin;border-color: #FFEED3;background-color: #FCF8E4;color: #896C3F;">
                    客户将在<c:out
                        value="${backToSeaDate}"/>返回公海，请及时跟进</span>
            </div>
        </c:if>
    </div>

    <div class="row${fluid}">
        <div class="span10 offset1">
            <div class="form-horizontal house365Page">
                <div class="house365Border">
                    <!-- 片段头 begin -->
                    <input name="entity.id" type="hidden" value="${entity.id}"/>

                    <input name="entity.managerId" type="hidden" value="${entity.managerId}"/>
                    <input id="phone" name="phone" type="hidden" value="${entity.phone}"/>

                    <input name="entity.remark" id="entity_remark" type="hidden" value="${entity.remark}"/>

                    <div class="sectionTitle" style="height:30px;">
                        基本信息
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label"><span style="color:red;">*</span> 客户姓名:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='edit'}">
                                        <input type="text" id="entity.name"
                                               name="entity.name"
                                               value="${entity.name}"/>
                                        <span color="red"><form:errors path="customerVo.entity.name"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.name}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                                <sapn><a href="#" onclick="getCRM(${entity.id})">查看CRM视图</a></sapn>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">手机号码:</label>
                            <div class="controls">
                                <span class="inline">${entity.phone}&nbsp;</span>
                                <c:if test="${hasPhone == 1}">
                                    <span id="star" class="icon-phone-sign"
                                          onclick="callCustomer('${entity.phone}','${entity.markedLabelId}','${entity.managerId}','${entity.id}','${entity.buyIntention}','0','${entity.isPeer}','${entity.starCustomer}')"></span>
                                </c:if>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">客户类型:</label>
                            <div class="controls">
                                ${entity.createSource}
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">安家顾问:</label>
                            <div class="controls">
                                ${entity.managerName}
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">性别:</label>
                            <div class="controls">
                                <input type="radio" name="entity.sex" value="2" <c:if test="${entity.sex eq '2'}">
                                       checked</c:if>>未知
                                <input type="radio" name="entity.sex" value="1" <c:if test="${entity.sex eq '1'}">
                                       checked</c:if>>男
                                <input type="radio" name="entity.sex" value="0" <c:if test="${entity.sex eq '0'}">
                                       checked</c:if>>女
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">其他号码1:</label>
                            <div class="controls">
                                <c:choose>
                                    <c:when test="${action=='edit'}">
                                        <input type="text" id="entity_bakPhone1"
                                               name="entity.bakPhone1" maxlength="11"
                                               value="${entity.bakPhone1}"/>
                                        <span color="red"><form:errors path="customerVo.entity.bakPhone1"/></span>
                                    </c:when>
                                    <c:otherwise>
                                        <span class="inline">${entity.bakPhone1}&nbsp;</span>
                                    </c:otherwise>
                                </c:choose>
                            </div>
                        </div>
                    </div>
                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">跟踪状态:</label>
                            <div class="controls">
                                <select name="entity.traceStatus" id="traceStatus">
                                    <option value="1"
                                            <c:if test="${'1' eq entity.traceStatus}">selected="selected"</c:if>>
                                        有效
                                    </option>
                                    <option value="2"
                                            <c:if test="${'2' eq entity.traceStatus}">selected="selected"</c:if>>
                                        已购
                                    </option>
                                    <option value="3"
                                            <c:if test="${'3' eq entity.traceStatus}">selected="selected"</c:if>>
                                        我购
                                    </option>
                                    <option value="4"
                                            <c:if test="${'4' eq entity.traceStatus}">selected="selected"</c:if>>
                                        暂缓
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="span5 control-group">
                            <label class="control-label">购房意向:</label>
                            <div class="controls">
                                <select name="entity.buyIntention" id="buyIntention" style="width: 208px;">
                                    <option value="">请选择</option>
                                    <c:forEach items="${fns:getDictList('crm_visit_result')}" var="dict">
                                        <c:if test="${dict.dicValue <= 5}">
                                            <option value="${dict.dicValue}"
                                                    <c:if test="${dict.dicValue eq entity.buyIntention}">selected="selected"</c:if>>${dict.dicName}
                                            </option>
                                        </c:if>
                                    </c:forEach>
                                </select>
                            </div>
                        </div>

                        <span> <input class="btn btn-primary" type="button" onclick="commitForm()" value="保存"/></span>
                    </div>

                    <div class="row-fluid">
                        <div class="span5 control-group">
                            <label class="control-label">标签:</label>
                            <span style="margin-left: 10px;"> <input class="btn btn-primary" type="button"
                                                                     onclick="addCustomerLabel()" value="添加标签"/></span>
                        </div>
                        <%--<div class="span5 control-group" id="platCreater" style="display: none;">--%>
                            <%--<label class="control-label">平台添加人:</label>--%>
                            <%--<div class="controls">--%>
                                <%--<c:choose>--%>
                                    <%--<c:when test="${entity.showPlatCreater eq '1'}">--%>
                                        <%--<span class="inline">${entity.creater}&nbsp;</span>--%>
                                    <%--</c:when>--%>
                                    <%--<c:otherwise>--%>
                                        <%--<span class="inline">&nbsp;</span>--%>
                                    <%--</c:otherwise>--%>
                                <%--</c:choose>--%>
                            <%--</div>--%>
                        <%--</div>--%>
                    </div>

                    <div class="row-fluid">
                        <div class="clearfix" style="padding-bottom: 15px;">
                            <div style="margin-top: 5px;float:left;margin-left: 15px;">
                                <c:forEach items="${labs}" var="lid">
                                    <c:if test="${1 eq lid.colorId}">
                                        <span class="tag-item gray"
                                              style="background-color: #999;border-color: transparent;" data-index="1">
                                                ${lid.labelName}
                                            <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                                  onclick="delCustomerLabel(${customerId},${lid.managerId},${lid.labelId})"></span>
                                        </span>

                                    </c:if>
                                    <c:if test="${2 eq lid.colorId}">
                                        <span class="tag-item red"
                                              style="background-color: #d9534f;border-color: transparent;"
                                              data-index="2">
                                                ${lid.labelName}
                                            <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                                  onclick="delCustomerLabel(${customerId},${lid.managerId},${lid.labelId})"></span>
                                        </span>
                                    </c:if>
                                    <c:if test="${3 eq lid.colorId}">
                                        <span class="tag-item orange"
                                              style="background-color: #f0ad4e;border-color: transparent;"
                                              data-index="3">
                                                ${lid.labelName}
                                           <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                                 onclick="delCustomerLabel(${customerId},${lid.managerId},${lid.labelId})"></span>
                                        </span>
                                    </c:if>
                                    <c:if test="${4 eq lid.colorId}">
                                        <span class="tag-item green"
                                              style="background-color: #5cb85c;border-color: transparent;"
                                              data-index="4">
                                                ${lid.labelName}
                                            <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                                  onclick="delCustomerLabel(${customerId},${lid.managerId},${lid.labelId})"></span>
                                        </span>
                                    </c:if>
                                    <c:if test="${5 eq lid.colorId}">
                                        <span class="tag-item blue"
                                              style="background-color: #5bc0de;border-color: transparent;"
                                              data-index="5">
                                                ${lid.labelName}
                                            <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                                  onclick="delCustomerLabel(${customerId},${lid.managerId},${lid.labelId})"></span>
                                        </span>
                                    </c:if>
                                    <c:if test="${6 eq lid.colorId}">
                                        <span class="tag-item darkblue"
                                              style="background-color: #0275d8;border-color: transparent;"
                                              data-index="6">
                                                ${lid.labelName}
                                            <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                                  onclick="delCustomerLabel(${customerId},${lid.managerId},${lid.labelId})"></span>
                                        </span>
                                    </c:if>
                                    <c:if test="${7 eq lid.colorId}">
                                        <span class="tag-item zi"
                                              style="background-color: #663399;border-color: transparent;"
                                              data-index="7">
                                                ${lid.labelName}
                                            <span class="glyphicon glyphicon-remove" aria-hidden="true"
                                                  onclick="delCustomerLabel(${customerId},${lid.managerId},${lid.labelId})"></span>
                                        </span>
                                    </c:if>
                                </c:forEach>
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;">
                        回访记录&约看记录
                    </div>
                    <div>
                        <div class="div-inline" style="width: 45%;margin-left: 2%;vertical-align: top;">
                            <span>回访记录</span>
                            <span style="margin-left: 10px;">
                                <shiro:hasPermission name="FUNC:ADDCALL">
                                    <button type="button" class="btn btn-primary btn-sm"
                                            onclick="addCallBack()">
                                        添加回访
                                    </button>
                                </shiro:hasPermission>
                            </span>
                            <div style="margin-top: 10px;border: 1px solid #ccc;padding: 10px;">
                                <c:forEach items="${callLogs}" var="call">
                                    <div class="row-fluid div-aaa">
                                        <div style="color: #ccc;margin-bottom: 10px;">
                                                ${call.managerName}
                                            <span style="float: right;color: #ccc">
                                                 <fmt:formatDate value='${call.createTime}'
                                                                 pattern='yyyy-MM-dd HH:mm:ss'/>
                                            </span>
                                        </div>

                                        <div style="margin-bottom: 10px;">
                                                ${call.content}
                                            <c:if test="${null ne call.callRecordName && '' ne call.callRecordName}">
                                                <span>
                                                    <audio controls>
                                                        <%--<source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path={{call.callRecordName}}">--%>
                                                        <source src="http://218.94.115.131:98/uncall_api/downloadFile.php?f_path=${call.callRecordName}">
                                                         Your browser does not support this audio format.
                                                    </audio>
                                                </span>
                                            </c:if>
                                        </div>
                                    </div>
                                </c:forEach>
                                <c:if test="${0 eq fn:length(callLogs)}">
                                    <div style="margin-bottom: 10px;">
                                        暂无回访记录！
                                    </div>
                                </c:if>
                            </div>
                        </div>
                        <div class="div-inline" style="width: 45%;margin-left: 2%;">
                            <span>约看记录</span>
                            <span style="margin-left: 10px;">
                                <button type="button" class="btn btn-primary btn-sm"
                                        onclick="assignHouseSingle(${entity.id})">约看客户</button>
                            </span>
                            <div style="border: 1px solid #ccc;margin-top: 10px;">
                                <table class="table table-bordered"
                                       style="width: 90%;margin-left: 5%;margin-top: 10px;">
                                    <thead>
                                    <tr>
                                        <th class="td" width="100">约看项目</th>
                                        <th class="td" width="100">客户状态</th>
                                        <th class="td" width="100">约看时间</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <c:if test="${0 eq fn:length(customerProjects)}">
                                        <tr>
                                            <td colspan="3" class="td">
                                                暂无约看记录！
                                            </td>
                                        </tr>
                                    </c:if>
                                    <c:forEach items="${customerProjects}" var="cp">
                                        <tr>
                                            <td class="td">
                                                <a href="${ctx}/customer/updateProjectInfo/${cp.id}"
                                                   target="_blank">${cp.projectName}</a>
                                            </td>
                                            <td class="td">
                                                <c:if test="${not empty cp.status}">
                                                    <c:choose>
                                                        <c:when test="${cp.status eq '1'}">
                                                            <span class="inline">约看</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '2'}">
                                                            <span class="inline">到访</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '3'}">
                                                            <span class="inline">认筹</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '4'}">
                                                            <span class="inline">认购</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '5'}">
                                                            <span class="inline">签约</span>
                                                        </c:when>
                                                        <c:when test="${cp.status eq '6'}">
                                                            <span class="inline">退房</span>
                                                        </c:when>
                                                    </c:choose>
                                                </c:if>
                                                <span style="color:red;">${cp.remark}</span>
                                            </td>
                                            <td class="td">
                                                <c:if test="${null ne cp.recordedTime}">
                                                    <f:formatDate value='${cp.recordedTime}'
                                                                  pattern='yyyy-MM-dd HH:mm:ss'/>
                                                </c:if>
                                            </td>
                                        </tr>
                                    </c:forEach>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="sectionTitle" style="height:30px;margin-top: 10px;">
                        客户情况与来源
                    </div>
                    <div class="row-fluid">
                        <table class="table table-bordered" style="width: 90%;margin-left: 5%;">
                            <thead>
                            <tr>
                                <th class="td" width="100">id</th>
                                <th class="td" width="100">来源类型</th>
                                <th class="td" width="100">最近来源</th>
                                <th class="td" width="100">活动名称</th>
                                <th class="td" width="100">CRM最近回访</th>
                                <th class="td" width="100">CRM回访结果</th>
                                <th class="td" width="100">添加时间</th>
                                <th class="td" width="100">平台添加人</th>
                            </tr>
                            </thead>
                            <tbody>
                            <c:forEach items="${oldList}" var="old">
                                <tr>
                                    <td class="td" width="100">${old.id}</td>
                                    <td class="td" width="100">${old.createSource}</td>
                                    <td class="td" width="100">${old.latestSource}</td>
                                    <td class="td" width="100">${old.actSource}</td>
                                    <td class="td" width="100">${old.crmLatestCall}</td>
                                    <td class="td" width="100">${old.crmLatestCallResult}</td>
                                    <td class="td">
                                        <c:if test="${null ne old.createTime}">
                                            <f:formatDate value='${old.createTime}' pattern='yyyy-MM-dd HH:mm:ss'/>
                                        </c:if>
                                    </td>
                                    <td class="td" width="100">
                                        <c:if test="${'平台导入' eq old.createSource}">${old.creater}</c:if>
                                        <c:if test="${'平台导入' ne old.createSource}"> </c:if>
                                    </td>
                                </tr>
                            </c:forEach>
                            </tbody>
                        </table>
                    </div>
                    <div class="sectionTitle" style="height:30px;">
                        客户日志
                    </div>
                    <ul>
                        <c:forEach items="${logList}" var="log">
                            <li>
                                <c:out value="${log}"/>
                            </li>
                        </c:forEach>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</form>

<script>
    var arr = new Array();
    var arr3 = new Array();
    var lids = '';
    $(function () {
        $('.header').click(function () {
            $(this).toggleClass('expand').nextUntil('tr.header').slideToggle(100);
        });

        $('.header').click();
        var labelFlag = ${labelFlag};
        if (labelFlag) {
            var lab = "${lids}";
            if (lab != undefined && lab != '') {
                lab = lab.substring(1, lab.length - 1);
                lab = lab.replace(/\s/g, "");
                arr = lab.split(",");
            }
        } else {
            console.log(lids);
        }
        var obj = $(".bt");
        for(var i=0;i< obj.length;i++){
            for(var j=0;j<arr.length;j++){
                if(obj[i].value == arr[j]){
                    console.log($(".bt")[i].value);
                    $(".bt")[i].click();
                }
            }

        }
        <%--var showPlatCreater = ${showPlatCreater};--%>
        <%--if(showPlatCreater !=null && showPlatCreater != '' && showPlatCreater != undefined  && '1' == showPlatCreater){--%>
            <%--$("#platCreater").css('display','block');--%>
<%--//            document.getElementById("platCreater").style.display = "block";--%>
        <%--}--%>
    });

    function addCustomerLabel() {
        var haslabel = "${haslabel}";
        var customerId = "${customerId}";
        if (haslabel != 1) {
            alert("暂无标签,请到标签管理中添加");
            return false;
        }
        $("#labelModel").modal('show');
    }

    function delCustomerLabel(customerId, managerId, labelId) {
        var waitFlag = "${waitFlag}";
        $.ajax({
            url: '/house365-hgs-web/labelmanager/delCustomerLabel?customerId=' + customerId + "&labelId=" + labelId + "&managerId=" + managerId +"&waitFlag=" + waitFlag,
            type: "DELETE",
            success: function (data) {
                if (data == "success") {
                    window.location.reload();
                } else {
                    alert("删除失败");
                    return false;
                }
            }
        });
    }

    function commitForm() {
        var phone1 = $("#entity_bakPhone1").val();
        if (phone1 != "" && !checkMobile(phone1)) {
            House365Util.createModal("提示", "其他号码1格式不正确", function () {
                $("#entity_bakPhone1").focus();
            });
            return false;
        }

        var buyIntention = $("#buyIntention").val();
        if (buyIntention == "" || buyIntention == null) {
            alert("购房意向未填写");
            return false;
        }

        if (buyIntention == 5) {
            House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
                $("#input_form").submit();
            });
        } else {
            $("#input_form").submit();
        }
    }

    function checkMobile(val) {
        var pattern = /(^(([0\+]\d{2,3}-)?(0\d{2,3})-)(\d{7,8})(-(\d{3,}))?$)|(^0{0,1}1[3|4|5|6|7|8|9][0-9]{9}$)/;
        if (pattern.test(val)) {
            return true;
        } else {
            return false;
        }
    }

    function assignHouseSingle(obj) {
        $.ajax({
            url: '/house365-hgs-web/customer/judgeSee',
            data: {
                "customerIds": obj
            },
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    House365Util.createRemoteModal("", "${ctx}/customer/assignProject?customerId=" + obj, null, function () {
                        var userIds = "";
                        if ($("#custom-headers").find("option:selected").length == 0) {
                            alert("约看项目不可为空!");
                            return false;
                        }

                        $("#custom-headers").find("option:selected").each(function () {
                            userIds = userIds + $(this).val() + ",";
                        });

                        if (obj == '') {
                            alert("至少要选择一个客户!");
                            return false;
                        }

                        $.ajax({
                            url: '${ctx}/customer/bindProject',
                            data: {"projectIds": userIds, "customerIds": obj},
                            type: "GET",
                            success: function (data) {
                                if (data.result == '1') {
                                    window.location.reload();
                                } else {
                                    alert("操作失败，" + data.msg);
                                }
                            }
                        });
                        return true;
                    });
                } else {
                    alert(data.errorMessage);
                }
            }
        })
    }

    function addCallBack() {
        var callContentHtml = "";
        var hasOwnlabel = ${hasOwnlabel};
        var phone = ${entity.phone};
        var managerId = ${entity.managerId};
        callContentHtml += "<div class='row-fluid'><div class='span5 control-group' style='position: relative'>"
            + " <label class='control-label'>购房意向：</label>"
            + "<div class='controls' style='position: absolute;top: -4px;left: 80px'><select name='entity.buyIntention' id='buyIntention2'>"
            + "<option value=''";
        <c:if test="${null eq entity.buyIntention or '' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">请选择</option><option value='1'";
        <c:if test="${'1' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">A</option><option value='2'";
        <c:if test="${'2' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">B</option><option value='3'";
        <c:if test="${'3' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">C</option><option value='4'";
        <c:if test="${'4' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">D</option><option value='5'";
        <c:if test="${'5' eq entity.buyIntention}">
        callContentHtml += "selected = 'selected'";
        </c:if>
        callContentHtml += ">E(丢入公海)</option>";
        callContentHtml += "</select>";
        callContentHtml += "<span style='margin-left: 200px;'>";

        var star = ${entity.starCustomer};
        if (star == 1) {
            callContentHtml += "<img style='margin-left: 200px;margin-top: -40px' id='starImage' class='collect' src='${ctx}/resources/img/collect_yes.png' alt=''>";
        } else {
            callContentHtml += "<img style='margin-left: 200px;margin-top: -40px' id='starImage' class='collect' src='${ctx}/resources/img/collect_no.png' alt=''>";
        }
        callContentHtml += "</span></div></div></div>";
        callContentHtml += "<div class='row-fluid'><div class='span5 control-group'  style='width: 100%;position: relative;'>"
            + " <label class='control-label'>回访内容：</label>";
        callContentHtml += "<p contenteditable='true' class='temp' cols='10' rows='5' style='margin: 0px 0px 10px; width: 436px; height: 70px;' id='callContent'>" +
            "<div style='position: absolute;bottom: 39px;width: 80%;left:85px'>" +
            "<c:forEach items='${callbackTemplateList}' var='item'>" +
            "<button type='button' class='btn bt_last' style='margin: 5px' onclick='setCallbackContent(this)'>${item.content}</button>" +
            "</c:forEach>" +
            "</div></p></div>";

        callContentHtml += "<div class='row-fluid'>" + "<div style='display: inline-flex;'><span>客户标签：</span>";
        if (hasOwnlabel == 1) {
            callContentHtml += "<div class='clearfix' style='display: flex;flex-wrap: wrap;width: 370px;\n" +
                "    line-height: 35px;\n" +
                "    height: auto;'>";
            callContentHtml += "<div style='margin-top: -5px;float:left;margin-left: 7px'>";

            callContentHtml += "<c:forEach items='${userLabelList}' var='lid'>";
            <c:choose>
                <c:when test="${1 eq lid.selected}">
                    callContentHtml += "<c:if test='${1 eq lid.colorId}'><span class='bat color_999' data-index='${lid.labelId}' opsel='' style='background-color: rgb(153, 153, 153); color: white;'>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${2 eq lid.colorId}'><span class='bat color_d9534f' data-index='${lid.labelId}' opsel='' style='background-color: rgb(217, 83, 79); color: white;'>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${3 eq lid.colorId}'><span class='bat color_f0ad4e' data-index='${lid.labelId}' opsel='' style='background-color: rgb(240, 173, 78); color: white;'>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${4 eq lid.colorId}'><span class='bat color_5cb85c' data-index='${lid.labelId}' opsel='' style='background-color: rgb(92, 184, 92); color: white;'>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${5 eq lid.colorId}'><span class='bat color_5bc0de' data-index='${lid.labelId}' opsel='' style='background-color: rgb(91, 192, 222); color: white;'>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${6 eq lid.colorId}'><span class='bat color_0275d8' data-index='${lid.labelId}' opsel='' style='background-color: rgb(2, 117, 216); color: white;'>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${7 eq lid.colorId}'><span class='bat color_663399' data-index='${lid.labelId}' opsel='' style='background-color: rgb(102, 51, 153); color: white;'>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";
                </c:when>
                <c:otherwise>
                    callContentHtml += "<c:if test='${1 eq lid.colorId}'><span class='bat color_999' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${2 eq lid.colorId}'><span class='bat color_d9534f' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${3 eq lid.colorId}'><span class='bat color_f0ad4e' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${4 eq lid.colorId}'><span class='bat color_5cb85c' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${5 eq lid.colorId}'><span class='bat color_5bc0de' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${6 eq lid.colorId}'><span class='bat color_0275d8' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";

                    callContentHtml += "<c:if test='${7 eq lid.colorId}'><span class='bat color_663399' data-index='${lid.labelId}' opsel=''>${lid.labelName}</span>";
                    callContentHtml += "</c:if>";
                </c:otherwise>
            </c:choose>
            callContentHtml += "</c:forEach></div></div></div></div>";
        } else {
            callContentHtml += "暂无标签,请到标签管理中添加</div></div>";
        }

        callContentHtml += "<div style='margin-top: 10px;'>" + "<span>回访提醒：</span>";
        callContentHtml += "<input type='text' style='width: 200px;margin-left: 12px' autocomplete='off' class='datetime-picker span2 input-large' id='returnTime' date-language='zh-CN' date-format='yyyy-mm-dd hh:ii:ss' placeholder='/年/月/日'>";
        callContentHtml += "</div>";

        var peer = ${entity.isPeer};
        if (peer == 0) {
            callContentHtml += "<div class='row-fluid'><div>" + "<span>中介同行：</span>" + "<input style='margin-left: 12px' type='radio' name='isPeer' value='0' checked>" + "否";
            callContentHtml += "<input style='margin-left: 20px;' type='radio' name='isPeer' value='1'>" + "是" + "</div></div>";
        } else if (peer == 1) {
            callContentHtml += "<div class='row-fluid'><div>" + "<span>中介同行：</span>" + "<input type='radio' name='isPeer' value='0'>" + "否";
            callContentHtml += "<input style='margin-left: 20px;' type='radio' name='isPeer' value='1' checked>" + "是" + "</div></div>";
        }

        House365Util.createModal("添加回访", callContentHtml, function () {
            var callContent = $("#callContent").text().replace(/(^\s*)|\s*$/g, '');
//            var callContent = $("#callContent").val().replace(/(^\s*)|\s*$/g, '');
            var ids = "";
            if (arr.length > 0) {
                for (var i = 0; i < arr.length; i++) {
                    ids += arr[i] + ",";
                }
            }
            if (ids.indexOf(",") != -1) {
                ids = ids.substring(0, ids.length - 1);
            }

            var buyIntention = $("#buyIntention2").val();
            var isPeer = $("input[name='isPeer']:checked").val();
            var customerId = ${entity.id};
            var returnTime = $("#returnTime").val();
            var starImage = $('#starImage').attr("src");
            var customerStar;
            if (starImage === '${ctx}/resources/img/collect_no.png') {
                customerStar = 0;
            } else {
                customerStar = 1;
            }

            if (buyIntention == null || buyIntention == '') {
                alert("请选择购房意向");
                return false;
            }
            if (returnTime != null && returnTime != '') {
                var date = new Date();
                var date1 = new Date(returnTime);
                if (date.getTime() > date1.getTime()) {
                    alert("回访提醒时间不能小于当前时间");
                    return;
                }
            }

            $("#hiddenBuyIntention").val(buyIntention);
            if (!callContent) {
                alert("回访内容不能为空");
                return false;
            } else if (callContent.length > 600) {
                alert("不能超过600个字");
                return false;
            } else if (buyIntention == 5) {
                House365Util.createModal("提示", "您确定要将客户移入公海吗？", function () {
                    $.ajax({
                        url: '${ctx}/customer/addCall',
                        data: {
                            "content": callContent,
                            "customerId": ${entity.id},
                            "labelIds": ids,
                            "phone": phone,
                            "buyIntention": buyIntention
                        },
                        type: "GET",
                        success: function (data) {
                            if (data.result == '1') {
                                //更新客户是否中介同行状态
                                $.ajax({
                                    url: '${ctx}/customermanagement/updatePeerAndTime/' + 1,
                                    contentType: 'application/json',
                                    data: JSON.stringify({
                                        id: customerId,
                                        isPeer: isPeer,
                                        buyIntention: buyIntention,
                                        starCustomer: customerStar,
                                        returnRemindTime: returnTime
                                    }),
                                    dataType: 'json',
                                    type: "POST",
                                    success: function (data) {
                                        if (data.status == 0) {
                                            window.location.href = "${ctx}/customermanagement/myCustomerNew";
                                        } else {
                                            alert(data.errorMessage);
                                        }
                                    }
                                });

                            } else {
                                alert("操作失败，" + data.msg);
                            }
                        }
                    });

                });
                return false;
            } else {
                $.ajax({
                    url: '${ctx}/customer/addCall',
                    data: {
                        "content": callContent,
                        "customerId": ${entity.id},
                        "labelIds": ids,
                        "phone": phone,
                        "buyIntention": buyIntention
                    },
                    type: "GET",
                    success: function (data) {
                        if (data.result == '1') {
                            //更新客户是否中介同行状态
                            $.ajax({
                                url: '${ctx}/customermanagement/updatePeerAndTime/' + 1,
                                contentType: 'application/json',
                                data: JSON.stringify({
                                    id: ${entity.id},
                                    isPeer: isPeer,
                                    starCustomer: customerStar,
                                    buyIntention: buyIntention,
                                    returnRemindTime: returnTime
                                }),
                                dataType: 'json',
                                type: "POST",
                                success: function (data) {
                                    if (data.status == 0) {
                                        window.location.reload();
                                    } else {
                                        alert(data.errorMessage);
                                    }
                                }
                            });
                        } else {
                            alert("操作失败，" + data.msg);
                        }
                    }
                });
            }
        });
    }

    function getCRM(customerId) {
        $.ajax({
            url: '${ctx}/customer/getCRMURL',
            data: {"customerId": customerId},
            type: "GET",
            success: function (data) {
                if (data.result == '1') {
                    if (data.data.entity == "") {
                        alert("该用户暂未推送至CRM");
                        return false;
                    }
                    window.open(data.data.entity);
                } else {
                    alert("操作失败，" + data.msg);
                }
            }
        });
    }

    $(document).on('click', '.bat', function () {
//        var bor_color = $(this).css("border-color");
        var bor_color = $(this).css("borderRightColor");
        var bg_color = $(this).css("background-color");
        var labelIds = $("#labelIds").val();


        if (bg_color === 'rgb(255, 255, 255)') {
            $(this).css("background-color", bor_color);
            $(this).css("color", "white");
            $(this).attr("opsel", 1);
            var lid = $(this).attr("data-index");
            arr.push(lid);
//            labelIds +=lid +",";
//            $("#labelIds").val(labelIds);
        } else {
            $(this).css("background-color", "rgb(255, 255, 255)");
            $(this).css("color", bor_color);
            $(this).attr("opsel", 0);
            var lid = $(this).attr("data-index");
//            labelIds = labelIds.replace(lid, '');
//            $("#labelIds").val(labelIds);
            for (var i = 0; i < arr.length; i++) {
                if (arr[i] == lid) {
                    arr.splice(i, 1);
                }
            }
//            console.log(arr(lid));
//            console.log(arr.indexOf(arr[lid]));
//            arr = arr.splice(arr.indexOf(arr[lid]),1);
        }
    });

    var curnet = "${sessionUser.cornet}";

    function setCallbackContent(template) {
        var content = $(template).text();
        var obj = document.getElementById("callContent");
        obj.innerHTML = content;
//        $("#callContent").=content;
    }

    function callCustomer(memPhone, markedLabelId, managerId, customerId, buyIntention, abandon, isPeer, star) {
        $.ajax({
            url: "${ctx}/cityCall/judgeCall",
            data: '',
            type: "get",
            dataType: 'json',
            success: function (result) {
                if (result.status == 0) {
                    if (curnet == "") {
                        House365Util.createModal("电话回访",
                            "对不起，您尚未填写固定电话短号，请前往个人中心设置", function () {
                                window.location.href = "${ctx}/role/edit/${sessionUserId}";
                            }, "前往设置");
                        return;
                    }

                    $("#callDialog").load("${ctx}/customermanagement/callCustomer?memPhone=" + memPhone + "&markedLabelId=" + markedLabelId + "&managerId=" + managerId + "&customerId=" + customerId
                        + "&buyIntention=" + buyIntention + "&abandon=" + abandon + "&isPeer=" + isPeer + "&star=" + star, null, function () {

                        $("#returnTime2").datetimepicker({
                            format: 'yyyy-mm-dd hh:ii:ss',
                            maxView: "decade",
                            minView: "hour",
                            startView: "month",
                            autoclose: true,
                            language: 'zh-CN',
                            viewSelect: "decade",
                            minuteStep: 10,
                            pickerPosition: "bottom-left"
                        });
                    });
                    $("#callDialog").dialog({
                        closeOnEscape: false,
                        autoOpen: false,
                        draggable: false,
                        modal: true,
                        open: function (event, ui) {
                            $(".ui-dialog-titlebar-close", $(this).parent()).hide();
                        },
                        show: {
                            effect: "blind",
                            duration: 100
                        },
                        hide: {
                            effect: "explode",
                            duration: 100
                        },
                        width: 600
                    }).dialog("open");
                }
            }
        });
    }

    function saveLabel() {
        var customerIds = [];
        var customerId = "${customerId}";
        var phone = $("#phone").val();
        var managerId = "${managerId}";
        var waitFlag = "${waitFlag}";
        customerIds.push(customerId);
        var data = {labelIdList: resultNum, customerIdList: customerIds, phone:phone, managerId:managerId, detailType:waitFlag};
        data = JSON.stringify(data);
        $.ajax({
            url: '${ctx}/labelmanager/saveCustomersLabel',
            type: 'POST',
            contentType: 'application/json',
            data: data,
            dataType: 'json',
            cache: false,
            success: function (result) {
                if (result.status == 0) {
                    alert("新增成功！");
                    $("#labelModel").modal('hide');
                    window.location.reload();
                } else {
                    alert(result.errorMessage);
                }
            }
        });
    }

    var resultNum = [];
    $(document).on('click', '.bt', function () {
        var bor_color = $(this).css("borderRightColor");
        var bg_color = $(this).css("background-color");
        if (bg_color === 'rgb(255, 255, 255)') {
            if(arr3.indexOf($(this).attr("value")) == -1){
                resultNum.push($(this).attr("value"));
            }
            $(this).css("background-color", bor_color);
            $(this).css("color", "white");
        } else {
            resultNum.splice(resultNum.indexOf($(this).attr("value")), 1);
            $(this).css("background-color", "rgb(255, 255, 255)");
            $(this).css("color", bor_color);
        }
    });

    $(document).on('click', '.collect', function () {
        var customerId = ${entity.id};
        $.ajax({
            url: '${ctx}/customermanagement/judgeStar/' + customerId,
            type: "GET",
            success: function (data) {
                if (data.status == 0) {
                    var img_src = $('#starImage').attr("src");
                    if (img_src === '${ctx}/resources/img/collect_no.png') {
                        $('#starImage').attr("src", "${ctx}/resources/img/collect_yes.png")
                    } else {
                        $('#starImage').attr("src", "${ctx}/resources/img/collect_no.png")
                    }
                } else {
                    alert(data.errorMessage);
                }
            }
        });
    });

</script>
<link rel="stylesheet" href="${static_common}/jquery.qtip.custom/jquery.qtip.min.css" type="text/css">
<link rel="stylesheet" type="text/css" href="${static_common}/jquery-ui/jquery-ui.min.css"/>
<script src="${static_common}/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>

<div id="callDialog" style="display: none" title="电话回访"></div>

<div class="modal fade" id="labelModel" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                <h5 class="modal-title" id="myModalLabel">添加标签</h5>
            </div>
            <div class="modal-body">
                <div>
                    <span>请选择客户标签1：</span>
                    <div style="margin-top: 10px;">
                        <%--客户标签模板--%>
                        <c:forEach items="${userLabelList}" var="item">
                            <c:if test="${1 eq item.colorId}">
                                <button id="color1" class="bt color_999" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${2 eq item.colorId}">
                                <button id="color2" class="bt color_d9534f" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${3 eq item.colorId}">
                                <button id="color3" class="bt color_f0ad4e" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${4 eq item.colorId}">
                                <button id="color4" class="bt color_5cb85c" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${5 eq item.colorId}">
                                <button id="color5" class="bt color_5bc0de" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${6 eq item.colorId}">
                                <button id="color6" class="bt color_0275d8" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                            <c:if test="${7 eq item.colorId}">
                                <button id="color7" class="bt color_663399" style="margin: 5px"
                                        value="${item.labelId}">${item.labelName}</button>
                            </c:if>
                        </c:forEach>
                    </div>
                </div>
            </div>
            <div id="btnGive" class="modal-footer">
                <button type="button" class="btn btn-primary" onclick="saveLabel()">确认</button>
                <button type="button" class="btn btn-default" data-dismiss="modal">取消</button>
            </div>
        </div>
    </div>
</div>

</body>

</html>
