<%@ tag pageEncoding="UTF-8"%>
<%@ attribute name="title" type="java.lang.String" rtexprvalue="true" required="true" %>
<%@ attribute name="resourceId" type="java.lang.Integer" rtexprvalue="true" required="true" %>
<%@ attribute name="resourceType" type="java.lang.String" rtexprvalue="true" required="true" %>
<%@ attribute name="bizType" type="java.lang.Integer" rtexprvalue="true" required="false" %>
<%@ attribute name="editAble" type="java.lang.Boolean" rtexprvalue="true" required="true" description=""%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<c:set var="ctx" value="${pageContext.request.contextPath}"/>
<script type="text/javascript" src="${ctx}/resources/customize/js/ajaxfileupload.js"></script>

<script type="text/javascript" language="javascript">
    $(document).ready(function () {
        $("#${resourceType}_${bizType}_upload").click(function() {
			House365Util.createRemoteModal("${title}",
				"${ctx}/attachment/sampleAttachmentToAddSection/${resourceType}/${resourceId}?bizType=${bizType}", {},
				function() {
					var $uploadForm = $("#upload_form");
					var validValue = $uploadForm.valid();
					if( validValue ){
						 $.ajaxFileUpload({
                                // 文件上传服务器地址
                                url : $uploadForm.attr("action")+"&bizType="+$("#bizType").val(),
                                // 文件上传服务器地址
                                fileElementId : "file",
                                // 响应类型
                                //dataType : "json",
                                date: $uploadForm.serialize(),
                                success : function(data, status) {
                                	var $listContainer = $("#${resourceType}_${bizType}_list_container");
                                	House365Util.ajaxTurn2Page($listContainer,$listContainer.attr("base-url"),1);
                                       $('#modal_dialog').modal('hide');
                                       window.location.reload();
                                },
                                error : function(data, status, e) {
                                    // 失败后操作
                                    alert("上传失败，请联系管理员！");
                                }
							}
						);
					}
                    return false;
				}, "确定", "btn-success", "取消", "btn-danger");
		});
    })
</script>

<div class="sectionTitle">
	<div class="portlet-title">
		<h4>${title}</h4>
		<c:if test="${editAble }">
			<div class="tools">
				<a href="#" class="icon icon-plus" id="${resourceType}_${bizType}_upload"
					title="增加图片"></a>
			</div>
		</c:if>
	</div>
</div>
<div id="${resourceType}_${bizType}_list_container" class="portlet-body lazy-section" base-url="${ctx}/attachment/sampleAttachmentListSection/${resourceType}/${resourceId}/${editAble}?bizType=${bizType}">
</div>
