package com.house365.web.util;

import com.house365.beans.entity.DepartmentEntity;
import com.house365.rest.context.ServiceConstant;
import com.house365.rest.exception.ServiceException;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class PathUtil {

    public static String extractDeptPath(String path) {
        if (null == path) {
            throw new RuntimeException("path is null");
        }
        String[] split = path.split("/");
        if (split.length == 2) {
            return path;
        } else if (split.length > 2) {
            StringBuilder sb = new StringBuilder();
            return sb.append("/").append(split[1]).append("/").append(split[2]).toString();
        }
        return "";
    }

    public static Integer extractDept(String path) {
        if (null == path) {
            throw new RuntimeException("path is null");
        }
        String[] split = path.split("/");
        if (split.length == 2) {
            return Integer.valueOf(split[1]);
        } else if (split.length > 2) {
            return Integer.valueOf(split[2]);
        }
        return null;
    }

    public static boolean isAdminDept(DepartmentEntity dept) {
        return dept.getParentId() == null ? true : false;
    }

    public static boolean isAdminDept(String deptPath) {
        if (null == deptPath) {
            throw new RuntimeException("path is null");
        }
        String[] split = deptPath.split("/");
        if (split.length == 2) {
            return true;
        } else {
            return false;
        }
    }
}
