package com.house365.beans.vo;

import com.house365.beans.system.DomainObject;
import com.house365.web.util.DateTimeUtils;

import java.util.Date;
import java.util.List;

/**
 * <p>Title: </p>
 * <p>Description: </p>
 * <p>Date: 2017/3/20</p>
 *
 * @author XN
 * @version 1.0
 */
public class WechatCustomerListVO extends DomainObject {

    public WechatCustomerListVO(
        Integer id, String name, String phone, Integer sex, String actSource, Integer status, Date createTime,
        String buyIntention, Date lastVisitTime, Date lastCallTime, Integer managerId, String managerName,
        Integer traceStatus, String content, String newFlag, String star, String starUserId, List<Object> lids,String currentSystemId
    ) {
        super(id);
        this.name = name;
        this.phone = phone;
        this.sex = sex;
        this.actSource = actSource;
        this.status = status;
        this.createTime = createTime;
        this.buyIntention = buyIntention;
        this.lastVisitTime = lastVisitTime;
        this.lastCallTime = lastCallTime;
        this.managerId = managerId;
        this.managerName = managerName;
        this.createTimeStr = DateTimeUtils.getDateString(createTime, DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_FULL);
        this.lastCallTimeStr = DateTimeUtils.getDateString(lastVisitTime,
                                                           DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_FULL);
        this.lastCallTimeStr = DateTimeUtils.getDateString(lastCallTime,
                                                           DateTimeUtils.DEFAULT_DATE_FORMAT_PATTERN_FULL);
        this.traceStatus = traceStatus;
        this.content = content;
        this.newFlag = newFlag;
        this.star = star;
        this.starUserId = starUserId;
        this.lids = lids;
        this.currentSystemId = currentSystemId;
    }
    private String currentSystemId;

    private String starUserId;

    private String star;

    private List<Object> lids;

    public List<Object> getLids() {
        return lids;
    }

    public void setLids(List<Object> lids) {
        this.lids = lids;
    }

    private String name;

    private String phone;

    private Integer sex;

    private String actSource;

    private Integer status;

    private Integer traceStatus;

    private String buyIntention;

    private Integer managerId;

    private String managerName;

    private java.util.Date createTime;

    private java.util.Date lastVisitTime;

    private java.util.Date lastCallTime;

    private String createTimeStr;

    private String lastVisitTimeStr;

    private String lastCallTimeStr;

    //最后一次回访记录
    private String content;

    //显示是否有更新 1有0否
    private String newFlag;

    public String getCurrentSystemId() {
        return currentSystemId;
    }

    public void setCurrentSystemId(String currentSystemId) {
        this.currentSystemId = currentSystemId;
    }

    public String getStarUserId() {
        return starUserId;
    }

    public void setStarUserId(String starUserId) {
        this.starUserId = starUserId;
    }

    public String getStar() {
        return star;
    }

    public void setStar(String star) {
        this.star = star;
    }

    public String getNewFlag() {
        return newFlag;
    }

    public void setNewFlag(String newFlag) {
        this.newFlag = newFlag;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Integer getTraceStatus() {
        return traceStatus;
    }

    public void setTraceStatus(Integer traceStatus) {
        this.traceStatus = traceStatus;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getSex() {
        return sex;
    }

    public void setSex(Integer sex) {
        this.sex = sex;
    }

    public String getActSource() {
        return actSource;
    }

    public void setActSource(String actSource) {
        this.actSource = actSource;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getBuyIntention() {
        return buyIntention;
    }

    public void setBuyIntention(String buyIntention) {
        this.buyIntention = buyIntention;
    }

    public Date getLastVisitTime() {
        return lastVisitTime;
    }

    public void setLastVisitTime(Date lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    public Date getLastCallTime() {
        return lastCallTime;
    }

    public void setLastCallTime(Date lastCallTime) {
        this.lastCallTime = lastCallTime;
    }

    public Integer getManagerId() {
        return managerId;
    }

    public void setManagerId(Integer managerId) {
        this.managerId = managerId;
    }

    public String getManagerName() {
        return managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public String getCreateTimeStr() {
        return createTimeStr;
    }

    public void setCreateTimeStr(String createTimeStr) {
        this.createTimeStr = createTimeStr;
    }

    public String getLastVisitTimeStr() {
        return lastVisitTimeStr;
    }

    public void setLastVisitTimeStr(String lastVisitTimeStr) {
        this.lastVisitTimeStr = lastVisitTimeStr;
    }

    public String getLastCallTimeStr() {
        return lastCallTimeStr;
    }

    public void setLastCallTimeStr(String lastCallTimeStr) {
        this.lastCallTimeStr = lastCallTimeStr;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        if (!super.equals(o))
            return false;

        WechatCustomerListVO that = (WechatCustomerListVO) o;

        if (name != null ? !name.equals(that.name) : that.name != null)
            return false;
        if (phone != null ? !phone.equals(that.phone) : that.phone != null)
            return false;
        if (sex != null ? !sex.equals(that.sex) : that.sex != null)
            return false;
        if (actSource != null ? !actSource.equals(that.actSource) : that.actSource != null)
            return false;
        if (status != null ? !status.equals(that.status) : that.status != null)
            return false;
        if (buyIntention != null ? !buyIntention.equals(that.buyIntention) : that.buyIntention != null)
            return false;
        if (managerId != null ? !managerId.equals(that.managerId) : that.managerId != null)
            return false;
        if (managerName != null ? !managerName.equals(that.managerName) : that.managerName != null)
            return false;
        if (createTime != null ? !createTime.equals(that.createTime) : that.createTime != null)
            return false;
        if (lastVisitTime != null ? !lastVisitTime.equals(that.lastVisitTime) : that.lastVisitTime != null)
            return false;
        if (lastCallTime != null ? !lastCallTime.equals(that.lastCallTime) : that.lastCallTime != null)
            return false;
        if (createTimeStr != null ? !createTimeStr.equals(that.createTimeStr) : that.createTimeStr != null)
            return false;
        if (lastVisitTimeStr != null ? !lastVisitTimeStr.equals(that.lastVisitTimeStr) : that.lastVisitTimeStr != null)
            return false;
        if (lastCallTimeStr != null ? !lastCallTimeStr.equals(that.lastCallTimeStr) : that.lastCallTimeStr != null)
            return false;

        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (name != null ? name.hashCode() : 0);
        result = 31 * result + (phone != null ? phone.hashCode() : 0);
        result = 31 * result + (sex != null ? sex.hashCode() : 0);
        result = 31 * result + (actSource != null ? actSource.hashCode() : 0);
        result = 31 * result + (status != null ? status.hashCode() : 0);
        result = 31 * result + (buyIntention != null ? buyIntention.hashCode() : 0);
        result = 31 * result + (managerId != null ? managerId.hashCode() : 0);
        result = 31 * result + (managerName != null ? managerName.hashCode() : 0);
        result = 31 * result + (createTime != null ? createTime.hashCode() : 0);
        result = 31 * result + (lastVisitTime != null ? lastVisitTime.hashCode() : 0);
        result = 31 * result + (lastCallTime != null ? lastCallTime.hashCode() : 0);
        result = 31 * result + (createTimeStr != null ? createTimeStr.hashCode() : 0);
        result = 31 * result + (lastVisitTimeStr != null ? lastVisitTimeStr.hashCode() : 0);
        result = 31 * result + (lastCallTimeStr != null ? lastCallTimeStr.hashCode() : 0);
        return result;
    }
}
