/**
 * Description: 客户信息页面表单对象
 * Copyright:   Copyright (c)2016
 * Company:     江苏三六五网络股份有限公司
 *
 * @author: 江苏三六五网络股份有限公司
 * @version: 1.0
 * Create at:   2016-09-15 下午 15:36:13
 * <p>
 * Modification History:
 * Date         Author      Version     Description
 * ------------------------------------------------------------------
 * 2016-09-15   江苏三六五网络股份有限公司   1.0         Initial
 */
package com.house365.beans.vo;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

import com.house365.beans.entity.CustomerEntity;

/**
 * 客户信息页面表单对象<br>
 *
 * @author 江苏三六五网络股份有限公司
 * @version 1.0, 2016-09-15
 * @see
 * @since 1.0
 */
public class CustomerVo {
    /**
     * 客户信息实体
     */
    @NotNull
    @Valid
    private CustomerEntity entity;

    @NotNull
    @Valid
    private CustomerEntity customer;

    /**
     * 设置客户信息实体
     * @param entity 客户信息实体
     */
    public void setEntity(CustomerEntity entity) {
        this.entity = entity;
    }

    /**
     * 获取客户信息实体
     * @return 客户信息实体
     */
    public CustomerEntity getEntity() {
        return this.entity;
    }

    public CustomerEntity getCustomer() {
        return customer;
    }

    public void setCustomer(CustomerEntity customer) {
        this.customer = customer;
    }
}
